/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.binding.annotations;

import java.util.Set;
import java.util.logging.Logger;
import org.teleal.cling.binding.LocalServiceBindingException;
import org.teleal.cling.binding.annotations.AnnotationLocalServiceBinder;
import org.teleal.cling.binding.annotations.UpnpStateVariable;
import org.teleal.cling.model.ModelUtil;
import org.teleal.cling.model.meta.StateVariable;
import org.teleal.cling.model.meta.StateVariableAllowedValueRange;
import org.teleal.cling.model.meta.StateVariableEventDetails;
import org.teleal.cling.model.meta.StateVariableTypeDetails;
import org.teleal.cling.model.state.StateVariableAccessor;
import org.teleal.cling.model.types.Datatype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationStateVariableBinder {
    private static Logger log = Logger.getLogger(AnnotationLocalServiceBinder.class.getName());
    protected UpnpStateVariable annotation;
    protected String name;
    protected StateVariableAccessor accessor;
    protected Set<Class> stringConvertibleTypes;

    public AnnotationStateVariableBinder(UpnpStateVariable annotation, String name, StateVariableAccessor accessor, Set<Class> stringConvertibleTypes) {
        this.annotation = annotation;
        this.name = name;
        this.accessor = accessor;
        this.stringConvertibleTypes = stringConvertibleTypes;
    }

    public UpnpStateVariable getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public StateVariableAccessor getAccessor() {
        return this.accessor;
    }

    public Set<Class> getStringConvertibleTypes() {
        return this.stringConvertibleTypes;
    }

    protected StateVariable createStateVariable() throws LocalServiceBindingException {
        boolean sendEvents;
        log.fine("Creating state variable '" + this.getName() + "' with accessor: " + this.getAccessor());
        Datatype datatype = this.createDatatype();
        String defaultValue = this.createDefaultValue(datatype);
        String[] allowedValues = null;
        if (Datatype.Builtin.STRING.equals((Object)datatype.getBuiltin())) {
            if (this.getAnnotation().allowedValues().length > 0) {
                allowedValues = this.getAnnotation().allowedValues();
            } else if (this.getAnnotation().allowedValuesEnum() != Void.TYPE) {
                allowedValues = this.getAllowedValues(this.getAnnotation().allowedValuesEnum());
            } else if (this.getAccessor() != null && this.getAccessor().getReturnType().isEnum()) {
                allowedValues = this.getAllowedValues(this.getAccessor().getReturnType());
            } else {
                log.finer("Not restricting allowed values (of string typed state var): " + this.getName());
            }
            if (allowedValues != null && defaultValue != null) {
                boolean foundValue = false;
                for (String s : allowedValues) {
                    if (!s.equals(defaultValue)) continue;
                    foundValue = true;
                    break;
                }
                if (!foundValue) {
                    throw new LocalServiceBindingException("Default value '" + defaultValue + "' is not in allowed values of: " + this.getName());
                }
            }
        }
        StateVariableAllowedValueRange allowedValueRange = null;
        if (Datatype.Builtin.isNumeric(datatype.getBuiltin()) && this.getAnnotation().allowedValueMinimum() > 0L || this.getAnnotation().allowedValueMaximum() > 0L) {
            allowedValueRange = this.getAllowedValueRange();
            if (defaultValue != null && allowedValueRange != null) {
                long v;
                try {
                    v = Long.valueOf(defaultValue);
                }
                catch (Exception ex) {
                    throw new LocalServiceBindingException("Default value '" + defaultValue + "' is not numeric (for range checking) of: " + this.getName());
                }
                if (!allowedValueRange.isInRange(v)) {
                    throw new LocalServiceBindingException("Default value '" + defaultValue + "' is not in allowed range of: " + this.getName());
                }
            }
        }
        if ((sendEvents = this.getAnnotation().sendEvents()) && this.getAccessor() == null) {
            throw new LocalServiceBindingException("State variable sends events but has no accessor for field or getter: " + this.getName());
        }
        int eventMaximumRateMillis = 0;
        int eventMinimumDelta = 0;
        if (sendEvents) {
            if (this.getAnnotation().eventMaximumRateMilliseconds() > 0) {
                log.finer("Moderating state variable events using maximum rate (milliseconds): " + this.getAnnotation().eventMaximumRateMilliseconds());
                eventMaximumRateMillis = this.getAnnotation().eventMaximumRateMilliseconds();
            }
            if (this.getAnnotation().eventMinimumDelta() > 0 && Datatype.Builtin.isNumeric(datatype.getBuiltin())) {
                log.finer("Moderating state variable events using minimum delta: " + this.getAnnotation().eventMinimumDelta());
                eventMinimumDelta = this.getAnnotation().eventMinimumDelta();
            }
        }
        StateVariableTypeDetails typeDetails = new StateVariableTypeDetails(datatype, defaultValue, allowedValues, allowedValueRange);
        StateVariableEventDetails eventDetails = new StateVariableEventDetails(sendEvents, eventMaximumRateMillis, eventMinimumDelta);
        return new StateVariable(this.getName(), typeDetails, eventDetails);
    }

    protected Datatype createDatatype() throws LocalServiceBindingException {
        String declaredDatatype = this.getAnnotation().datatype();
        if (declaredDatatype.length() == 0 && this.getAccessor() != null) {
            Class<?> returnType = this.getAccessor().getReturnType();
            log.finer("Using accessor return type as state variable type: " + returnType);
            if (ModelUtil.isStringConvertibleType(this.getStringConvertibleTypes(), returnType)) {
                log.finer("Return type is string-convertible, using string datatype");
                return Datatype.Default.STRING.getBuiltinType().getDatatype();
            }
            Datatype.Default defaultDatatype = Datatype.Default.getByJavaType(returnType);
            if (defaultDatatype != null) {
                log.finer("Return type has default UPnP datatype: " + (Object)((Object)defaultDatatype));
                return defaultDatatype.getBuiltinType().getDatatype();
            }
        }
        if (!(declaredDatatype != null && declaredDatatype.length() != 0 || this.getAnnotation().allowedValues().length <= 0 && this.getAnnotation().allowedValuesEnum() == Void.TYPE)) {
            log.finer("State variable has restricted allowed values, hence using 'string' datatype");
            declaredDatatype = "string";
        }
        if (declaredDatatype == null || declaredDatatype.length() == 0) {
            throw new LocalServiceBindingException("Could not detect datatype of state variable: " + this.getName());
        }
        log.finer("Trying to find built-in UPnP datatype for detected name: " + declaredDatatype);
        Datatype.Builtin builtin = Datatype.Builtin.getByDescriptorName(declaredDatatype);
        if (builtin != null) {
            log.finer("Found built-in UPnP datatype: " + (Object)((Object)builtin));
            return builtin.getDatatype();
        }
        throw new LocalServiceBindingException("No built-in UPnP datatype found, using CustomDataType (TODO: NOT IMPLEMENTED)");
    }

    protected String createDefaultValue(Datatype datatype) throws LocalServiceBindingException {
        if (this.getAnnotation().defaultValue().length() != 0) {
            try {
                datatype.valueOf(this.getAnnotation().defaultValue());
                log.finer("Found state variable default value: " + this.getAnnotation().defaultValue());
                return this.getAnnotation().defaultValue();
            }
            catch (Exception ex) {
                throw new LocalServiceBindingException("Default value doesn't match datatype of state variable '" + this.getName() + "': " + ex.getMessage());
            }
        }
        return null;
    }

    protected String[] getAllowedValues(Class enumType) throws LocalServiceBindingException {
        if (!enumType.isEnum()) {
            throw new LocalServiceBindingException("Allowed values type is not an Enum: " + enumType);
        }
        log.finer("Restricting allowed values of state variable to Enum: " + this.getName());
        String[] allowedValueStrings = new String[enumType.getEnumConstants().length];
        for (int i = 0; i < enumType.getEnumConstants().length; ++i) {
            Object o = enumType.getEnumConstants()[i];
            if (o.toString().length() > 32) {
                throw new LocalServiceBindingException("Allowed value string (that is, Enum constant name) is longer than 32 characters: " + o.toString());
            }
            log.finer("Adding allowed value (converted to string): " + o.toString());
            allowedValueStrings[i] = o.toString();
        }
        return allowedValueStrings;
    }

    protected StateVariableAllowedValueRange getAllowedValueRange() throws LocalServiceBindingException {
        if (this.getAnnotation().allowedValueMaximum() < this.getAnnotation().allowedValueMinimum()) {
            throw new LocalServiceBindingException("Allowed value range maximum is smaller than minimum: " + this.getName());
        }
        return new StateVariableAllowedValueRange(this.getAnnotation().allowedValueMinimum(), this.getAnnotation().allowedValueMaximum(), this.getAnnotation().allowedValueStep());
    }
}

