/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import java.util.logging.Logger;
import org.teleal.cling.UpnpServiceConfiguration;
import org.teleal.cling.model.ModelUtil;
import org.teleal.cling.protocol.ProtocolFactory;
import org.teleal.cling.transport.Router;
import org.teleal.cling.transport.SwitchableRouterImpl;
import org.teleal.cling.transport.spi.InitializationException;

public class AndroidWifiSwitchableRouter
extends SwitchableRouterImpl {
    private static Logger log = Logger.getLogger(Router.class.getName());
    final BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                return;
            }
            NetworkInfo wifiInfo = AndroidWifiSwitchableRouter.this.getConnectivityManager().getNetworkInfo(1);
            if (!wifiInfo.isConnected()) {
                log.info("WiFi state changed, trying to disable router");
                AndroidWifiSwitchableRouter.this.disable();
            } else {
                log.info("WiFi state changed, trying to enable router");
                AndroidWifiSwitchableRouter.this.enable();
            }
        }
    };
    private final WifiManager wifiManager;
    private final ConnectivityManager connectivityManager;
    private WifiManager.MulticastLock multicastLock;

    public AndroidWifiSwitchableRouter(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory, WifiManager wifiManager, ConnectivityManager connectivityManager) {
        super(configuration, protocolFactory);
        this.wifiManager = wifiManager;
        this.connectivityManager = connectivityManager;
        NetworkInfo wifiInfo = this.getConnectivityManager().getNetworkInfo(1);
        if (wifiInfo.isConnected() || ModelUtil.ANDROID_EMULATOR) {
            log.info("WiFi is enabled (or running on Android emulator), starting router immediately");
            this.enable();
        }
    }

    public BroadcastReceiver getBroadcastReceiver() {
        return this.broadcastReceiver;
    }

    protected WifiManager getWifiManager() {
        return this.wifiManager;
    }

    protected ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enable() throws SwitchableRouterImpl.RouterLockAcquisitionException {
        this.lock(this.writeLock);
        try {
            boolean enabled = super.enable();
            if (enabled) {
                this.multicastLock = this.getWifiManager().createMulticastLock(this.getClass().getSimpleName());
                this.multicastLock.acquire();
            }
            boolean bl = enabled;
            return bl;
        }
        finally {
            this.unlock(this.writeLock);
        }
    }

    public void handleStartFailure(InitializationException ex) {
        if (this.multicastLock != null && this.multicastLock.isHeld()) {
            this.multicastLock.release();
            this.multicastLock = null;
        }
        super.handleStartFailure(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disable() throws SwitchableRouterImpl.RouterLockAcquisitionException {
        this.lock(this.writeLock);
        try {
            if (this.multicastLock != null && this.multicastLock.isHeld()) {
                this.multicastLock.release();
                this.multicastLock = null;
            }
            boolean bl = super.disable();
            return bl;
        }
        finally {
            this.unlock(this.writeLock);
        }
    }

    protected int getLockTimeoutMillis() {
        return 10000;
    }
}

