/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.android;

import android.app.Service;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.IBinder;
import org.teleal.cling.UpnpService;
import org.teleal.cling.UpnpServiceConfiguration;
import org.teleal.cling.UpnpServiceImpl;
import org.teleal.cling.android.AndroidUpnpService;
import org.teleal.cling.android.AndroidUpnpServiceConfiguration;
import org.teleal.cling.android.AndroidWifiSwitchableRouter;
import org.teleal.cling.controlpoint.ControlPoint;
import org.teleal.cling.model.ModelUtil;
import org.teleal.cling.protocol.ProtocolFactory;
import org.teleal.cling.registry.Registry;
import org.teleal.cling.registry.RegistryListener;
import org.teleal.cling.transport.Router;

public class AndroidUpnpServiceImpl
extends Service {
    protected UpnpService upnpService;
    protected Binder binder = new Binder();

    public void onCreate() {
        super.onCreate();
        final WifiManager wifiManager = (WifiManager)this.getSystemService("wifi");
        final ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        this.upnpService = new UpnpServiceImpl(this.createConfiguration(wifiManager), new RegistryListener[0]){

            protected Router createRouter(ProtocolFactory protocolFactory, Registry registry) {
                AndroidWifiSwitchableRouter router = AndroidUpnpServiceImpl.this.createRouter(this.getConfiguration(), protocolFactory, wifiManager, connectivityManager);
                if (!ModelUtil.ANDROID_EMULATOR && AndroidUpnpServiceImpl.this.isListeningForConnectivityChanges()) {
                    AndroidUpnpServiceImpl.this.registerReceiver(router.getBroadcastReceiver(), new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                }
                return router;
            }
        };
    }

    protected AndroidUpnpServiceConfiguration createConfiguration(WifiManager wifiManager) {
        return new AndroidUpnpServiceConfiguration(wifiManager);
    }

    protected AndroidWifiSwitchableRouter createRouter(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory, WifiManager wifiManager, ConnectivityManager connectivityManager) {
        return new AndroidWifiSwitchableRouter(configuration, protocolFactory, wifiManager, connectivityManager);
    }

    public void onDestroy() {
        if (!ModelUtil.ANDROID_EMULATOR && this.isListeningForConnectivityChanges()) {
            this.unregisterReceiver(((AndroidWifiSwitchableRouter)this.upnpService.getRouter()).getBroadcastReceiver());
        }
        this.upnpService.shutdown();
    }

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    protected boolean isListeningForConnectivityChanges() {
        return true;
    }

    protected class Binder
    extends android.os.Binder
    implements AndroidUpnpService {
        protected Binder() {
        }

        public UpnpService get() {
            return AndroidUpnpServiceImpl.this.upnpService;
        }

        public UpnpServiceConfiguration getConfiguration() {
            return AndroidUpnpServiceImpl.this.upnpService.getConfiguration();
        }

        public Registry getRegistry() {
            return AndroidUpnpServiceImpl.this.upnpService.getRegistry();
        }

        public ControlPoint getControlPoint() {
            return AndroidUpnpServiceImpl.this.upnpService.getControlPoint();
        }
    }
}

