/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.android;

import android.net.wifi.WifiManager;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.teleal.cling.DefaultUpnpServiceConfiguration;
import org.teleal.cling.android.AndroidNetworkAddressFactory;
import org.teleal.cling.binding.xml.DeviceDescriptorBinder;
import org.teleal.cling.binding.xml.ServiceDescriptorBinder;
import org.teleal.cling.binding.xml.UDA10DeviceDescriptorBinderSAXImpl;
import org.teleal.cling.binding.xml.UDA10ServiceDescriptorBinderSAXImpl;
import org.teleal.cling.transport.impl.apache.StreamClientConfigurationImpl;
import org.teleal.cling.transport.impl.apache.StreamClientImpl;
import org.teleal.cling.transport.impl.apache.StreamServerConfigurationImpl;
import org.teleal.cling.transport.impl.apache.StreamServerImpl;
import org.teleal.cling.transport.spi.NetworkAddressFactory;
import org.teleal.cling.transport.spi.StreamClient;
import org.teleal.cling.transport.spi.StreamServer;

public class AndroidUpnpServiceConfiguration
extends DefaultUpnpServiceConfiguration {
    private static final Logger log = Logger.getLogger(AndroidUpnpServiceConfiguration.class.getName());
    protected final WifiManager wifiManager;

    public AndroidUpnpServiceConfiguration(WifiManager wifiManager) {
        this(wifiManager, 0);
    }

    public AndroidUpnpServiceConfiguration(WifiManager wifiManager, int streamListenPort) {
        super(streamListenPort, false);
        this.wifiManager = wifiManager;
        System.setProperty("org.xml.sax.driver", "org.xmlpull.v1.sax2.Driver");
    }

    protected NetworkAddressFactory createNetworkAddressFactory(int streamListenPort) {
        return new AndroidNetworkAddressFactory(this.wifiManager);
    }

    public StreamServer createStreamServer(NetworkAddressFactory networkAddressFactory) {
        return new StreamServerImpl(new StreamServerConfigurationImpl(networkAddressFactory.getStreamListenPort()));
    }

    public StreamClient createStreamClient() {
        return new StreamClientImpl(new StreamClientConfigurationImpl(){

            public int getConnectionTimeoutSeconds() {
                return 2;
            }

            public int getDataReadTimeoutSeconds() {
                return 3;
            }

            public boolean getStaleCheckingEnabled() {
                return false;
            }

            public int getRequestRetryCount() {
                return 1;
            }
        });
    }

    protected DeviceDescriptorBinder createDeviceDescriptorBinderUDA10() {
        return new UDA10DeviceDescriptorBinderSAXImpl();
    }

    protected ServiceDescriptorBinder createServiceDescriptorBinderUDA10() {
        return new UDA10ServiceDescriptorBinderSAXImpl();
    }

    public int getRegistryMaintenanceIntervalMillis() {
        return 3000;
    }

    protected Executor createDefaultExecutor() {
        ThreadPoolExecutor defaultExecutor = new ThreadPoolExecutor(8, 16, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue(512)){

            protected void beforeExecute(Thread thread, Runnable runnable) {
                super.beforeExecute(thread, runnable);
                thread.setName("Thread " + thread.getId() + " (Active: " + this.getActiveCount() + ")");
            }
        };
        defaultExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy(){

            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                log.warning("Thread pool saturated, discarding execution of '" + runnable.getClass() + "', consider raising the " + "maximum pool or queue size");
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        });
        return defaultExecutor;
    }
}

