/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.android;

import android.net.wifi.WifiManager;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.teleal.cling.model.ModelUtil;
import org.teleal.cling.transport.spi.InitializationException;
import org.teleal.cling.transport.spi.NetworkAddressFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidNetworkAddressFactory
implements NetworkAddressFactory {
    private static final Logger log = Logger.getLogger(NetworkAddressFactory.class.getName());
    protected NetworkInterface wifiInterface;
    protected List<InetAddress> bindAddresses = new ArrayList<InetAddress>();

    public AndroidNetworkAddressFactory(WifiManager wifiManager) throws InitializationException {
        this.wifiInterface = AndroidNetworkAddressFactory.getWifiNetworkInterface(wifiManager);
        if (this.wifiInterface == null) {
            throw new InitializationException("Could not discover WiFi network interface");
        }
        log.info("Discovered WiFi network interface: " + this.wifiInterface.getDisplayName());
        this.discoverBindAddresses();
    }

    protected void discoverBindAddresses() throws InitializationException {
        try {
            log.finer("Discovering addresses of interface: " + this.wifiInterface.getDisplayName());
            for (InetAddress inetAddress : this.getInetAddresses(this.wifiInterface)) {
                if (inetAddress == null) {
                    log.warning("Network has a null address: " + this.wifiInterface.getDisplayName());
                    continue;
                }
                if (this.isUsableAddress(inetAddress)) {
                    log.fine("Discovered usable network interface address: " + inetAddress.getHostAddress());
                    this.bindAddresses.add(inetAddress);
                    continue;
                }
                log.finer("Ignoring non-usable network interface address: " + inetAddress.getHostAddress());
            }
        }
        catch (Exception ex) {
            throw new InitializationException("Could not not analyze local network interfaces: " + ex, ex);
        }
    }

    protected boolean isUsableAddress(InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            log.finer("Skipping unsupported non-IPv4 address: " + address);
            return false;
        }
        return true;
    }

    protected List<InetAddress> getInetAddresses(NetworkInterface networkInterface) {
        return Collections.list(networkInterface.getInetAddresses());
    }

    @Override
    public InetAddress getMulticastGroup() {
        try {
            return InetAddress.getByName("239.255.255.250");
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int getMulticastPort() {
        return 1900;
    }

    @Override
    public int getStreamListenPort() {
        return 0;
    }

    @Override
    public NetworkInterface[] getNetworkInterfaces() {
        return new NetworkInterface[]{this.wifiInterface};
    }

    @Override
    public InetAddress[] getBindAddresses() {
        return this.bindAddresses.toArray(new InetAddress[this.bindAddresses.size()]);
    }

    @Override
    public byte[] getHardwareAddress(InetAddress inetAddress) {
        return null;
    }

    @Override
    public InetAddress getBroadcastAddress(InetAddress inetAddress) {
        return null;
    }

    @Override
    public InetAddress getLocalAddress(NetworkInterface networkInterface, boolean isIPv6, InetAddress remoteAddress) {
        for (InetAddress localAddress : this.getInetAddresses(networkInterface)) {
            if (isIPv6 && localAddress instanceof Inet6Address) {
                return localAddress;
            }
            if (isIPv6 || !(localAddress instanceof Inet4Address)) continue;
            return localAddress;
        }
        throw new IllegalStateException("Can't find any IPv4 or IPv6 address on interface: " + networkInterface.getDisplayName());
    }

    public static NetworkInterface getWifiNetworkInterface(WifiManager manager) {
        if (ModelUtil.ANDROID_EMULATOR) {
            return AndroidNetworkAddressFactory.getEmulatorWifiNetworkInterface(manager);
        }
        return AndroidNetworkAddressFactory.getRealWifiNetworkInterface(manager);
    }

    public static NetworkInterface getEmulatorWifiNetworkInterface(WifiManager manager) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface iface : interfaces) {
                ArrayList<InetAddress> addresses = Collections.list(iface.getInetAddresses());
                for (InetAddress address : addresses) {
                    if (address.isLoopbackAddress()) continue;
                    return iface;
                }
            }
        }
        catch (Exception ex) {
            throw new InitializationException("Could not find emulator's network interface: " + ex, ex);
        }
        return null;
    }

    public static NetworkInterface getRealWifiNetworkInterface(WifiManager manager) {
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.info("No network interfaces available");
            return null;
        }
        int wifiIP = manager.getConnectionInfo().getIpAddress();
        int reverseWifiIP = Integer.reverseBytes(wifiIP);
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress nextElement = inetAddresses.nextElement();
                int byteArrayToInt = AndroidNetworkAddressFactory.byteArrayToInt(nextElement.getAddress(), 0);
                if (byteArrayToInt != wifiIP && byteArrayToInt != reverseWifiIP) continue;
                return iface;
            }
        }
        return null;
    }

    static int byteArrayToInt(byte[] arr, int offset) {
        if (arr == null || arr.length - offset < 4) {
            return -1;
        }
        int r0 = (arr[offset] & 0xFF) << 24;
        int r1 = (arr[offset + 1] & 0xFF) << 16;
        int r2 = (arr[offset + 2] & 0xFF) << 8;
        int r3 = arr[offset + 3] & 0xFF;
        return r0 + r1 + r2 + r3;
    }
}

