/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling;

import java.util.logging.Logger;
import org.teleal.cling.DefaultUpnpServiceConfiguration;
import org.teleal.cling.UpnpService;
import org.teleal.cling.UpnpServiceConfiguration;
import org.teleal.cling.controlpoint.ControlPoint;
import org.teleal.cling.controlpoint.ControlPointImpl;
import org.teleal.cling.protocol.ProtocolFactory;
import org.teleal.cling.protocol.ProtocolFactoryImpl;
import org.teleal.cling.registry.Registry;
import org.teleal.cling.registry.RegistryImpl;
import org.teleal.cling.registry.RegistryListener;
import org.teleal.cling.transport.Router;
import org.teleal.cling.transport.RouterImpl;

public class UpnpServiceImpl
implements UpnpService {
    private static Logger log = Logger.getLogger(UpnpServiceImpl.class.getName());
    protected final UpnpServiceConfiguration configuration;
    protected final ControlPoint controlPoint;
    protected final ProtocolFactory protocolFactory;
    protected final Registry registry;
    protected final Router router;

    public UpnpServiceImpl() {
        this(new DefaultUpnpServiceConfiguration(), new RegistryListener[0]);
    }

    public UpnpServiceImpl(RegistryListener ... registryListeners) {
        this(new DefaultUpnpServiceConfiguration(), registryListeners);
    }

    public UpnpServiceImpl(UpnpServiceConfiguration configuration, RegistryListener ... registryListeners) {
        this.configuration = configuration;
        log.info(">>> Starting UPnP service...");
        log.info("Using configuration: " + this.getConfiguration().getClass().getName());
        this.protocolFactory = this.createProtocolFactory();
        this.registry = this.createRegistry(this.protocolFactory);
        for (RegistryListener registryListener : registryListeners) {
            this.registry.addListener(registryListener);
        }
        this.router = this.createRouter(this.protocolFactory, this.registry);
        this.controlPoint = this.createControlPoint(this.protocolFactory, this.registry);
        log.info("<<< UPnP service started successfully");
    }

    protected ProtocolFactory createProtocolFactory() {
        return new ProtocolFactoryImpl(this);
    }

    protected Registry createRegistry(ProtocolFactory protocolFactory) {
        return new RegistryImpl(this);
    }

    protected Router createRouter(ProtocolFactory protocolFactory, Registry registry) {
        return new RouterImpl(this.getConfiguration(), protocolFactory);
    }

    protected ControlPoint createControlPoint(ProtocolFactory protocolFactory, Registry registry) {
        return new ControlPointImpl(this.getConfiguration(), protocolFactory, registry);
    }

    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Router getRouter() {
        return this.router;
    }

    public synchronized void shutdown() {
        log.info(">>> Shutting down UPnP service...");
        this.getRegistry().shutdown();
        this.getRouter().shutdown();
        this.getConfiguration().shutdown();
        log.info("<<< UPnP service shutdown completed");
    }
}

