/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.vertexcover.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jgrapht.util.TypeUtil;

public class RatioVertex<V>
implements Comparable<RatioVertex<V>> {
    public final V v;
    public double weight;
    public final int ID;
    protected int degree = 0;
    public final Map<RatioVertex<V>, Integer> neighbors;

    public RatioVertex(int ID2, V v, double weight) {
        this.ID = ID2;
        this.v = v;
        this.weight = weight;
        this.neighbors = new LinkedHashMap<RatioVertex<V>, Integer>();
    }

    public void addNeighbor(RatioVertex<V> v) {
        if (!this.neighbors.containsKey(v)) {
            this.neighbors.put(v, 1);
        } else {
            this.neighbors.put(v, this.neighbors.get(v) + 1);
        }
        ++this.degree;
        assert (this.neighbors.values().stream().mapToInt(Integer::intValue).sum() == this.degree);
    }

    public void removeNeighbor(RatioVertex<V> v) {
        this.degree -= this.neighbors.get(v).intValue();
        this.neighbors.remove(v);
    }

    public int getDegree() {
        return this.degree;
    }

    public double getRatio() {
        return this.weight / (double)this.degree;
    }

    @Override
    public int compareTo(RatioVertex<V> other) {
        if (this.ID == other.ID) {
            return 0;
        }
        int result = Double.compare(this.getRatio(), other.getRatio());
        if (result == 0) {
            return Integer.compare(this.ID, other.ID);
        }
        return result;
    }

    public int hashCode() {
        return this.ID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RatioVertex)) {
            return false;
        }
        RatioVertex other = (RatioVertex)TypeUtil.uncheckedCast(o);
        return this.ID == other.ID;
    }

    public String toString() {
        return "v" + this.ID + "(" + this.degree + ")";
    }
}

