/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.ext.dom.ElementModel;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeListModel
extends SimpleSequence
implements TemplateHashModel {
    NodeModel contextNode;
    XPathSupport xpathSupport;
    private static ObjectWrapper nodeWrapper = new ObjectWrapper(){

        public TemplateModel wrap(Object obj) {
            if (obj instanceof NodeModel) {
                return (NodeModel)obj;
            }
            return NodeModel.wrap((Node)obj);
        }
    };

    NodeListModel(Node node) {
        this(NodeModel.wrap(node));
    }

    NodeListModel(NodeModel contextNode) {
        super(nodeWrapper);
        this.contextNode = contextNode;
    }

    NodeListModel(NodeList nodeList, NodeModel contextNode) {
        super(nodeWrapper);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.list.add(nodeList.item(i));
        }
        this.contextNode = contextNode;
    }

    NodeListModel(NamedNodeMap nodeList, NodeModel contextNode) {
        super(nodeWrapper);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.list.add(nodeList.item(i));
        }
        this.contextNode = contextNode;
    }

    NodeListModel(List list, NodeModel contextNode) {
        super(list, nodeWrapper);
        this.contextNode = contextNode;
    }

    NodeListModel filterByName(String name) throws TemplateModelException {
        NodeListModel result = new NodeListModel(this.contextNode);
        int size = this.size();
        if (size == 0) {
            return result;
        }
        Environment env = Environment.getCurrentEnvironment();
        for (int i = 0; i < size; ++i) {
            NodeModel nm = (NodeModel)this.get(i);
            if (!(nm instanceof ElementModel) || !((ElementModel)nm).matchesName(name, env)) continue;
            result.add(nm);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (this.size() == 1) {
            NodeModel nm = (NodeModel)this.get(0);
            return nm.get(key);
        }
        if (key.equals("@@markup") || key.equals("@@nested_markup") || key.equals("@@text")) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < this.size(); ++i) {
                NodeModel nm = (NodeModel)this.get(i);
                TemplateScalarModel textModel = (TemplateScalarModel)nm.get(key);
                result.append(textModel.getAsString());
            }
            return new SimpleScalar(result.toString());
        }
        if (StringUtil.isXMLID(key) || key.startsWith("@") && StringUtil.isXMLID(key.substring(1)) || key.equals("*") || key.equals("**") || key.equals("@@") || key.equals("@*")) {
            NodeListModel result = new NodeListModel(this.contextNode);
            for (int i = 0; i < this.size(); ++i) {
                NodeModel nm = (NodeModel)this.get(i);
                if (!(nm instanceof ElementModel)) continue;
                TemplateSequenceModel tsm = (TemplateSequenceModel)((ElementModel)nm).get(key);
                int size = tsm == null ? 0 : tsm.size();
                for (int j = 0; j < size; ++j) {
                    result.add(tsm.get(j));
                }
            }
            if (result.size() == 1) {
                return result.get(0);
            }
            return result;
        }
        XPathSupport xps = this.getXPathSupport();
        if (xps != null) {
            List context = this.size() == 0 ? null : this.rawNodeList();
            return xps.executeQuery(context, key);
        }
        throw new TemplateModelException("Key: '" + key + "' is not legal for a node sequence (" + this.getClass().getName() + "). This node sequence contains " + this.size() + " node(s). Some keys are valid only for node sequences of size 1. If you use Xalan (instead of Jaxen), XPath expression keys work only with node lists of size 1.");
    }

    private List rawNodeList() throws TemplateModelException {
        int size = this.size();
        ArrayList<Node> al = new ArrayList<Node>(size);
        for (int i = 0; i < size; ++i) {
            al.add(((NodeModel)this.get((int)i)).node);
        }
        return al;
    }

    XPathSupport getXPathSupport() throws TemplateModelException {
        if (this.xpathSupport == null) {
            if (this.contextNode != null) {
                this.xpathSupport = this.contextNode.getXPathSupport();
            } else if (this.size() > 0) {
                this.xpathSupport = ((NodeModel)this.get(0)).getXPathSupport();
            }
        }
        return this.xpathSupport;
    }
}

