/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.MethodUtilities;
import freemarker.ext.beans.OverloadedMethod;
import java.lang.reflect.Member;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

final class ClassString {
    private static final Class BIGDECIMAL_CLASS = class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ClassString.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
    private static final Class NUMBER_CLASS = class$java$lang$Number == null ? (class$java$lang$Number = ClassString.class$("java.lang.Number")) : class$java$lang$Number;
    private final Class[] classes;
    private static final int MORE_SPECIFIC = 0;
    private static final int LESS_SPECIFIC = 1;
    private static final int INDETERMINATE = 2;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    ClassString(Object[] objects) {
        int l = objects.length;
        this.classes = new Class[l];
        for (int i = 0; i < l; ++i) {
            Object obj = objects[i];
            this.classes[i] = obj == null ? MethodUtilities.OBJECT_CLASS : obj.getClass();
        }
    }

    Class[] getClasses() {
        return this.classes;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.classes.length; ++i) {
            hash ^= this.classes[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof ClassString) {
            ClassString cs = (ClassString)o;
            if (cs.classes.length != this.classes.length) {
                return false;
            }
            for (int i = 0; i < this.classes.length; ++i) {
                if (cs.classes[i] == this.classes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    Object getMostSpecific(List methods, boolean varArg) {
        LinkedList applicables = this.getApplicables(methods, varArg);
        if (applicables.isEmpty()) {
            return OverloadedMethod.NO_SUCH_METHOD;
        }
        if (applicables.size() == 1) {
            return applicables.getFirst();
        }
        LinkedList<Member> maximals = new LinkedList<Member>();
        Iterator it = applicables.iterator();
        while (it.hasNext()) {
            Member applicable = (Member)it.next();
            Class[] appArgs = MethodUtilities.getParameterTypes(applicable);
            boolean lessSpecific = false;
            Iterator maximal = maximals.iterator();
            while (maximal.hasNext()) {
                Member max = (Member)maximal.next();
                Class[] maxArgs = MethodUtilities.getParameterTypes(max);
                switch (ClassString.moreSpecific(appArgs, maxArgs, varArg)) {
                    case 0: {
                        maximal.remove();
                        break;
                    }
                    case 1: {
                        lessSpecific = true;
                    }
                }
            }
            if (lessSpecific) continue;
            maximals.addLast(applicable);
        }
        if (maximals.size() > 1) {
            return OverloadedMethod.AMBIGUOUS_METHOD;
        }
        return maximals.getFirst();
    }

    private static int moreSpecific(Class[] c1, Class[] c2, boolean varArg) {
        boolean c1MoreSpecific = false;
        boolean c2MoreSpecific = false;
        int cl1 = c1.length;
        int cl2 = c2.length;
        for (int i = 0; i < cl1; ++i) {
            Class class2;
            Class class1 = ClassString.getClass(c1, cl1, i, varArg);
            if (class1 == (class2 = ClassString.getClass(c2, cl2, i, varArg))) continue;
            c1MoreSpecific = c1MoreSpecific || MethodUtilities.isMoreSpecific(class1, class2);
            c2MoreSpecific = c2MoreSpecific || MethodUtilities.isMoreSpecific(class2, class1);
        }
        if (c1MoreSpecific) {
            if (c2MoreSpecific) {
                return 2;
            }
            return 0;
        }
        if (c2MoreSpecific) {
            return 1;
        }
        return 2;
    }

    private static Class getClass(Class[] classes, int l, int i, boolean varArg) {
        return varArg && i >= l - 1 ? classes[l - 1].getComponentType() : classes[i];
    }

    LinkedList getApplicables(List methods, boolean varArg) {
        LinkedList<Member> list = new LinkedList<Member>();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Member member = (Member)it.next();
            if (!this.isApplicable(member, varArg)) continue;
            list.add(member);
        }
        return list;
    }

    private boolean isApplicable(Member member, boolean varArg) {
        Class[] formalTypes = MethodUtilities.getParameterTypes(member);
        int cl = this.classes.length;
        int fl = formalTypes.length - (varArg ? 1 : 0);
        if (varArg ? cl < fl : cl != fl) {
            return false;
        }
        for (int i = 0; i < fl; ++i) {
            if (ClassString.isMethodInvocationConvertible(formalTypes[i], this.classes[i])) continue;
            return false;
        }
        if (varArg) {
            Class<?> varArgType = formalTypes[fl].getComponentType();
            for (int i = fl; i < cl; ++i) {
                if (ClassString.isMethodInvocationConvertible(varArgType, this.classes[i])) continue;
                return false;
            }
        }
        return true;
    }

    static boolean isMethodInvocationConvertible(Class formal, Class actual) {
        if (formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Boolean.TYPE) {
                return actual == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassString.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            }
            if (formal == Character.TYPE) {
                return actual == (class$java$lang$Character == null ? (class$java$lang$Character = ClassString.class$("java.lang.Character")) : class$java$lang$Character);
            }
            if (formal == Byte.TYPE && actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = ClassString.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return true;
            }
            if (formal == Short.TYPE && (actual == (class$java$lang$Short == null ? (class$java$lang$Short = ClassString.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = ClassString.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = ClassString.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = ClassString.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = ClassString.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Long.TYPE && (actual == (class$java$lang$Long == null ? (class$java$lang$Long = ClassString.class$("java.lang.Long")) : class$java$lang$Long) || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = ClassString.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = ClassString.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = ClassString.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Float.TYPE && (actual == (class$java$lang$Float == null ? (class$java$lang$Float = ClassString.class$("java.lang.Float")) : class$java$lang$Float) || actual == (class$java$lang$Long == null ? (class$java$lang$Long = ClassString.class$("java.lang.Long")) : class$java$lang$Long) || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = ClassString.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = ClassString.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = ClassString.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Double.TYPE && (actual == (class$java$lang$Double == null ? (class$java$lang$Double = ClassString.class$("java.lang.Double")) : class$java$lang$Double) || actual == (class$java$lang$Float == null ? (class$java$lang$Float = ClassString.class$("java.lang.Float")) : class$java$lang$Float) || actual == (class$java$lang$Long == null ? (class$java$lang$Long = ClassString.class$("java.lang.Long")) : class$java$lang$Long) || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = ClassString.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = ClassString.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = ClassString.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            return ClassString.isBigDecimalConvertible(formal, actual);
        }
        return false;
    }

    private static boolean isBigDecimalConvertible(Class formal, Class actual) {
        if (BIGDECIMAL_CLASS.isAssignableFrom(actual)) {
            if (NUMBER_CLASS.isAssignableFrom(formal)) {
                return true;
            }
            if (formal.isPrimitive() && formal != Boolean.TYPE && formal != Character.TYPE) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

