/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Dot;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.Identifier;
import freemarker.core.InvalidReferenceException;
import freemarker.core.Macro;
import freemarker.core.TemplateElement;
import freemarker.core.TextBlock;
import freemarker.template.EmptyMap;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class UnifiedCall
extends TemplateElement {
    private Expression nameExp;
    private Map namedArgs;
    private List positionalArgs;
    private List bodyParameterNames;
    boolean legacySyntax;

    UnifiedCall(Expression nameExp, Map namedArgs, TemplateElement nestedBlock, List bodyParameterNames) {
        this.nameExp = nameExp;
        this.namedArgs = namedArgs;
        this.nestedBlock = nestedBlock;
        this.bodyParameterNames = bodyParameterNames;
    }

    UnifiedCall(Expression nameExp, List positionalArgs, TemplateElement nestedBlock, List bodyParameterNames) {
        this.nameExp = nameExp;
        this.positionalArgs = positionalArgs;
        if (nestedBlock == TextBlock.EMPTY_BLOCK) {
            nestedBlock = null;
        }
        this.nestedBlock = nestedBlock;
        this.bodyParameterNames = bodyParameterNames;
    }

    void accept(Environment env) throws TemplateException, IOException {
        TemplateModel tm = this.nameExp.getAsTemplateModel(env);
        if (tm == Macro.DO_NOTHING_MACRO) {
            return;
        }
        if (tm instanceof Macro) {
            Macro macro = (Macro)tm;
            if (macro.isFunction && !this.legacySyntax) {
                throw new TemplateException("Routine " + macro.getName() + " is a function. A function can only be called within the evaluation of an expression.", env);
            }
            env.visit(macro, this.namedArgs, this.positionalArgs, this.bodyParameterNames, this.nestedBlock);
        } else {
            boolean isDirectiveModel = tm instanceof TemplateDirectiveModel;
            if (isDirectiveModel || tm instanceof TemplateTransformModel) {
                Map args;
                if (this.namedArgs != null && !this.namedArgs.isEmpty()) {
                    args = new HashMap();
                    Iterator it = this.namedArgs.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String key = (String)entry.getKey();
                        Expression valueExp = (Expression)entry.getValue();
                        TemplateModel value = valueExp.getAsTemplateModel(env);
                        args.put(key, value);
                    }
                } else {
                    args = EmptyMap.instance;
                }
                if (isDirectiveModel) {
                    env.visit(this.nestedBlock, (TemplateDirectiveModel)tm, args, this.bodyParameterNames);
                } else {
                    env.visit(this.nestedBlock, (TemplateTransformModel)tm, args);
                }
            } else {
                if (tm == null) {
                    throw new InvalidReferenceException(this.getStartLocation() + " " + this.nameExp + " not found.", env);
                }
                throw new TemplateException(this.getStartLocation() + ": " + this.nameExp + " is not a user-defined directive. It is a " + tm.getClass().getName(), env);
            }
        }
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("<@");
        buf.append(this.nameExp.getCanonicalForm());
        if (this.positionalArgs != null) {
            for (int i = 0; i < this.positionalArgs.size(); ++i) {
                Expression arg = (Expression)this.positionalArgs.get(i);
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(' ');
                buf.append(arg.getCanonicalForm());
            }
        } else {
            ArrayList keys = new ArrayList(this.namedArgs.keySet());
            Collections.sort(keys);
            for (int i = 0; i < keys.size(); ++i) {
                Expression arg = (Expression)this.namedArgs.get(keys.get(i));
                buf.append(' ');
                buf.append(keys.get(i));
                buf.append('=');
                buf.append(arg.getCanonicalForm());
            }
        }
        if (this.nestedBlock == null) {
            buf.append("/>");
        } else {
            buf.append('>');
            buf.append(this.nestedBlock.getCanonicalForm());
            buf.append("</@");
            if (this.nameExp instanceof Identifier || this.nameExp instanceof Dot && ((Dot)this.nameExp).onlyHasIdentifiers()) {
                buf.append(this.nameExp);
            }
            buf.append('>');
        }
        return buf.toString();
    }

    public String getDescription() {
        return "user-directive " + this.nameExp;
    }
}

