/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.NonBooleanException;
import freemarker.core.NumericalRange;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

final class Range
extends Expression {
    final Expression left;
    final Expression right;

    Range(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    boolean hasRhs() {
        return this.right != null;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        int min = EvaluationUtil.getNumber(this.left, env).intValue();
        int max = 0;
        if (this.right != null) {
            max = EvaluationUtil.getNumber(this.right, env).intValue();
            return new NumericalRange(min, max);
        }
        return new NumericalRange(min);
    }

    boolean isTrue(Environment env) throws TemplateException {
        String msg = "Error " + this.getStartLocation() + ". \nExpecting a boolean here. Expression " + this + " is a range.";
        throw new NonBooleanException(msg, env);
    }

    public String getCanonicalForm() {
        String rhs = this.right != null ? this.right.getCanonicalForm() : "";
        return this.left.getCanonicalForm() + ".." + rhs;
    }

    boolean isLiteral() {
        boolean rightIsLiteral = this.right == null || this.right.isLiteral();
        return this.constantValue != null || this.left.isLiteral() && rightIsLiteral;
    }

    Expression _deepClone(String name, Expression subst) {
        return new Range(this.left.deepClone(name, subst), this.right.deepClone(name, subst));
    }
}

