/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.Identifier;
import freemarker.core.NonExistentKeyException;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

final class Dot
extends Expression {
    private final Expression target;
    private final String key;

    Dot(Expression target, String key) {
        this.target = target;
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel leftModel = this.target.getAsTemplateModel(env);
        if (leftModel == null) {
            throw new TemplateModelException("Expression " + this.target.toString() + " is null when evaluating expression " + this);
        }
        if (leftModel instanceof TemplateHashModel) {
            TemplateModel result = ((TemplateHashModel)leftModel).get(this.key);
            if (result == null) {
                throw new NonExistentKeyException(this, env);
            }
            return result;
        }
        throw Dot.invalidTypeException(leftModel, this.target, env, "hash");
    }

    public String getCanonicalForm() {
        return this.target.getCanonicalForm() + "." + this.key;
    }

    boolean isLiteral() {
        return this.target.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new Dot(this.target.deepClone(name, subst), this.key);
    }

    boolean onlyHasIdentifiers() {
        return this.target instanceof Identifier || this.target instanceof Dot && ((Dot)this.target).onlyHasIdentifiers();
    }
}

