/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.CacheStorage;
import freemarker.cache.ConcurrentCacheStorage;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.SoftCacheStorage;
import freemarker.cache.StatefulTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class TemplateCache {
    private static final String ASTERISKSTR = "*";
    private static final String LOCALE_SEPARATOR = "_";
    private static final char ASTERISK = '*';
    private static final String CURRENT_DIR_PATH_PREFIX = "./";
    private static final String CURRENT_DIR_PATH = "/./";
    private static final String PARENT_DIR_PATH_PREFIX = "../";
    private static final String PARENT_DIR_PATH = "/../";
    private static final char SLASH = '/';
    private static final Logger logger = Logger.getLogger("freemarker.cache");
    private final TemplateLoader mainLoader;
    private final CacheStorage storage;
    private final boolean isStorageConcurrent;
    private long delay = 5000L;
    private boolean localizedLookup = true;
    private Configuration config;
    private static final Method INIT_CAUSE = TemplateCache.getInitCauseMethod();
    static /* synthetic */ Class class$java$lang$Throwable;

    public TemplateCache() {
        this(TemplateCache.createDefaultTemplateLoader());
    }

    private static TemplateLoader createDefaultTemplateLoader() {
        try {
            return new FileTemplateLoader();
        }
        catch (Exception e) {
            logger.warn("Could not create a file template loader for current directory", e);
            return null;
        }
    }

    public TemplateCache(TemplateLoader loader) {
        this(loader, new SoftCacheStorage());
    }

    public TemplateCache(TemplateLoader loader, CacheStorage storage) {
        this.mainLoader = loader;
        this.storage = storage;
        if (storage == null) {
            throw new IllegalArgumentException("storage == null");
        }
        this.isStorageConcurrent = storage instanceof ConcurrentCacheStorage && ((ConcurrentCacheStorage)storage).isConcurrent();
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.clear();
    }

    public TemplateLoader getTemplateLoader() {
        return this.mainLoader;
    }

    public CacheStorage getCacheStorage() {
        return this.storage;
    }

    public Template getTemplate(String name, Locale locale, String encoding, boolean parse) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Argument \"name\" can't be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Argument \"locale\" can't be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Argument \"encoding\" can't be null");
        }
        if ((name = TemplateCache.normalizeName(name)) == null) {
            return null;
        }
        Template result = null;
        if (this.mainLoader != null) {
            result = this.getTemplate(this.mainLoader, name, locale, encoding, parse);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Template getTemplate(TemplateLoader loader, String name, Locale locale, String encoding, boolean parse) throws IOException {
        debug = TemplateCache.logger.isDebugEnabled();
        debugName = debug != false ? name + "[" + locale + "," + encoding + (parse != false ? ",parsed] " : ",unparsed] ") : null;
        tk = new TemplateKey(name, locale, encoding, parse);
        if (this.isStorageConcurrent) {
            cachedTemplate = (CachedTemplate)this.storage.get(tk);
        } else {
            var10_10 = this.storage;
            synchronized (var10_10) {
                cachedTemplate = (CachedTemplate)this.storage.get(tk);
            }
        }
        now = System.currentTimeMillis();
        lastModified = -1L;
        newlyFoundSource = null;
        rethrown = false;
        try {
            if (cachedTemplate == null) ** GOTO lbl73
            if (now - cachedTemplate.lastChecked >= this.delay) ** GOTO lbl45
            if (debug) {
                TemplateCache.logger.debug(debugName + "cached copy not yet stale; using cached.");
            }
            if ((t = cachedTemplate.templateOrException) instanceof Template || t == null) {
                var17_22 = (Template)t;
                if (newlyFoundSource == null) return var17_22;
            }
            ** GOTO lbl-1000
        }
        catch (RuntimeException e) {
            try {
                this.storeNegativeLookup(tk, cachedTemplate, e);
                throw e;
                catch (IOException e) {
                    if (rethrown != false) throw e;
                    this.storeNegativeLookup(tk, cachedTemplate, e);
                    throw e;
                }
            }
            catch (Throwable var19_27) {
                if (newlyFoundSource == null) throw var19_27;
                loader.closeTemplateSource(newlyFoundSource);
                throw var19_27;
            }
        }
        loader.closeTemplateSource(newlyFoundSource);
        return var17_22;
lbl-1000:
        // 1 sources

        {
            if (t instanceof RuntimeException) {
                this.throwLoadFailedException((RuntimeException)t);
                throw new RuntimeException("t is " + t.getClass().getName());
            }
            if (t instanceof IOException == false) throw new RuntimeException("t is " + t.getClass().getName());
            rethrown = true;
            this.throwLoadFailedException((IOException)t);
            throw new RuntimeException("t is " + t.getClass().getName());
lbl45:
            // 1 sources

            cachedTemplate = cachedTemplate.cloneCachedTemplate();
            cachedTemplate.lastChecked = now;
            newlyFoundSource = this.findTemplateSource(name, locale);
            if (newlyFoundSource != null) ** GOTO lbl-1000
            if (debug) {
                TemplateCache.logger.debug(debugName + "no source found.");
            }
            this.storeNegativeLookup(tk, cachedTemplate, null);
            t = null;
            if (newlyFoundSource == null) return t;
        }
        loader.closeTemplateSource(newlyFoundSource);
        return t;
lbl-1000:
        // 1 sources

        {
            lastModified = loader.getLastModified(newlyFoundSource);
            lastModifiedNotChanged = lastModified == cachedTemplate.lastModified;
            sourceEquals = newlyFoundSource.equals(cachedTemplate.source);
            if (!lastModifiedNotChanged || !sourceEquals) ** GOTO lbl-1000
            if (debug) {
                TemplateCache.logger.debug(debugName + "using cached since " + newlyFoundSource + " didn't change.");
            }
            this.storeCached(tk, cachedTemplate);
            var18_25 = (Template)cachedTemplate.templateOrException;
            if (newlyFoundSource == null) return var18_25;
        }
        loader.closeTemplateSource(newlyFoundSource);
        return var18_25;
lbl-1000:
        // 1 sources

        {
            if (debug && !sourceEquals) {
                TemplateCache.logger.debug("Updating source, info for cause: sourceEquals=" + sourceEquals + ", newlyFoundSource=" + newlyFoundSource + ", cachedTemplate.source=" + cachedTemplate.source);
            }
            if (debug && !lastModifiedNotChanged) {
                TemplateCache.logger.debug("Updating source, info for cause: lastModifiedNotChanged=" + lastModifiedNotChanged + ", cache lastModified=" + cachedTemplate.lastModified + " != file lastModified=" + lastModified);
            }
            cachedTemplate.source = newlyFoundSource;
            ** GOTO lbl87
lbl73:
            // 1 sources

            if (debug) {
                TemplateCache.logger.debug("Could not find template in cache, creating new one; id=[" + TemplateKey.access$000(tk) + "[" + TemplateKey.access$100(tk) + "," + TemplateKey.access$200(tk) + (TemplateKey.access$300(tk) != false ? ",parsed] " : ",unparsed] ") + "]");
            }
            cachedTemplate = new CachedTemplate();
            cachedTemplate.lastChecked = now;
            newlyFoundSource = this.findTemplateSource(name, locale);
            if (newlyFoundSource != null) ** GOTO lbl-1000
            this.storeNegativeLookup(tk, cachedTemplate, null);
            lastModifiedNotChanged = null;
            if (newlyFoundSource == null) return lastModifiedNotChanged;
        }
        loader.closeTemplateSource(newlyFoundSource);
        return lastModifiedNotChanged;
lbl-1000:
        // 1 sources

        {
            cachedTemplate.source = newlyFoundSource;
            lastModified = -9223372036854775808L;
            cachedTemplate.lastModified = -9223372036854775808L;
lbl87:
            // 2 sources

            if (debug) {
                TemplateCache.logger.debug("Compiling FreeMarker template " + debugName + " from " + newlyFoundSource);
            }
            source = cachedTemplate.source;
            t = this.loadTemplate(loader, name, locale, encoding, parse, source);
            cachedTemplate.templateOrException = t;
            cachedTemplate.lastModified = lastModified == -9223372036854775808L ? loader.getLastModified(source) : lastModified;
            this.storeCached(tk, cachedTemplate);
            var18_26 = t;
            if (newlyFoundSource == null) return var18_26;
        }
        loader.closeTemplateSource(newlyFoundSource);
        return var18_26;
    }

    private static final Method getInitCauseMethod() {
        try {
            return (class$java$lang$Throwable == null ? (class$java$lang$Throwable = TemplateCache.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("initCause", class$java$lang$Throwable == null ? (class$java$lang$Throwable = TemplateCache.class$("java.lang.Throwable")) : class$java$lang$Throwable);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private void throwLoadFailedException(Exception e) throws IOException {
        IOException ioe;
        if (INIT_CAUSE != null) {
            ioe = new IOException("There was an error loading the template on an earlier attempt; it is attached as a cause");
            try {
                INIT_CAUSE.invoke((Object)ioe, e);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        } else {
            ioe = new IOException("There was an error loading the template on an earlier attempt: " + e.getClass().getName() + ": " + e.getMessage());
        }
        throw ioe;
    }

    private void storeNegativeLookup(TemplateKey tk, CachedTemplate cachedTemplate, Exception e) {
        cachedTemplate.templateOrException = e;
        cachedTemplate.source = null;
        cachedTemplate.lastModified = 0L;
        this.storeCached(tk, cachedTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCached(TemplateKey tk, CachedTemplate cachedTemplate) {
        if (this.isStorageConcurrent) {
            this.storage.put(tk, cachedTemplate);
        } else {
            CacheStorage cacheStorage = this.storage;
            synchronized (cacheStorage) {
                this.storage.put(tk, cachedTemplate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template loadTemplate(TemplateLoader loader, String name, Locale locale, String encoding, boolean parse, Object source) throws IOException {
        Template template;
        Reader reader = loader.getReader(source, encoding);
        try {
            if (parse) {
                try {
                    template = new Template(name, reader, this.config, encoding);
                }
                catch (Template.WrongEncodingException wee) {
                    encoding = wee.specifiedEncoding;
                    reader = loader.getReader(source, encoding);
                    template = new Template(name, reader, this.config, encoding);
                }
                template.setLocale(locale);
            } else {
                StringWriter sw = new StringWriter();
                char[] buf = new char[4096];
                while (true) {
                    int charsRead;
                    if ((charsRead = reader.read(buf)) > 0) {
                        sw.write(buf, 0, charsRead);
                        continue;
                    }
                    if (charsRead == -1) break;
                }
                template = Template.getPlainTextTemplate(name, sw.toString(), this.config);
                template.setLocale(locale);
            }
            template.setEncoding(encoding);
        }
        finally {
            reader.close();
        }
        return template;
    }

    public synchronized long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(long delay) {
        this.delay = delay;
    }

    public synchronized boolean getLocalizedLookup() {
        return this.localizedLookup;
    }

    public synchronized void setLocalizedLookup(boolean localizedLookup) {
        this.localizedLookup = localizedLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CacheStorage cacheStorage = this.storage;
        synchronized (cacheStorage) {
            this.storage.clear();
            if (this.mainLoader instanceof StatefulTemplateLoader) {
                ((StatefulTemplateLoader)this.mainLoader).resetState();
            }
        }
    }

    public static String getFullTemplatePath(Environment env, String parentTemplateDir, String templateNameString) {
        if (!env.isClassicCompatible() && templateNameString.indexOf("://") <= 0) {
            int protIndex;
            templateNameString = templateNameString.length() > 0 && templateNameString.charAt(0) == '/' ? ((protIndex = parentTemplateDir.indexOf("://")) > 0 ? parentTemplateDir.substring(0, protIndex + 2) + templateNameString : templateNameString.substring(1)) : parentTemplateDir + templateNameString;
        }
        return templateNameString;
    }

    private Object findTemplateSource(String name, Locale locale) throws IOException {
        if (this.localizedLookup) {
            int lastDot = name.lastIndexOf(46);
            String prefix = lastDot == -1 ? name : name.substring(0, lastDot);
            String suffix = lastDot == -1 ? "" : name.substring(lastDot);
            String localeName = LOCALE_SEPARATOR + locale.toString();
            StringBuffer buf = new StringBuffer(name.length() + localeName.length());
            buf.append(prefix);
            while (true) {
                buf.setLength(prefix.length());
                String path = buf.append(localeName).append(suffix).toString();
                Object templateSource = this.acquireTemplateSource(path);
                if (templateSource != null) {
                    return templateSource;
                }
                int lastUnderscore = localeName.lastIndexOf(95);
                if (lastUnderscore == -1) break;
                localeName = localeName.substring(0, lastUnderscore);
            }
            return null;
        }
        return this.acquireTemplateSource(name);
    }

    private Object acquireTemplateSource(String path) throws IOException {
        int asterisk = path.indexOf(42);
        if (asterisk == -1) {
            return this.mainLoader.findTemplateSource(path);
        }
        StringTokenizer tok = new StringTokenizer(path, "/");
        int lastAsterisk = -1;
        ArrayList<String> tokpath = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String pathToken = tok.nextToken();
            if (pathToken.equals(ASTERISKSTR)) {
                if (lastAsterisk != -1) {
                    tokpath.remove(lastAsterisk);
                }
                lastAsterisk = tokpath.size();
            }
            tokpath.add(pathToken);
        }
        String basePath = this.concatPath(tokpath, 0, lastAsterisk);
        String resourcePath = this.concatPath(tokpath, lastAsterisk + 1, tokpath.size());
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        StringBuffer buf = new StringBuffer(path.length()).append(basePath);
        int l = basePath.length();
        boolean debug = logger.isDebugEnabled();
        while (true) {
            Object templateSource;
            String fullPath = buf.append(resourcePath).toString();
            if (debug) {
                logger.debug("Trying to find template source " + fullPath);
            }
            if ((templateSource = this.mainLoader.findTemplateSource(fullPath)) != null) {
                return templateSource;
            }
            if (l == 0) {
                return null;
            }
            l = basePath.lastIndexOf(47, l - 2) + 1;
            buf.setLength(l);
        }
    }

    private String concatPath(List path, int from, int to) {
        StringBuffer buf = new StringBuffer((to - from) * 16);
        for (int i = from; i < to; ++i) {
            buf.append(path.get(i)).append('/');
        }
        return buf.toString();
    }

    private static String normalizeName(String name) {
        if (name.indexOf("://") > 0) {
            return name;
        }
        while (true) {
            int parentDirPathLoc;
            if ((parentDirPathLoc = name.indexOf(PARENT_DIR_PATH)) == 0) {
                return null;
            }
            if (parentDirPathLoc == -1) {
                if (!name.startsWith(PARENT_DIR_PATH_PREFIX)) break;
                return null;
            }
            int previousSlashLoc = name.lastIndexOf(47, parentDirPathLoc - 1);
            name = name.substring(0, previousSlashLoc + 1) + name.substring(parentDirPathLoc + PARENT_DIR_PATH.length());
        }
        while (true) {
            int currentDirPathLoc;
            if ((currentDirPathLoc = name.indexOf(CURRENT_DIR_PATH)) == -1) {
                if (!name.startsWith(CURRENT_DIR_PATH_PREFIX)) break;
                name = name.substring(CURRENT_DIR_PATH_PREFIX.length());
                break;
            }
            name = name.substring(0, currentDirPathLoc) + name.substring(currentDirPathLoc + CURRENT_DIR_PATH.length() - 1);
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class CachedTemplate
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        Object templateOrException;
        Object source;
        long lastChecked;
        long lastModified;

        private CachedTemplate() {
        }

        public CachedTemplate cloneCachedTemplate() {
            try {
                return (CachedTemplate)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
    }

    private static final class TemplateKey {
        private final String name;
        private final Locale locale;
        private final String encoding;
        private final boolean parse;

        TemplateKey(String name, Locale locale, String encoding, boolean parse) {
            this.name = name;
            this.locale = locale;
            this.encoding = encoding;
            this.parse = parse;
        }

        public boolean equals(Object o) {
            if (o instanceof TemplateKey) {
                TemplateKey tk = (TemplateKey)o;
                return this.parse == tk.parse && this.name.equals(tk.name) && this.locale.equals(tk.locale) && this.encoding.equals(tk.encoding);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.locale.hashCode() ^ this.encoding.hashCode() ^ (this.parse ? Boolean.FALSE : Boolean.TRUE).hashCode();
        }

        static /* synthetic */ String access$000(TemplateKey x0) {
            return x0.name;
        }

        static /* synthetic */ Locale access$100(TemplateKey x0) {
            return x0.locale;
        }

        static /* synthetic */ String access$200(TemplateKey x0) {
            return x0.encoding;
        }

        static /* synthetic */ boolean access$300(TemplateKey x0) {
            return x0.parse;
        }
    }
}

