/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateLoader;
import freemarker.template.utility.SecurityUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class FileTemplateLoader
implements TemplateLoader {
    private static final boolean SEP_IS_SLASH = File.separatorChar == '/';
    public final File baseDir;
    private final String canonicalPath;

    public FileTemplateLoader() throws IOException {
        this(new File(SecurityUtilities.getSystemProperty("user.dir")));
    }

    public FileTemplateLoader(File baseDir) throws IOException {
        this(baseDir, false);
    }

    public FileTemplateLoader(final File baseDir, final boolean allowLinking) throws IOException {
        try {
            Object[] retval = (Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (!baseDir.exists()) {
                        throw new FileNotFoundException(baseDir + " does not exist.");
                    }
                    if (!baseDir.isDirectory()) {
                        throw new IOException(baseDir + " is not a directory.");
                    }
                    Object[] retval = new Object[2];
                    if (allowLinking) {
                        retval[0] = baseDir;
                        retval[1] = null;
                    } else {
                        retval[0] = baseDir.getCanonicalFile();
                        retval[1] = ((File)retval[0]).getPath() + File.separatorChar;
                    }
                    return retval;
                }
            });
            this.baseDir = (File)retval[0];
            this.canonicalPath = (String)retval[1];
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public Object findTemplateSource(final String name) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String normalized;
                    File source = new File(FileTemplateLoader.this.baseDir, SEP_IS_SLASH ? name : name.replace('/', File.separatorChar));
                    if (!source.isFile()) {
                        return null;
                    }
                    if (FileTemplateLoader.this.canonicalPath != null && !(normalized = source.getCanonicalPath()).startsWith(FileTemplateLoader.this.canonicalPath)) {
                        throw new SecurityException(source.getAbsolutePath() + " resolves to " + normalized + " which  doesn't start with " + FileTemplateLoader.this.canonicalPath);
                    }
                    return source;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public long getLastModified(final Object templateSource) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(((File)templateSource).lastModified());
            }
        });
    }

    public Reader getReader(final Object templateSource, final String encoding) throws IOException {
        try {
            return (Reader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (!(templateSource instanceof File)) {
                        throw new IllegalArgumentException("templateSource is a: " + templateSource.getClass().getName());
                    }
                    return new InputStreamReader((InputStream)new FileInputStream((File)templateSource), encoding);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public void closeTemplateSource(Object templateSource) {
    }
}

