/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.har.creator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.smartbear.har.creator.HarStreamWriter;
import com.smartbear.har.model.HarBrowser;
import com.smartbear.har.model.HarCreator;
import com.smartbear.har.model.HarEntry;
import com.smartbear.har.model.HarPage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefaultHarStreamWriter
implements HarStreamWriter {
    private final JsonGenerator jsonGenerator;

    private DefaultHarStreamWriter(File harFile, String version, HarCreator creator, HarBrowser browser, List<HarPage> pages, String comment, boolean usePrettyPrint) throws IOException {
        this.jsonGenerator = new JsonFactory().createGenerator(harFile, JsonEncoding.UTF8);
        ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.jsonGenerator.setCodec(objectMapper);
        if (usePrettyPrint) {
            this.jsonGenerator.useDefaultPrettyPrinter();
        }
        this.jsonGenerator.writeStartObject();
        this.writeHarLogFields(version, creator, browser, pages, comment);
        this.jsonGenerator.writeFieldName("entries");
        this.jsonGenerator.writeStartArray();
    }

    private void writeHarLogFields(String version, HarCreator creator, HarBrowser browser, List<HarPage> pages, String comment) throws IOException {
        this.jsonGenerator.writeFieldName("log");
        this.jsonGenerator.writeStartObject();
        if (comment != null) {
            this.jsonGenerator.writeFieldName("comment");
            this.jsonGenerator.writeObject(comment);
        }
        if (browser != null) {
            this.jsonGenerator.writeFieldName("browser");
            this.jsonGenerator.writeObject(browser);
        }
        if (pages != null) {
            this.jsonGenerator.writeFieldName("pages");
            this.jsonGenerator.writeObject(pages);
        }
        this.jsonGenerator.writeFieldName("creator");
        this.jsonGenerator.writeObject(creator);
        this.jsonGenerator.writeFieldName("version");
        this.jsonGenerator.writeObject(version);
    }

    @Override
    public void addEntry(HarEntry harEntry) throws IOException {
        this.jsonGenerator.writeObject(harEntry);
        this.jsonGenerator.flush();
    }

    @Override
    public void closeHar() throws IOException {
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.close();
    }

    public static class Builder {
        private File harFile;
        private String version = "1.2";
        private HarCreator creator;
        private HarBrowser browser;
        private List<HarPage> pages;
        private String comment;
        private boolean usePrettyPrint = false;

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withCreator(HarCreator creator) {
            this.creator = creator;
            return this;
        }

        public Builder withBrowser(HarBrowser browser) {
            this.browser = browser;
            return this;
        }

        public Builder withPages(List<HarPage> pages) {
            this.pages = pages;
            return this;
        }

        public Builder addPage(HarPage page) {
            if (this.pages == null) {
                this.pages = new ArrayList<HarPage>();
            }
            this.pages.add(page);
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withOutputFile(File harFile) {
            this.harFile = harFile;
            return this;
        }

        public Builder withUsePrettyPrint(boolean usePrettyPrint) {
            this.usePrettyPrint = usePrettyPrint;
            return this;
        }

        public DefaultHarStreamWriter build() throws IOException {
            return new DefaultHarStreamWriter(this.harFile, this.version, this.creator, this.browser, this.pages, this.comment, this.usePrettyPrint);
        }
    }
}

