/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.har.builder;

import com.smartbear.har.model.HarCookie;
import com.smartbear.har.model.HarHeader;
import com.smartbear.har.model.HarPostData;
import com.smartbear.har.model.HarQueryString;
import com.smartbear.har.model.HarRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class HarRequestBuilder {
    private Long headersSize = -1L;
    private String method;
    private String url;
    private String httpVersion;
    private List<HarCookie> cookies = new ArrayList<HarCookie>();
    private List<HarHeader> headers = new ArrayList<HarHeader>();
    private List<HarQueryString> queryString = new ArrayList<HarQueryString>();
    private HarPostData postData;
    private Long bodySize = -1L;
    private String comment;

    public HarRequestBuilder withHeadersSize(Long headersSize) {
        this.headersSize = headersSize;
        return this;
    }

    public HarRequestBuilder withMethod(String method) {
        this.method = method;
        return this;
    }

    public HarRequestBuilder withUrl(String url) {
        this.url = url;
        return this;
    }

    public HarRequestBuilder withHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    public HarRequestBuilder withCookies(List<HarCookie> cookies) {
        this.cookies = cookies;
        return this;
    }

    public HarRequestBuilder withHeaders(List<HarHeader> headers) {
        this.headers = headers;
        return this;
    }

    public HarRequestBuilder withQueryString(List<HarQueryString> queryString) {
        this.queryString = queryString;
        return this;
    }

    public HarRequestBuilder withQueryString(String queryString) throws UnsupportedEncodingException {
        String[] parameters;
        ArrayList<HarQueryString> queryStrings = new ArrayList<HarQueryString>();
        for (String parameter : parameters = queryString.split("&")) {
            String value;
            int idx = parameter.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(parameter.substring(0, idx), "UTF-8") : parameter;
            String string = value = idx > 0 && parameter.length() > idx + 1 ? URLDecoder.decode(parameter.substring(idx + 1), "UTF-8") : "";
            if (key.isEmpty()) continue;
            queryStrings.add(new HarQueryString(key, value, ""));
        }
        this.queryString = queryStrings;
        return this;
    }

    public HarRequestBuilder withPostData(HarPostData postData) {
        this.postData = postData;
        return this;
    }

    public HarRequestBuilder withBodySize(Long bodySize) {
        this.bodySize = bodySize;
        return this;
    }

    public HarRequestBuilder withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public HarRequest build() {
        return new HarRequest(this.headersSize, this.method, this.url, this.httpVersion, this.cookies, this.headers, this.queryString, this.postData, this.bodySize, this.comment);
    }
}

