/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.util.TruffleReadOnlyMap;
import com.oracle.truffle.regex.util.TruffleReadOnlyMapFactory;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=TruffleReadOnlyMap.class)
final class TruffleReadOnlyMapGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private TruffleReadOnlyMapGen() {
    }

    static {
        LibraryExport.register(TruffleReadOnlyMap.class, new InteropLibraryExports());
    }

    @GeneratedBy(value=TruffleReadOnlyMap.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, TruffleReadOnlyMap.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof TruffleReadOnlyMap);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof TruffleReadOnlyMap);
            return new Cached(receiver);
        }

        @GeneratedBy(value=TruffleReadOnlyMap.class)
        private static final class Uncached
        extends InteropLibrary {
            private final Class<? extends TruffleReadOnlyMap> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((TruffleReadOnlyMap)receiver).getClass();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractRegexObject)receiver).hasLanguage();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractRegexObject)receiver).getLanguage();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractRegexObject)receiver).toDisplayString(allowSideEffects);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((TruffleReadOnlyMap)receiver).hasMembers();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((TruffleReadOnlyMap)receiver).getMembers(includeInternal);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleReadOnlyMap arg0Value = (TruffleReadOnlyMap)arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, TruffleReadOnlyMapFactory.IsReadableCacheNodeGen.getUncached(), ValueProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleReadOnlyMap arg0Value = (TruffleReadOnlyMap)arg0Value_;
                return arg0Value.readMember(arg1Value, TruffleReadOnlyMapFactory.ReadCacheNodeGen.getUncached(), ValueProfile.getUncached());
            }
        }

        @GeneratedBy(value=TruffleReadOnlyMap.class)
        private static final class Cached
        extends InteropLibrary {
            private final Class<? extends TruffleReadOnlyMap> receiverClass_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @CompilerDirectives.CompilationFinal
            private ValueProfile receiverProfile;
            @Node.Child
            private TruffleReadOnlyMap.IsReadableCacheNode isMemberReadableNode__cache_;
            @Node.Child
            private TruffleReadOnlyMap.ReadCacheNode readMemberNode__readCache_;

            Cached(Object originalReceiver) {
                TruffleReadOnlyMap receiver = (TruffleReadOnlyMap)originalReceiver;
                this.receiverClass_ = receiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CompilerDirectives.castExact(receiver, this.receiverClass_).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CompilerDirectives.castExact(receiver, this.receiverClass_).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CompilerDirectives.castExact(receiver, this.receiverClass_).toDisplayString(allowSideEffects);
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CompilerDirectives.castExact(receiver, this.receiverClass_).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CompilerDirectives.castExact(receiver, this.receiverClass_).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                TruffleReadOnlyMap arg0Value = CompilerDirectives.castExact(arg0Value_, this.receiverClass_);
                int state = this.state_;
                if ((state & 1) != 0) {
                    return arg0Value.isMemberReadable(arg1Value, this.isMemberReadableNode__cache_, this.receiverProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(TruffleReadOnlyMap arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.isMemberReadableNode__cache_ = super.insert(TruffleReadOnlyMapFactory.IsReadableCacheNodeGen.create());
                    if (this.receiverProfile == null) {
                        this.receiverProfile = ValueProfile.createIdentityProfile();
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isMemberReadable(arg1Value, this.isMemberReadableNode__cache_, this.receiverProfile);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                TruffleReadOnlyMap arg0Value = CompilerDirectives.castExact(arg0Value_, this.receiverClass_);
                int state = this.state_;
                if ((state & 2) != 0) {
                    return arg0Value.readMember(arg1Value, this.readMemberNode__readCache_, this.receiverProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(TruffleReadOnlyMap arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.readMemberNode__readCache_ = super.insert(TruffleReadOnlyMapFactory.ReadCacheNodeGen.create());
                    if (this.receiverProfile == null) {
                        this.receiverProfile = ValueProfile.createIdentityProfile();
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.readMember(arg1Value, this.readMemberNode__readCache_, this.receiverProfile);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

