/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.regex.tregex.nodes.dfa.AllTransitionsInOneTreeMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCG;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCGTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.Matchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNode;
import com.oracle.truffle.regex.tregex.string.AbstractString;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public class DFAStateNode
extends DFAAbstractStateNode {
    private static final byte FLAG_FINAL_STATE = 1;
    private static final byte FLAG_ANCHORED_FINAL_STATE = 2;
    private static final byte FLAG_HAS_BACKWARD_PREFIX_STATE = 4;
    private static final byte FLAG_UTF_16_MUST_DECODE = 8;
    private final byte flags;
    private final short loopTransitionIndex;
    @Node.Child
    LoopOptimizationNode loopOptimizationNode;
    @Node.Child
    Matchers matchers;
    private final DFASimpleCG simpleCG;
    private final AllTransitionsInOneTreeMatcher allTransitionsInOneTreeMatcher;
    private final BranchProfile stateReachedProfile = BranchProfile.create();

    DFAStateNode(DFAStateNode nodeSplitCopy, short copyID) {
        this(copyID, nodeSplitCopy.flags, nodeSplitCopy.loopTransitionIndex, nodeSplitCopy.loopOptimizationNode.nodeSplitCopy(), Arrays.copyOf(nodeSplitCopy.getSuccessors(), nodeSplitCopy.getSuccessors().length), nodeSplitCopy.getMatchers(), nodeSplitCopy.simpleCG, nodeSplitCopy.allTransitionsInOneTreeMatcher);
    }

    public DFAStateNode(short id, byte flags, short loopTransitionIndex, LoopOptimizationNode loopOptimizationNode, short[] successors, Matchers matchers, DFASimpleCG simpleCG, AllTransitionsInOneTreeMatcher allTransitionsInOneTreeMatcher) {
        super(id, successors);
        assert (id > 0);
        this.flags = flags;
        this.loopTransitionIndex = loopTransitionIndex;
        this.loopOptimizationNode = loopOptimizationNode;
        this.matchers = matchers;
        this.simpleCG = simpleCG;
        this.allTransitionsInOneTreeMatcher = allTransitionsInOneTreeMatcher;
    }

    public static byte buildFlags(boolean finalState, boolean anchoredFinalState, boolean hasBackwardPrefixState, boolean utf16MustDecode) {
        byte flags = 0;
        if (finalState) {
            flags = (byte)(flags | 1);
        }
        if (anchoredFinalState) {
            flags = (byte)(flags | 2);
        }
        if (hasBackwardPrefixState) {
            flags = (byte)(flags | 4);
        }
        if (utf16MustDecode) {
            flags = (byte)(flags | 8);
        }
        return flags;
    }

    @Override
    public DFAStateNode createNodeSplitCopy(short copyID) {
        return new DFAStateNode(this, copyID);
    }

    public final Matchers getMatchers() {
        return this.matchers;
    }

    public BranchProfile getStateReachedProfile() {
        return this.stateReachedProfile;
    }

    public boolean isFinalState() {
        return this.flagIsSet((byte)1);
    }

    public boolean isAnchoredFinalState() {
        return this.flagIsSet((byte)2);
    }

    public boolean hasBackwardPrefixState() {
        return this.flagIsSet((byte)4);
    }

    public boolean utf16MustDecode() {
        return this.flagIsSet((byte)8);
    }

    private boolean flagIsSet(byte flag) {
        return (this.flags & flag) != 0;
    }

    public boolean hasLoopToSelf() {
        return this.loopTransitionIndex >= 0;
    }

    boolean isLoopToSelf(int transitionIndex) {
        return this.hasLoopToSelf() && transitionIndex == this.getLoopToSelf();
    }

    short getLoopToSelf() {
        assert (this.hasLoopToSelf());
        return this.loopTransitionIndex;
    }

    boolean treeTransitionMatching() {
        return this.allTransitionsInOneTreeMatcher != null;
    }

    AllTransitionsInOneTreeMatcher getTreeMatcher() {
        return this.allTransitionsInOneTreeMatcher;
    }

    boolean canDoIndexOf() {
        return this.hasLoopToSelf() && this.loopOptimizationNode != null;
    }

    void beforeFindSuccessor(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant(this);
        this.checkFinalState(locals, executor);
    }

    void afterIndexOf(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int preLoopIndex, int postLoopIndex) {
        locals.setIndex(postLoopIndex);
        if (this.simpleCG != null && locals.getIndex() > preLoopIndex) {
            int curIndex = locals.getIndex();
            executor.inputSkipReverse(locals);
            this.applySimpleCGTransition(this.simpleCG.getTransitions()[this.getLoopToSelf()], locals);
            locals.setIndex(curIndex);
        }
        this.checkFinalState(locals, executor);
    }

    boolean sameResultAsRegularMatchers(int c, int allTransitionsMatcherResult) {
        CompilerAsserts.neverPartOfCompilation();
        return allTransitionsMatcherResult == this.matchers.match(c);
    }

    private void checkFinalState(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant(this);
        if (this.isFinalState()) {
            this.storeResult(locals, executor, false);
            if (this.simpleCG != null) {
                this.applySimpleCGFinalTransition(this.simpleCG.getTransitionToFinalState(), executor, locals);
            }
        }
    }

    void atEnd(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        boolean anchored;
        CompilerAsserts.partialEvaluationConstant(this);
        boolean bl = anchored = this.isAnchoredFinalState() && executor.inputAtEnd(locals);
        if (this.isFinalState() || anchored) {
            this.storeResult(locals, executor, anchored);
            if (this.simpleCG != null) {
                if (this.isAnchoredFinalState()) {
                    this.applySimpleCGFinalTransition(this.simpleCG.getTransitionToAnchoredFinalState(), executor, locals);
                } else if (this.isFinalState()) {
                    this.applySimpleCGFinalTransition(this.simpleCG.getTransitionToFinalState(), executor, locals);
                }
            }
        }
    }

    void successorFound(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int i) {
        if (this.simpleCG != null) {
            this.applySimpleCGTransition(this.simpleCG.getTransitions()[i], locals);
        }
    }

    void storeResult(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean anchored) {
        CompilerAsserts.partialEvaluationConstant(this);
        if (executor.isSimpleCG()) {
            if (executor.getProperties().isSimpleCGMustCopy()) {
                System.arraycopy(locals.getCGData().results, 0, locals.getCGData().currentResult, 0, locals.getCGData().currentResult.length);
            }
            locals.setResultInt(0);
        } else {
            locals.setResultInt(locals.getIndex());
        }
    }

    static int[] simpleCGFinalTransitionTargetArray(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        return executor.getProperties().isSimpleCGMustCopy() ? locals.getCGData().currentResult : locals.getCGData().results;
    }

    void applySimpleCGTransition(DFASimpleCGTransition transition, TRegexDFAExecutorLocals locals) {
        transition.apply(locals.getCGData().results, locals.getIndex());
    }

    void applySimpleCGFinalTransition(DFASimpleCGTransition transition, TRegexDFAExecutorNode executor, TRegexDFAExecutorLocals locals) {
        transition.apply(DFAStateNode.simpleCGFinalTransitionTargetArray(locals, executor), locals.getIndex());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder();
        DebugUtil.appendNodeId(sb, this.getId()).append(": ");
        if (!this.treeTransitionMatching()) {
            sb.append(this.matchers.size()).append(" successors");
        }
        if (this.isAnchoredFinalState()) {
            sb.append(", AFS");
        }
        if (this.isFinalState()) {
            sb.append(", FS");
        }
        sb.append(":\n");
        if (this.treeTransitionMatching()) {
            sb.append("      ").append(this.getTreeMatcher()).append("\n      successors: ").append(Arrays.toString(this.successors)).append("\n");
        } else {
            for (int i = 0; i < this.matchers.size(); ++i) {
                sb.append("      ").append(i).append(": ").append(this.matchers.toString(i)).append(" -> ");
                DebugUtil.appendNodeId(sb, this.getSuccessors()[i]).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        JsonArray transitions = Json.array(new JsonConvertible[0]);
        if (this.matchers != null) {
            for (int i = 0; i < this.matchers.size(); ++i) {
                transitions.append(Json.obj(Json.prop("matcher", this.matchers.toString(i)), Json.prop("target", this.successors[i])));
            }
        }
        return Json.obj(Json.prop("id", this.getId()), Json.prop("anchoredFinalState", this.isAnchoredFinalState()), Json.prop("finalState", this.isFinalState()), Json.prop("loopToSelf", this.hasLoopToSelf()), Json.prop("transitions", transitions));
    }

    public static final class LoopOptIndexOfStringNode
    extends LoopOptimizationNode {
        private final AbstractString str;
        private final AbstractString mask;
        @Node.Child
        private InputIndexOfStringNode indexOfNode;

        public LoopOptIndexOfStringNode(AbstractString str, AbstractString mask) {
            this.str = str;
            this.mask = mask;
        }

        private LoopOptIndexOfStringNode(LoopOptIndexOfStringNode copy) {
            this.str = copy.str;
            this.mask = copy.mask;
        }

        @Override
        public int execute(Object input, int fromIndex, int maxIndex) {
            return this.getIndexOfNode().execute(input, fromIndex, maxIndex, this.str.content(), this.mask == null ? null : this.mask.content());
        }

        @Override
        public int encodedLength() {
            return this.str.encodedLength();
        }

        @Override
        LoopOptimizationNode nodeSplitCopy() {
            return new LoopOptIndexOfStringNode(this);
        }

        private InputIndexOfStringNode getIndexOfNode() {
            if (this.indexOfNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.indexOfNode = this.insert(InputIndexOfStringNode.create());
            }
            return this.indexOfNode;
        }
    }

    public static final class LoopOptIndexOfAnyByteNode
    extends LoopOptIndexOfAnyNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final byte[] bytes;

        public LoopOptIndexOfAnyByteNode(byte[] bytes) {
            this.bytes = bytes;
        }

        private LoopOptIndexOfAnyByteNode(LoopOptIndexOfAnyByteNode copy) {
            this.bytes = copy.bytes;
        }

        @Override
        public int execute(Object input, int fromIndex, int maxIndex) {
            return this.getIndexOfNode().execute(input, fromIndex, maxIndex, this.bytes);
        }

        @Override
        LoopOptimizationNode nodeSplitCopy() {
            return new LoopOptIndexOfAnyByteNode(this);
        }
    }

    public static final class LoopOptIndexOfAnyCharNode
    extends LoopOptIndexOfAnyNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final char[] chars;

        public LoopOptIndexOfAnyCharNode(char[] chars) {
            this.chars = chars;
        }

        private LoopOptIndexOfAnyCharNode(LoopOptIndexOfAnyCharNode copy) {
            this.chars = copy.chars;
        }

        @Override
        public int execute(Object input, int fromIndex, int maxIndex) {
            return this.getIndexOfNode().execute(input, fromIndex, maxIndex, this.chars);
        }

        @Override
        LoopOptimizationNode nodeSplitCopy() {
            return new LoopOptIndexOfAnyCharNode(this);
        }
    }

    public static abstract class LoopOptIndexOfAnyNode
    extends LoopOptimizationNode {
        @Node.Child
        private InputIndexOfNode indexOfNode;

        @Override
        public int encodedLength() {
            return 1;
        }

        InputIndexOfNode getIndexOfNode() {
            if (this.indexOfNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.indexOfNode = this.insert(InputIndexOfNode.create());
            }
            return this.indexOfNode;
        }
    }

    public static abstract class LoopOptimizationNode
    extends Node {
        public abstract int execute(Object var1, int var2, int var3);

        public abstract int encodedLength();

        abstract LoopOptimizationNode nodeSplitCopy();
    }
}

