/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.regex.runtime.nodes.StringEqualsNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=StringEqualsNode.class)
public final class StringEqualsNodeGen
extends StringEqualsNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private CacheIdentityData cacheIdentity_cache;

    private StringEqualsNodeGen() {
    }

    @Override
    @ExplodeLoop
    public boolean execute(String arg0Value, String arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CacheIdentityData s1_ = this.cacheIdentity_cache;
                while (s1_ != null) {
                    if (arg0Value == s1_.cachedA_ && s1_.cachedA_.equals(arg1Value)) {
                        return StringEqualsNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedA_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return StringEqualsNode.doEquals(arg0Value, arg1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(String arg0Value, String arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0) {
                String cachedA__;
                int count1_ = 0;
                CacheIdentityData s1_ = this.cacheIdentity_cache;
                if ((state & 1) != 0) {
                    while (!(s1_ == null || arg0Value == s1_.cachedA_ && s1_.cachedA_.equals(arg1Value))) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (cachedA__ = arg0Value).equals(arg1Value) && count1_ < 4) {
                    s1_ = new CacheIdentityData(this.cacheIdentity_cache);
                    s1_.cachedA_ = cachedA__;
                    this.cacheIdentity_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = StringEqualsNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedA_);
                    return bl;
                }
            }
            this.exclude_ = exclude |= 1;
            this.cacheIdentity_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            boolean bl = StringEqualsNode.doEquals(arg0Value, arg1Value);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        CacheIdentityData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cacheIdentity_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static StringEqualsNode create() {
        return new StringEqualsNodeGen();
    }

    public static StringEqualsNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=StringEqualsNode.class)
    private static final class Uncached
    extends StringEqualsNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean execute(String arg0Value, String arg1Value) {
            return StringEqualsNode.doEquals(arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=StringEqualsNode.class)
    private static final class CacheIdentityData {
        @CompilerDirectives.CompilationFinal
        CacheIdentityData next_;
        @CompilerDirectives.CompilationFinal
        String cachedA_;

        CacheIdentityData(CacheIdentityData next_) {
            this.next_ = next_;
        }
    }
}

