/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexSource;

public class RegexSyntaxException
extends RuntimeException
implements TruffleException {
    private static final String template = "Invalid regular expression: /%s/%s: %s";
    private static final String templateNoFlags = "Invalid regular expression: %s: %s";
    private static final String templatePosition = "Invalid regular expression: /%s/%s:%d: %s";
    private final String reason;
    private final RegexSource regexSrc;
    private final int position;
    private static final long serialVersionUID = 1L;

    public RegexSyntaxException(String msg) {
        super(msg);
        this.reason = msg;
        this.regexSrc = null;
        this.position = -1;
    }

    @CompilerDirectives.TruffleBoundary
    public RegexSyntaxException(String pattern, String msg) {
        this(String.format(templateNoFlags, pattern, msg), msg, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RegexSyntaxException(RegexSource source, String msg) {
        this(String.format(template, source.getPattern(), source.getFlags(), msg), msg, source);
    }

    @CompilerDirectives.TruffleBoundary
    public RegexSyntaxException(RegexSource source, String msg, int position) {
        this(String.format(templatePosition, source.getPattern(), source.getFlags(), position, msg), msg, source, position);
    }

    private RegexSyntaxException(String exceptionMsg, String reason, RegexSource regexSrc) {
        this(exceptionMsg, reason, regexSrc, -1);
    }

    private RegexSyntaxException(String exceptionMsg, String reason, RegexSource regexSrc, int position) {
        super(exceptionMsg);
        this.reason = reason;
        this.regexSrc = regexSrc;
        this.position = position;
    }

    @Override
    public boolean isSyntaxError() {
        return true;
    }

    @Override
    public Node getLocation() {
        return null;
    }

    public String getReason() {
        return this.reason;
    }

    public RegexSource getRegex() {
        return this.regexSrc;
    }

    public Integer getPosition() {
        return this.position;
    }
}

