/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.GuestToHostRootNode;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotBindings;
import com.oracle.truffle.polyglot.PolyglotContextConfig;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageBindings;
import com.oracle.truffle.polyglot.PolyglotLanguageContextFactory;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.PolyglotSourceCache;
import com.oracle.truffle.polyglot.PolyglotThread;
import com.oracle.truffle.polyglot.PolyglotThreadInfo;
import com.oracle.truffle.polyglot.PolyglotValue;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.proxy.Proxy;

final class PolyglotLanguageContext
implements PolyglotImpl.VMObject {
    private static final TruffleLogger LOG = TruffleLogger.getLogger("engine", PolyglotLanguageContext.class);
    final PolyglotContextImpl context;
    final PolyglotLanguage language;
    final boolean eventsEnabled;
    private volatile Thread creatingThread;
    private volatile boolean initialized;
    volatile boolean finalized;
    @CompilerDirectives.CompilationFinal
    private volatile Value hostBindings;
    @CompilerDirectives.CompilationFinal
    private volatile Lazy lazy;
    @CompilerDirectives.CompilationFinal
    volatile TruffleLanguage.Env env;
    @CompilerDirectives.CompilationFinal
    private volatile List<Object> languageServices = Collections.emptyList();

    PolyglotLanguageContext(PolyglotContextImpl context, PolyglotLanguage language) {
        this.context = context;
        this.language = language;
        this.eventsEnabled = !language.isHost();
    }

    boolean isPolyglotBindingsAccessAllowed() {
        if (this.context.config.polyglotAccess == PolyglotAccess.ALL) {
            return true;
        }
        UnmodifiableEconomicSet<String> accessibleLanguages = this.getAPIAccess().getBindingsAccess(this.context.config.polyglotAccess);
        if (accessibleLanguages == null) {
            return true;
        }
        return accessibleLanguages.contains(this.language.getId());
    }

    boolean isPolyglotEvalAllowed(String targetLanguage) {
        if (this.context.config.polyglotAccess == PolyglotAccess.ALL) {
            return true;
        }
        if (targetLanguage != null && this.language.getId().equals(targetLanguage)) {
            return true;
        }
        UnmodifiableEconomicSet<String> accessibleLanguages = this.getAPIAccess().getEvalAccess(this.context.config.polyglotAccess, this.language.getId());
        if (accessibleLanguages == null || accessibleLanguages.isEmpty()) {
            return false;
        }
        if (accessibleLanguages.size() > 1 || !((String)accessibleLanguages.iterator().next()).equals(this.language.getId())) {
            return targetLanguage == null || accessibleLanguages.contains(targetLanguage);
        }
        return false;
    }

    Thread.UncaughtExceptionHandler getPolyglotExceptionHandler() {
        assert (this.env != null);
        return this.lazy.uncaughtExceptionHandler;
    }

    Map<Class<?>, PolyglotValue> getValueCache() {
        assert (this.env != null);
        return this.lazy.valueCache;
    }

    Map<String, LanguageInfo> getAccessibleLanguages(boolean allowInternalAndDependent) {
        if (allowInternalAndDependent) {
            return this.lazy.accessibleInternalLanguages;
        }
        return this.lazy.accessiblePublicLanguages;
    }

    PolyglotLanguageInstance getLanguageInstance() {
        assert (this.env != null);
        return this.lazy.languageInstance;
    }

    private void checkThreadAccess(TruffleLanguage.Env localEnv) {
        assert (Thread.holdsLock(this.context));
        boolean singleThreaded = this.context.isSingleThreaded();
        Thread firstFailingThread = null;
        for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
            if (EngineAccessor.LANGUAGE.isThreadAccessAllowed(localEnv, threadInfo.getThread(), singleThreaded)) continue;
            firstFailingThread = threadInfo.getThread();
            break;
        }
        if (firstFailingThread != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(firstFailingThread, singleThreaded, Arrays.asList(this.language));
        }
    }

    Object getContextImpl() {
        if (this.env != null) {
            return EngineAccessor.LANGUAGE.getContext(this.env);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return null;
    }

    Object getPublicFileSystemContext() {
        Lazy l = this.lazy;
        if (l != null) {
            return l.publicFileSystemContext;
        }
        return null;
    }

    Object getInternalFileSystemContext() {
        Lazy l = this.lazy;
        if (l != null) {
            return l.internalFileSystemContext;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value getHostBindings() {
        assert (this.initialized);
        if (this.hostBindings == null) {
            PolyglotLanguageContext polyglotLanguageContext = this;
            synchronized (polyglotLanguageContext) {
                if (this.hostBindings == null) {
                    Object prev = this.context.engine.enterIfNeeded(this.context);
                    try {
                        Iterable<Scope> scopes = EngineAccessor.LANGUAGE.findTopScopes(this.env);
                        this.hostBindings = this.asValue(PolyglotLanguageBindings.create(scopes));
                    }
                    finally {
                        this.context.engine.leaveIfNeeded(prev, this.context);
                    }
                }
            }
        }
        return this.hostBindings;
    }

    Object getPolyglotGuestBindings() {
        assert (this.isInitialized());
        return this.lazy.polyglotGuestBindings;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    CallTarget parseCached(PolyglotLanguage accessingLanguage, Source source, String[] argumentNames) throws AssertionError {
        this.ensureInitialized(accessingLanguage);
        PolyglotSourceCache cache = this.lazy.sourceCache;
        assert (cache != null);
        return cache.parseCached(this, source, argumentNames);
    }

    TruffleLanguage.Env requireEnv() {
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv == null) {
            throw CompilerDirectives.shouldNotReachHere("No language context is active on this thread.");
        }
        return localEnv;
    }

    boolean finalizeContext(boolean notifyInstruments) {
        if (!this.finalized) {
            this.finalized = true;
            EngineAccessor.LANGUAGE.finalizeContext(this.env);
            if (this.eventsEnabled && notifyInstruments) {
                EngineAccessor.INSTRUMENT.notifyLanguageContextFinalized(this.context.engine, this.context.truffleContext, this.language.info);
            }
            return true;
        }
        return false;
    }

    boolean dispose() {
        assert (Thread.holdsLock(this.context));
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv != null) {
            if (!this.lazy.activePolyglotThreads.isEmpty()) {
                throw new IllegalStateException("The language did not complete all polyglot threads but should have: " + this.lazy.activePolyglotThreads);
            }
            for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
                assert (threadInfo != PolyglotThreadInfo.NULL);
                Thread thread = threadInfo.getThread();
                if (thread == null || threadInfo.isPolyglotThread(this.context)) continue;
                EngineAccessor.LANGUAGE.disposeThread(localEnv, thread);
            }
            EngineAccessor.LANGUAGE.dispose(localEnv);
            return true;
        }
        return false;
    }

    void notifyDisposed(boolean notifyInstruments) {
        if (this.eventsEnabled && notifyInstruments) {
            EngineAccessor.INSTRUMENT.notifyLanguageContextDisposed(this.context.engine, this.context.truffleContext, this.language.info);
        }
        this.language.freeInstance(this.lazy.languageInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object enterThread(PolyglotThread thread) {
        assert (this.isInitialized());
        assert (Thread.currentThread() == thread);
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            Object prev = this.context.engine.enter(this.context);
            this.lazy.activePolyglotThreads.add(thread);
            return prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveThread(Object prev, PolyglotThread thread) {
        assert (this.isInitialized());
        assert (Thread.currentThread() == thread);
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            Map<Thread, PolyglotThreadInfo> seenThreads = this.context.getSeenThreads();
            PolyglotThreadInfo info = seenThreads.get(thread);
            if (info == null) {
                return;
            }
            for (PolyglotLanguageContext languageContext : this.context.contexts) {
                if (!languageContext.isInitialized()) continue;
                EngineAccessor.LANGUAGE.disposeThread(languageContext.env, thread);
            }
            this.lazy.activePolyglotThreads.remove(thread);
            this.context.engine.leave(prev, this.context);
            seenThreads.remove(thread);
        }
        EngineAccessor.INSTRUMENT.notifyThreadFinished(this.context.engine, this.context.truffleContext, thread);
    }

    boolean isCreated() {
        return this.lazy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureCreated(PolyglotLanguage accessingLanguage) {
        if (this.creatingThread == Thread.currentThread()) {
            throw PolyglotEngineException.illegalState(String.format("Cyclic access to language context for language %s. The context is currently being created.", this.language.getId()));
        }
        if (this.creatingThread != null) {
            boolean interrupted = false;
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                while (this.creatingThread != null) {
                    try {
                        this.context.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.lazy == null) {
            this.checkAccess(accessingLanguage);
            Map<String, Object> creatorConfig = this.context.creator == this.language ? this.context.creatorArguments : Collections.emptyMap();
            PolyglotContextConfig envConfig = this.context.config;
            PolyglotLanguageInstance lang = this.language.allocateInstance(envConfig.getOptionValues(this.language));
            try {
                PolyglotContextImpl polyglotContextImpl = this.context;
                synchronized (polyglotContextImpl) {
                    if (this.lazy == null) {
                        TruffleLanguage.Env localEnv = EngineAccessor.LANGUAGE.createEnv(this, lang.spi, envConfig.out, envConfig.err, envConfig.in, creatorConfig, envConfig.getOptionValues(this.language), envConfig.getApplicationArguments(this.language));
                        Lazy localLazy = new Lazy(lang, envConfig);
                        PolyglotValue.createDefaultValues(this.getImpl(), this, localLazy.valueCache);
                        this.checkThreadAccess(localEnv);
                        this.creatingThread = Thread.currentThread();
                        this.env = localEnv;
                        this.lazy = localLazy;
                        assert (EngineAccessor.LANGUAGE.getLanguage(this.env) != null);
                        try {
                            ArrayList<Object> languageServicesCollector = new ArrayList<Object>();
                            Object contextImpl = EngineAccessor.LANGUAGE.createEnvContext(localEnv, languageServicesCollector);
                            this.language.initializeContextClass(contextImpl);
                            this.context.contextImpls[lang.language.index] = contextImpl;
                            String errorMessage = PolyglotLanguageContext.verifyServices(this.language.info, languageServicesCollector, this.language.cache.getServices());
                            if (errorMessage != null) {
                                throw PolyglotEngineException.illegalState(errorMessage);
                            }
                            this.languageServices = languageServicesCollector;
                            lang.language.profile.notifyContextCreate(this, localEnv);
                            if (this.eventsEnabled) {
                                EngineAccessor.INSTRUMENT.notifyLanguageContextCreated(this.context.engine, this.context.truffleContext, this.language.info);
                            }
                            this.context.weakReference.freeInstances.add(lang);
                            lang = null;
                        }
                        catch (Throwable e) {
                            this.env = null;
                            this.lazy = null;
                            throw e;
                        }
                        finally {
                            this.creatingThread = null;
                            this.context.notifyAll();
                        }
                    }
                }
            }
            finally {
                if (lang != null) {
                    this.language.freeInstance(lang);
                }
            }
        }
    }

    void close() {
        assert (Thread.holdsLock(this.context));
        this.lazy = null;
        this.env = null;
    }

    private static String verifyServices(LanguageInfo info, List<Object> registeredServices, Collection<String> expectedServices) {
        for (String expectedService : expectedServices) {
            boolean found = false;
            for (Object registeredService : registeredServices) {
                if (!PolyglotLanguageContext.isSubType(registeredService.getClass(), expectedService)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return String.format("Language %s declares service %s but doesn't register it", info.getName(), expectedService);
        }
        return null;
    }

    private static boolean isSubType(Class<?> clazz, String serviceClass) {
        if (clazz == null) {
            return false;
        }
        if (serviceClass.equals(clazz.getName()) || serviceClass.equals(clazz.getCanonicalName())) {
            return true;
        }
        if (PolyglotLanguageContext.isSubType(clazz.getSuperclass(), serviceClass)) {
            return true;
        }
        for (Class<?> implementedInterface : clazz.getInterfaces()) {
            if (!PolyglotLanguageContext.isSubType(implementedInterface, serviceClass)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ensureInitialized(PolyglotLanguage accessingLanguage) {
        this.ensureCreated(accessingLanguage);
        boolean wasInitialized = false;
        if (!this.initialized) {
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                if (!this.initialized) {
                    this.initialized = true;
                    try {
                        if (!this.context.inContextPreInitialization) {
                            EngineAccessor.LANGUAGE.initializeThread(this.env, Thread.currentThread());
                        }
                        EngineAccessor.LANGUAGE.postInitEnv(this.env);
                        if (!this.context.isSingleThreaded()) {
                            EngineAccessor.LANGUAGE.initializeMultiThreading(this.env);
                        }
                        for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
                            Thread thread = threadInfo.getThread();
                            if (thread == Thread.currentThread()) continue;
                            EngineAccessor.LANGUAGE.initializeThread(this.env, thread);
                        }
                        wasInitialized = true;
                    }
                    catch (Throwable e) {
                        this.initialized = false;
                        throw e;
                    }
                }
            }
        }
        if (wasInitialized && this.eventsEnabled) {
            EngineAccessor.INSTRUMENT.notifyLanguageContextInitialized(this.context.engine, this.context.truffleContext, this.language.info);
        }
        return wasInitialized;
    }

    void checkAccess(PolyglotLanguage accessingLanguage) {
        this.context.checkClosed();
        if (this.context.disposing) {
            throw PolyglotEngineException.illegalState("The Context is already closed.");
        }
        if (!this.context.config.isAccessPermitted(accessingLanguage, this.language)) {
            throw PolyglotEngineException.illegalArgument(String.format("Access to language '%s' is not permitted. ", this.language.getId()));
        }
        RuntimeException initError = this.language.initError;
        if (initError != null) {
            throw PolyglotEngineException.illegalState(String.format("Initialization error: %s", initError.getMessage(), initError));
        }
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.context.getEngine();
    }

    boolean patch(PolyglotContextConfig newConfig) {
        if (this.isCreated()) {
            try {
                OptionValuesImpl newOptionValues = newConfig.getOptionValues(this.language);
                this.lazy.computeAccessPermissions(newConfig);
                TruffleLanguage.Env newEnv = EngineAccessor.LANGUAGE.patchEnvContext(this.env, newConfig.out, newConfig.err, newConfig.in, Collections.emptyMap(), newOptionValues, newConfig.getApplicationArguments(this.language));
                if (newEnv != null) {
                    this.env = newEnv;
                    this.lazy.languageInstance.patchFirstOptions(newOptionValues);
                    LOG.log(Level.FINE, "Successfully patched context of language: {0}", this.language.getId());
                    return true;
                }
                LOG.log(Level.FINE, "Failed to patch context of language: {0}", this.language.getId());
                return false;
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw t;
                }
                LOG.log(Level.FINE, "Exception during patching context of language: {0}", this.language.getId());
                throw GuestToHostRootNode.silenceException(RuntimeException.class, t);
            }
        }
        return true;
    }

    <S> S lookupService(Class<S> type) {
        for (Object languageService : this.languageServices) {
            if (!type.isInstance(languageService)) continue;
            return type.cast(languageService);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    Value asValue(Object guestValue) {
        assert (this.lazy != null);
        assert (guestValue != null);
        assert (!(guestValue instanceof Value));
        assert (!(guestValue instanceof Proxy));
        Object receiver = guestValue;
        PolyglotValue cache = this.lazy.valueCache.get(receiver.getClass());
        if (cache == null) {
            Object prev = this.language.engine.enterIfNeeded(this.context);
            try {
                cache = this.lookupValueCache(guestValue);
            }
            finally {
                this.language.engine.leaveIfNeeded(prev, this.context);
            }
        }
        return this.getAPIAccess().newValue(receiver, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized PolyglotValue lookupValueCache(final Object guestValue) {
        assert (this.toGuestValue(guestValue) == guestValue) : "Not a valid guest value: " + guestValue + ". Only interop values are allowed to be exported.";
        Object prev = this.context.engine.enterIfNeeded(this.context);
        try {
            PolyglotValue cache;
            PolyglotValue polyglotValue = cache = this.lazy.valueCache.computeIfAbsent(guestValue.getClass(), new Function<Class<?>, PolyglotValue>(){

                @Override
                public PolyglotValue apply(Class<?> t) {
                    return PolyglotValue.createInteropValue(PolyglotLanguageContext.this, (TruffleObject)guestValue, guestValue.getClass());
                }
            });
            return polyglotValue;
        }
        finally {
            this.context.engine.leaveIfNeeded(prev, this.context);
        }
    }

    Object toGuestValue(Class<?> receiver) {
        return HostObject.forClass(receiver, this);
    }

    Object toGuestValue(Object hostValue) {
        if (hostValue instanceof Value) {
            Value receiverValue = (Value)hostValue;
            PolyglotValue valueImpl = (PolyglotValue)this.getAPIAccess().getImpl(receiverValue);
            PolyglotContextImpl valueContext = valueImpl.languageContext != null ? valueImpl.languageContext.context : null;
            Object valueReceiver = this.getAPIAccess().getReceiver(receiverValue);
            if (valueContext != this.context) {
                valueReceiver = this.migrateValue(valueReceiver, valueContext);
            }
            return valueReceiver;
        }
        if (PolyglotImpl.isGuestPrimitive(hostValue)) {
            return hostValue;
        }
        if (hostValue instanceof Proxy) {
            return PolyglotProxy.toProxyGuestObject(this, (Proxy)hostValue);
        }
        if (hostValue instanceof TruffleObject) {
            return hostValue;
        }
        if (hostValue instanceof Class) {
            return HostObject.forClass((Class)hostValue, this);
        }
        if (hostValue == null) {
            return HostObject.NULL;
        }
        if (hostValue.getClass().isArray()) {
            return HostObject.forObject(hostValue, this);
        }
        if (HostWrapper.isInstance(hostValue)) {
            return this.migrateHostWrapper(HostWrapper.asInstance(hostValue));
        }
        return HostInteropReflect.asTruffleViaReflection(hostValue, this);
    }

    private Object migrateValue(Object value, PolyglotContextImpl valueContext) {
        if (PolyglotImpl.isGuestPrimitive(value)) {
            return value;
        }
        if (HostObject.isInstance(value)) {
            return ((HostObject)value).withContext(this);
        }
        if (PolyglotProxy.isProxyGuestObject(value)) {
            return PolyglotProxy.withContext(this, value);
        }
        if (valueContext == null) {
            assert (value instanceof TruffleObject);
            return value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw PolyglotEngineException.illegalArgument(String.format("The value '%s' cannot be passed from one context to another. The current context is 0x%x and the argument value originates from context 0x%x.", PolyglotValue.getValueInfo(null, value), this.context.hashCode(), valueContext.hashCode()));
    }

    private Object migrateHostWrapper(HostWrapper wrapper) {
        Object wrapped = wrapper.getGuestObject();
        PolyglotContextImpl valueContext = wrapper.getContext();
        if (valueContext != this.context) {
            wrapped = this.migrateValue(wrapped, valueContext);
        }
        return wrapped;
    }

    @CompilerDirectives.TruffleBoundary
    Value[] toHostValues(Object[] values, int startIndex) {
        Value[] args = new Value[values.length - startIndex];
        for (int i = startIndex; i < values.length; ++i) {
            args[i - startIndex] = this.asValue(values[i]);
        }
        return args;
    }

    @CompilerDirectives.TruffleBoundary
    Value[] toHostValues(Object[] values) {
        Value[] args = new Value[values.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.asValue(values[i]);
        }
        return args;
    }

    public String toString() {
        return "PolyglotLanguageContext [language=" + this.language + ", initialized=" + (this.env != null) + "]";
    }

    public Object getLanguageView(Object receiver) {
        EngineAccessor.INTEROP.checkInteropType(receiver);
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
        if (lib.hasLanguage(receiver)) {
            try {
                if (!this.isCreated()) {
                    throw PolyglotEngineException.illegalState("Language not yet created. Initialize the language first to request a language view.");
                }
                if (lib.getLanguage(receiver) == this.lazy.languageInstance.spi.getClass()) {
                    return receiver;
                }
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }
        return this.getLanguageViewNoCheck(receiver);
    }

    private boolean validLanguageView(Object result) {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(result);
        Class<?> languageClass = EngineAccessor.LANGUAGE.getLanguage(this.env).getClass();
        try {
            assert (lib.hasLanguage(result) && lib.getLanguage(result) == languageClass) : String.format("The returned language view of language '%s' must return the class '%s' for InteropLibrary.getLanguage.Fix the implementation of %s.getLanguageView to resolve this.", languageClass.getTypeName(), languageClass.getTypeName(), languageClass.getTypeName());
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        return true;
    }

    private boolean validScopedView(Object result) {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(result);
        Class<?> languageClass = EngineAccessor.LANGUAGE.getLanguage(this.env).getClass();
        try {
            assert (lib.hasLanguage(result) && lib.getLanguage(result) == languageClass) : String.format("The returned scoped view of language '%s' must return the class '%s' for InteropLibrary.getLanguage.Fix the implementation of %s.getScopedView to resolve this.", languageClass.getTypeName(), languageClass.getTypeName(), languageClass.getTypeName());
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        return true;
    }

    public Object getLanguageViewNoCheck(Object receiver) {
        Object result = EngineAccessor.LANGUAGE.getLanguageView(this.env, receiver);
        assert (this.validLanguageView(result));
        return result;
    }

    public Object getScopedView(Node location, Frame frame, Object value) {
        PolyglotLanguageContext.validateLocationAndFrame(this.language.info, location, frame);
        Object languageView = this.getLanguageView(value);
        Object result = EngineAccessor.LANGUAGE.getScopedView(this.env, location, frame, languageView);
        assert (this.validScopedView(result));
        return result;
    }

    private static void validateLocationAndFrame(LanguageInfo viewLanguage, Node location, Frame frame) {
        RootNode rootNode = location.getRootNode();
        if (rootNode == null) {
            throw PolyglotEngineException.illegalArgument(String.format("The location '%s' does not have a RootNode.", location));
        }
        LanguageInfo nodeLocation = rootNode.getLanguageInfo();
        if (nodeLocation == null) {
            throw PolyglotEngineException.illegalArgument(String.format("The location '%s' does not have a language associated.", location));
        }
        if (nodeLocation != viewLanguage) {
            throw PolyglotEngineException.illegalArgument(String.format("The view language '%s' must match the language of the location %s.", viewLanguage, nodeLocation));
        }
        if (!EngineAccessor.INSTRUMENT.isInstrumentable(location)) {
            throw PolyglotEngineException.illegalArgument(String.format("The location '%s' is not instrumentable but must be to request scoped views.", location));
        }
        if (!rootNode.getFrameDescriptor().equals(frame.getFrameDescriptor())) {
            throw PolyglotEngineException.illegalArgument(String.format("The frame provided does not originate from the location. Expected frame descriptor '%s' but was '%s'.", rootNode.getFrameDescriptor(), frame.getFrameDescriptor()));
        }
    }

    private class PolyglotUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private PolyglotUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            TruffleLanguage.Env currentEnv = PolyglotLanguageContext.this.env;
            if (currentEnv != null) {
                try {
                    e.printStackTrace(new PrintStream(currentEnv.err()));
                }
                catch (Throwable exc) {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
        }
    }

    static final class ToHostValueNode {
        final AbstractPolyglotImpl.APIAccess apiAccess;
        @CompilerDirectives.CompilationFinal
        volatile Class<?> cachedClass;
        @CompilerDirectives.CompilationFinal
        volatile PolyglotValue cachedValue;
        @CompilerDirectives.CompilationFinal
        volatile PolyglotLanguageContext cachedContext;

        private ToHostValueNode(PolyglotImpl polyglot) {
            this.apiAccess = polyglot.getAPIAccess();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Value execute(PolyglotLanguageContext languageContext, Object value) {
            Object receiver = value;
            Class<?> cachedClassLocal = this.cachedClass;
            PolyglotLanguageContext cachedContextLocal = this.cachedContext;
            if (cachedClassLocal == Generic.class) return languageContext.asValue(value);
            if (cachedClassLocal == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (languageContext.context.engine.boundEngine) {
                    this.cachedClass = receiver.getClass();
                    PolyglotValue cache = ((PolyglotLanguageContext)languageContext).lazy.valueCache.get(receiver.getClass());
                    if (cache == null) {
                        cache = languageContext.lookupValueCache(receiver);
                    }
                    this.cachedContext = languageContext;
                    this.cachedValue = cache;
                    return this.apiAccess.newValue(receiver, cache);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedClass = Generic.class;
                this.cachedContext = null;
                this.cachedValue = null;
                return languageContext.asValue(value);
            } else if (value.getClass() == cachedClassLocal && cachedContextLocal == languageContext) {
                receiver = CompilerDirectives.inInterpreter() ? receiver : CompilerDirectives.castExact(receiver, cachedClassLocal);
                PolyglotValue cache = this.cachedValue;
                if (cache != null) return this.apiAccess.newValue(receiver, cache);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return languageContext.asValue(value);
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedClass = Generic.class;
                this.cachedContext = null;
                this.cachedValue = null;
            }
            return languageContext.asValue(value);
        }

        public static ToHostValueNode create(PolyglotImpl polyglot) {
            return new ToHostValueNode(polyglot);
        }
    }

    @GenerateUncached
    static abstract class ToGuestValueNode
    extends Node {
        ToGuestValueNode() {
        }

        abstract Object execute(PolyglotLanguageContext var1, Object var2);

        @Specialization(guards={"receiver == null"})
        static Object doNull(PolyglotLanguageContext context, Object receiver) {
            return context.toGuestValue(receiver);
        }

        @Specialization(guards={"receiver != null", "receiver.getClass() == cachedReceiver"}, limit="3")
        static Object doCached(PolyglotLanguageContext context, Object receiver, @Cached(value="receiver.getClass()") Class<?> cachedReceiver) {
            return context.toGuestValue(cachedReceiver.cast(receiver));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"doCached"})
        static Object doUncached(PolyglotLanguageContext context, Object receiver) {
            return context.toGuestValue(receiver);
        }
    }

    static final class Generic {
        private Generic() {
            throw CompilerDirectives.shouldNotReachHere("no instances");
        }
    }

    static final class ToGuestValuesNode
    extends Node {
        @Node.Children
        private volatile ToGuestValueNode[] toGuestValue;
        @CompilerDirectives.CompilationFinal
        private volatile boolean needsCopy = false;
        @CompilerDirectives.CompilationFinal
        private volatile boolean generic = false;

        private ToGuestValuesNode() {
        }

        public Object[] apply(PolyglotLanguageContext languageContext, Object[] args) {
            ToGuestValueNode[] nodes = this.toGuestValue;
            if (nodes == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                nodes = new ToGuestValueNode[args.length];
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = PolyglotLanguageContextFactory.ToGuestValueNodeGen.create();
                }
                this.toGuestValue = this.insert(nodes);
            }
            if (args.length == nodes.length) {
                if (nodes.length == 0) {
                    return args;
                }
                Object[] newArgs = this.fastToGuestValuesUnroll(nodes, languageContext, args);
                return newArgs;
            }
            if (!this.generic || nodes.length != 1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                nodes = Arrays.copyOf(nodes, 1);
                if (nodes[0] == null) {
                    nodes[0] = PolyglotLanguageContextFactory.ToGuestValueNodeGen.create();
                }
                this.toGuestValue = this.insert(nodes);
                this.generic = true;
            }
            if (args.length == 0) {
                return args;
            }
            return this.fastToGuestValues(nodes[0], languageContext, args);
        }

        @ExplodeLoop
        private Object[] fastToGuestValuesUnroll(ToGuestValueNode[] nodes, PolyglotLanguageContext languageContext, Object[] args) {
            Object[] newArgs = this.needsCopy ? new Object[nodes.length] : args;
            for (int i = 0; i < nodes.length; ++i) {
                Object arg = args[i];
                Object newArg = nodes[i].execute(languageContext, arg);
                if (this.needsCopy) {
                    newArgs[i] = newArg;
                    continue;
                }
                if (arg == newArg) continue;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                newArgs = new Object[nodes.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[i] = newArg;
                this.needsCopy = true;
            }
            return newArgs;
        }

        private Object[] fastToGuestValues(ToGuestValueNode node, PolyglotLanguageContext languageContext, Object[] args) {
            assert (this.toGuestValue[0] != null);
            Object[] newArgs = this.needsCopy ? new Object[args.length] : args;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Object newArg = node.execute(languageContext, arg);
                if (this.needsCopy) {
                    newArgs[i] = newArg;
                    continue;
                }
                if (arg == newArg) continue;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                newArgs = new Object[args.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[i] = newArg;
                this.needsCopy = true;
            }
            return newArgs;
        }

        public static ToGuestValuesNode create() {
            return new ToGuestValuesNode();
        }
    }

    final class Lazy {
        final PolyglotSourceCache sourceCache;
        final Set<PolyglotThread> activePolyglotThreads;
        final Object polyglotGuestBindings;
        final Map<Class<?>, PolyglotValue> valueCache;
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        final PolyglotLanguageInstance languageInstance;
        @CompilerDirectives.CompilationFinal
        Map<String, LanguageInfo> accessibleInternalLanguages;
        @CompilerDirectives.CompilationFinal
        Map<String, LanguageInfo> accessiblePublicLanguages;
        final Object internalFileSystemContext;
        final Object publicFileSystemContext;

        Lazy(PolyglotLanguageInstance languageInstance, PolyglotContextConfig config) {
            this.languageInstance = languageInstance;
            this.sourceCache = languageInstance.getSourceCache();
            this.activePolyglotThreads = new HashSet<PolyglotThread>();
            this.polyglotGuestBindings = new PolyglotBindings(PolyglotLanguageContext.this);
            this.uncaughtExceptionHandler = new PolyglotUncaughtExceptionHandler();
            this.valueCache = new ConcurrentHashMap();
            this.computeAccessPermissions(config);
            this.publicFileSystemContext = EngineAccessor.LANGUAGE.createFileSystemContext(PolyglotLanguageContext.this, config.fileSystem);
            this.internalFileSystemContext = EngineAccessor.LANGUAGE.createFileSystemContext(PolyglotLanguageContext.this, config.internalFileSystem);
        }

        void computeAccessPermissions(PolyglotContextConfig config) {
            this.accessibleInternalLanguages = this.computeAccessibleLanguages(config, true);
            this.accessiblePublicLanguages = this.computeAccessibleLanguages(config, false);
        }

        private Map<String, LanguageInfo> computeAccessibleLanguages(PolyglotContextConfig config, boolean internal) {
            EconomicSet<String> resolveLanguages;
            PolyglotLanguage thisLanguage = this.languageInstance.language;
            if (thisLanguage.isHost()) {
                return this.languageInstance.getEngine().idToInternalLanguageInfo;
            }
            boolean embedderAllAccess = config.allowedPublicLanguages.isEmpty();
            PolyglotEngineImpl engine = this.languageInstance.getEngine();
            UnmodifiableEconomicSet<String> configuredAccess = engine.getAPIAccess().getEvalAccess(config.polyglotAccess, thisLanguage.getId());
            if (embedderAllAccess) {
                if (configuredAccess == null) {
                    if (internal) {
                        return engine.idToInternalLanguageInfo;
                    }
                    resolveLanguages = EconomicSet.create(Equivalence.DEFAULT, configuredAccess);
                    resolveLanguages.addAll(engine.idToInternalLanguageInfo.keySet());
                } else {
                    resolveLanguages = EconomicSet.create(Equivalence.DEFAULT, configuredAccess);
                    resolveLanguages.add(thisLanguage.getId());
                }
            } else {
                if (configuredAccess == null) {
                    configuredAccess = config.allowedPublicLanguages;
                }
                resolveLanguages = EconomicSet.create(Equivalence.DEFAULT, configuredAccess);
                resolveLanguages.add(thisLanguage.getId());
            }
            LinkedHashMap<String, LanguageInfo> resolvedLanguages = new LinkedHashMap<String, LanguageInfo>();
            for (String string : resolveLanguages) {
                PolyglotLanguage resolvedLanguage = engine.idToLanguage.get(string);
                if (resolvedLanguage == null || !internal && resolvedLanguage.cache.isInternal()) continue;
                resolvedLanguages.put(string, resolvedLanguage.info);
            }
            if (internal) {
                this.addDependentLanguages(engine, resolvedLanguages, thisLanguage);
            }
            if (internal) {
                for (Map.Entry entry : this.languageInstance.getEngine().idToLanguage.entrySet()) {
                    if (!((PolyglotLanguage)entry.getValue()).cache.isInternal()) continue;
                    resolvedLanguages.put((String)entry.getKey(), ((PolyglotLanguage)entry.getValue()).info);
                }
                assert (this.assertPermissionsConsistent(resolvedLanguages, this.languageInstance.language, config));
            }
            return resolvedLanguages;
        }

        private boolean assertPermissionsConsistent(Map<String, LanguageInfo> resolvedLanguages, PolyglotLanguage thisLanguage, PolyglotContextConfig config) {
            for (Map.Entry<String, PolyglotLanguage> entry : this.languageInstance.getEngine().idToLanguage.entrySet()) {
                boolean permitted = config.isAccessPermitted(thisLanguage, entry.getValue());
                assert (permitted == resolvedLanguages.containsKey(entry.getKey())) : "inconsistent access permissions";
            }
            return true;
        }

        private void addDependentLanguages(PolyglotEngineImpl engine, Map<String, LanguageInfo> resolvedLanguages, PolyglotLanguage currentLanguage) {
            for (String dependentLanguage : currentLanguage.cache.getDependentLanguages()) {
                PolyglotLanguage dependent = engine.idToLanguage.get(dependentLanguage);
                if (dependent == null || resolvedLanguages.containsKey(dependentLanguage)) continue;
                resolvedLanguages.put(dependentLanguage, dependent.info);
                this.addDependentLanguages(engine, resolvedLanguages, dependent);
            }
        }
    }
}

