/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostClassDesc;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.PolyglotTargetMapping;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class HostClassCache {
    static final PolyglotTargetMapping[] EMPTY_MAPPINGS = new PolyglotTargetMapping[0];
    private final AbstractPolyglotImpl.APIAccess apiAccess;
    final HostAccess hostAccess;
    private final boolean arrayAccess;
    private final boolean listAccess;
    private final Map<Class<?>, Object> targetMappings;
    private final Object unnamedModule;
    private final ClassValue<HostClassDesc> descs = new ClassValue<HostClassDesc>(){

        @Override
        protected HostClassDesc computeValue(Class<?> type) {
            return new HostClassDesc(HostClassCache.this, type);
        }
    };

    private HostClassCache(AbstractPolyglotImpl.APIAccess apiAccess, HostAccess conf, ClassLoader classLoader) {
        this.hostAccess = conf;
        this.arrayAccess = apiAccess.isArrayAccessible(this.hostAccess);
        this.listAccess = apiAccess.isListAccessible(this.hostAccess);
        this.apiAccess = apiAccess;
        this.targetMappings = HostClassCache.groupMappings(apiAccess, conf);
        this.unnamedModule = EngineAccessor.JDKSERVICES.getUnnamedModule(classLoader);
    }

    Object getUnnamedModule() {
        return this.unnamedModule;
    }

    boolean hasTargetMappings() {
        return this.targetMappings != null;
    }

    @CompilerDirectives.TruffleBoundary
    PolyglotTargetMapping[] getMappings(Class<?> targetType) {
        if (this.targetMappings != null) {
            Class<Object> lookupType = targetType.isPrimitive() ? (targetType == Byte.TYPE ? Byte.class : (targetType == Short.TYPE ? Short.class : (targetType == Integer.TYPE ? Integer.class : (targetType == Long.TYPE ? Long.class : (targetType == Float.TYPE ? Float.class : (targetType == Double.TYPE ? Double.class : (targetType == Boolean.TYPE ? Boolean.class : (targetType == Character.TYPE ? Character.class : (targetType == Void.TYPE ? Void.class : null))))))))) : targetType;
            PolyglotTargetMapping[] mappings = (PolyglotTargetMapping[])this.targetMappings.get(lookupType);
            if (mappings == null) {
                return EMPTY_MAPPINGS;
            }
            return mappings;
        }
        return EMPTY_MAPPINGS;
    }

    private static Map<Class<?>, Object> groupMappings(AbstractPolyglotImpl.APIAccess apiAccess, HostAccess conf) {
        List<Object> mappings = apiAccess.getTargetMappings(conf);
        if (mappings == null) {
            return null;
        }
        HashMap localMappings = new HashMap();
        for (Object object : mappings) {
            PolyglotTargetMapping map = (PolyglotTargetMapping)object;
            ArrayList<PolyglotTargetMapping> list = (ArrayList<PolyglotTargetMapping>)localMappings.get(map.targetType);
            if (list == null) {
                list = new ArrayList<PolyglotTargetMapping>();
                localMappings.put(map.targetType, list);
            }
            list.add(map);
        }
        for (Map.Entry entry : localMappings.entrySet()) {
            entry.setValue(((List)entry.getValue()).toArray(EMPTY_MAPPINGS));
        }
        return localMappings;
    }

    public static HostClassCache findOrInitialize(AbstractPolyglotImpl.APIAccess apiAccess, HostAccess conf, ClassLoader classLoader) {
        HostClassCache cache = (HostClassCache)apiAccess.getHostAccessImpl(conf);
        if (cache == null) {
            cache = HostClassCache.initializeHostCache(apiAccess, conf, classLoader);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HostClassCache initializeHostCache(AbstractPolyglotImpl.APIAccess apiAccess, HostAccess conf, ClassLoader classLoader) {
        HostClassCache cache;
        HostAccess hostAccess = conf;
        synchronized (hostAccess) {
            cache = (HostClassCache)apiAccess.getHostAccessImpl(conf);
            if (cache == null) {
                cache = new HostClassCache(apiAccess, conf, classLoader);
                apiAccess.setHostAccessImpl(conf, cache);
            }
        }
        return cache;
    }

    @CompilerDirectives.TruffleBoundary
    public static HostClassCache forInstance(HostObject receiver) {
        return receiver.getEngine().getHostClassCache();
    }

    @CompilerDirectives.TruffleBoundary
    HostClassDesc forClass(Class<?> clazz) {
        return this.descs.get(clazz);
    }

    @CompilerDirectives.TruffleBoundary
    boolean allowsAccess(Method m) {
        return this.apiAccess.allowsAccess(this.hostAccess, m);
    }

    @CompilerDirectives.TruffleBoundary
    boolean allowsAccess(Constructor<?> m) {
        return this.apiAccess.allowsAccess(this.hostAccess, m);
    }

    @CompilerDirectives.TruffleBoundary
    boolean allowsAccess(Field f) {
        return this.apiAccess.allowsAccess(this.hostAccess, f);
    }

    boolean isArrayAccess() {
        return this.arrayAccess;
    }

    boolean isListAccess() {
        return this.listAccess;
    }

    boolean allowsImplementation(Class<?> type) {
        return this.apiAccess.allowsImplementation(this.hostAccess, type);
    }
}

