/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakMap
implements Map<DynamicObject, Object> {
    private static final HiddenKey INVERTED_WEAK_MAP_KEY = new HiddenKey("InvertedWeakMap");

    public static PropertyGetNode createInvertedKeyMapGetNode(JSContext context) {
        return PropertyGetNode.createGetHidden(INVERTED_WEAK_MAP_KEY, context);
    }

    public static HasHiddenKeyCacheNode createInvertedKeyMapHasNode() {
        return HasHiddenKeyCacheNode.create(INVERTED_WEAK_MAP_KEY);
    }

    private static DynamicObject checkKey(Object key) {
        if (!(key instanceof DynamicObject)) {
            throw new IllegalArgumentException("key must be instanceof DynamicObject");
        }
        return (DynamicObject)key;
    }

    private static Map<WeakMap, Object> getInvertedMap(DynamicObject k, boolean put) {
        if (k.containsKey(INVERTED_WEAK_MAP_KEY)) {
            return (WeakHashMap)k.get(INVERTED_WEAK_MAP_KEY);
        }
        if (put) {
            return WeakMap.putInvertedMap(k);
        }
        return Collections.emptyMap();
    }

    private static WeakHashMap<WeakMap, Object> putInvertedMap(DynamicObject k) {
        WeakHashMap<WeakMap, Object> invertedMap = new WeakHashMap<WeakMap, Object>();
        boolean wasNotExtensible = !JSShape.isExtensible(k.getShape());
        k.define(INVERTED_WEAK_MAP_KEY, invertedMap);
        if (wasNotExtensible && JSObject.isExtensible(k)) {
            k.delete(JSShape.NOT_EXTENSIBLE_KEY);
            JSObject.preventExtensions(k);
            assert (!JSObject.isExtensible(k));
        }
        return invertedMap;
    }

    @Override
    public boolean containsKey(Object key) {
        DynamicObject k = WeakMap.checkKey(key);
        return WeakMap.getInvertedMap(k, false).containsKey(this);
    }

    @Override
    public Object get(Object key) {
        DynamicObject k = WeakMap.checkKey(key);
        return WeakMap.getInvertedMap(k, false).get(this);
    }

    @Override
    public Object put(DynamicObject key, Object value) {
        DynamicObject k = WeakMap.checkKey(key);
        return WeakMap.getInvertedMap(k, true).put(this, value);
    }

    @Override
    public Object remove(Object key) {
        DynamicObject k = WeakMap.checkKey(key);
        return WeakMap.getInvertedMap(k, false).remove(this);
    }

    @Override
    public void putAll(Map<? extends DynamicObject, ? extends Object> m) {
        m.forEach(this::put);
    }

    @Override
    public boolean containsValue(Object value) {
        throw WeakMap.unsupported();
    }

    @Override
    public int size() {
        throw WeakMap.unsupported();
    }

    @Override
    public boolean isEmpty() {
        throw WeakMap.unsupported();
    }

    @Override
    public void clear() {
        throw WeakMap.unsupported();
    }

    @Override
    public Set<DynamicObject> keySet() {
        throw WeakMap.unsupported();
    }

    @Override
    public Collection<Object> values() {
        throw WeakMap.unsupported();
    }

    @Override
    public Set<Map.Entry<DynamicObject, Object>> entrySet() {
        throw WeakMap.unsupported();
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Not supported by WeakMap");
    }
}

