/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.truffleinterop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNodeGen;
import com.oracle.truffle.js.nodes.promise.UnwrapPromiseNode;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.truffleinterop.InteropAsyncFunction;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InteropAsyncFunction.class)
final class InteropAsyncFunctionGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private InteropAsyncFunctionGen() {
    }

    static {
        LibraryExport.register(InteropAsyncFunction.class, new InteropLibraryExports());
    }

    @GeneratedBy(value=InteropAsyncFunction.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet(InteropAsyncFunctionGen.access$100(), "isExecutable", "execute");

        private InteropLibraryExports() {
            super(InteropLibrary.class, InteropAsyncFunction.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof InteropAsyncFunction);
            InteropLibrary uncached = InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, new Uncached());
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof InteropAsyncFunction);
            return InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, new Cached(receiver));
        }

        @GeneratedBy(value=InteropAsyncFunction.class)
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);
            private final TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_ = this.lookupContextReference(JavaScriptLanguage.class);

            Uncached() {
            }

            @Override
            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            @Override
            public Object readDelegateExport(Object receiver_) {
                return ((InteropAsyncFunction)receiver_).function;
            }

            @Override
            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof InteropAsyncFunction) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof InteropAsyncFunction;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropAsyncFunction)receiver).isExecutable();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropAsyncFunction arg0Value = (InteropAsyncFunction)arg0Value_;
                return arg0Value.execute(arg1Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), JSInteropExecuteNodeGen.getUncached(), ExportValueNodeGen.getUncached(), UnwrapPromiseNode.getUncached());
            }
        }

        @GeneratedBy(value=InteropAsyncFunction.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverFunctionInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;
            @Node.Child
            private JSInteropExecuteNode executeNode__callNode_;
            @Node.Child
            private ExportValueNode executeNode__exportNode_;
            @Node.Child
            private UnwrapPromiseNode executeNode__unwrapPromise_;

            Cached(Object originalReceiver) {
                InteropAsyncFunction receiver = (InteropAsyncFunction)originalReceiver;
                this.receiverFunctionInteropLibrary_ = (InteropLibrary)super.insert(INTEROP_LIBRARY_.create(receiver.function));
            }

            @Override
            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            @Override
            public Object readDelegateExport(Object receiver_) {
                return ((InteropAsyncFunction)receiver_).function;
            }

            @Override
            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverFunctionInteropLibrary_;
            }

            @Override
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof InteropAsyncFunction) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof InteropAsyncFunction)) {
                    return false;
                }
                return this.receiverFunctionInteropLibrary_.accepts(((InteropAsyncFunction)receiver).function);
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert (receiver instanceof InteropAsyncFunction) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((InteropAsyncFunction)receiver).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (arg0Value_ instanceof InteropAsyncFunction) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                InteropAsyncFunction arg0Value = (InteropAsyncFunction)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage executeNode__language__ = javaScriptLanguageReference__.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    JSRealm executeNode__realm__ = javaScriptLanguageContextReference__.get();
                    return arg0Value.execute(arg1Value, executeNode__language__, executeNode__realm__, this.executeNode__callNode_, this.executeNode__exportNode_, this.executeNode__unwrapPromise_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeNode_AndSpecialize(InteropAsyncFunction arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    JSRealm executeNode__realm__ = null;
                    JavaScriptLanguage executeNode__language__ = null;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    executeNode__language__ = javaScriptLanguageReference__1.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    executeNode__realm__ = javaScriptLanguageContextReference__1.get();
                    this.executeNode__callNode_ = super.insert(JSInteropExecuteNodeGen.create());
                    this.executeNode__exportNode_ = super.insert(ExportValueNode.create());
                    this.executeNode__unwrapPromise_ = super.insert(UnwrapPromiseNode.create(executeNode__realm__.getContext()));
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.execute(arg1Value, executeNode__language__, executeNode__realm__, this.executeNode__callNode_, this.executeNode__exportNode_, this.executeNode__unwrapPromise_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }
}

