/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.ShapeListener;
import com.oracle.truffle.api.utilities.NeverValidAssumption;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.util.DebugCounter;
import org.graalvm.collections.EconomicMap;

public final class JSSharedData
implements ShapeListener {
    private final JSContext context;
    private final Property prototypeProperty;
    private EconomicMap<Object, Assumption> propertyAssumptions;
    private Assumption prototypeAssumption;
    private static final DebugCounter propertyAssumptionsCreated = DebugCounter.create("Property assumptions created");
    private static final DebugCounter propertyAssumptionsRemoved = DebugCounter.create("Property assumptions removed");
    private static final DebugCounter prototypeAssumptionsCreated = DebugCounter.create("Prototype assumptions created");
    private static final DebugCounter prototypeAssumptionsRemoved = DebugCounter.create("Prototype assumptions removed");

    public JSSharedData(JSContext context, Property prototypeProperty) {
        this.context = context;
        this.prototypeProperty = prototypeProperty;
    }

    synchronized Assumption getPropertyAssumption(Object propertyName) {
        Assumption assumption;
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap<Object, Assumption> map = this.propertyAssumptions;
        if (map == null) {
            map = EconomicMap.create();
            this.propertyAssumptions = map;
        } else {
            assumption = (Assumption)map.get(propertyName);
            if (assumption != null) {
                return assumption;
            }
        }
        assumption = Truffle.getRuntime().createAssumption(propertyName.toString());
        map.put(propertyName, assumption);
        propertyAssumptionsCreated.inc();
        return assumption;
    }

    synchronized void invalidatePropertyAssumption(Object propertyName) {
        Assumption assumption;
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap<Object, Assumption> map = this.propertyAssumptions;
        if (map != null && (assumption = (Assumption)map.get(propertyName)) != null && assumption != NeverValidAssumption.INSTANCE) {
            assumption.invalidate("invalidatePropertyAssumption");
            map.put(propertyName, NeverValidAssumption.INSTANCE);
            propertyAssumptionsRemoved.inc();
        }
    }

    JSContext getContext() {
        return this.context;
    }

    Property getPrototypeProperty() {
        return this.prototypeProperty;
    }

    synchronized Assumption getPrototypeAssumption() {
        Assumption assumption = this.prototypeAssumption;
        if (assumption == null) {
            this.prototypeAssumption = assumption = Truffle.getRuntime().createAssumption("stable prototype");
            prototypeAssumptionsCreated.inc();
        }
        return assumption;
    }

    synchronized void invalidatePrototypeAssumption() {
        Assumption assumption = this.prototypeAssumption;
        if (assumption != null) {
            assumption.invalidate();
            this.prototypeAssumption = NeverValidAssumption.INSTANCE;
            prototypeAssumptionsRemoved.inc();
        }
    }

    @Override
    public void onPropertyTransition(Object key) {
        this.invalidatePropertyAssumption(key);
    }
}

