/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java.adapter;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.js.runtime.java.adapter.JavaAdapterFactory;
import java.util.Objects;
import org.graalvm.collections.Pair;

@ExportLibrary(value=InteropLibrary.class)
public final class JavaSuperAdapter
implements TruffleObject {
    final Object adapter;

    JavaSuperAdapter(Object adapter) {
        this.adapter = Objects.requireNonNull(adapter);
        assert (!(adapter instanceof JavaSuperAdapter));
    }

    public Object getAdapter() {
        return this.adapter;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object readMember(String name, @Cached.Shared(value="cache") @Cached NameCache cache, @CachedLibrary(value="this.adapter") InteropLibrary interop) throws UnsupportedMessageException, UnknownIdentifierException {
        String superMethodName = cache.getSuperMethodName(name);
        return interop.readMember(this.getAdapter(), superMethodName);
    }

    @ExportMessage
    Object invokeMember(String name, Object[] args, @Cached.Shared(value="cache") @Cached NameCache cache, @CachedLibrary(value="this.adapter") InteropLibrary interop) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
        String superMethodName = cache.getSuperMethodName(name);
        return interop.invokeMember(this.getAdapter(), superMethodName, args);
    }

    @ExportMessage
    boolean isMemberReadable(String name, @Cached.Shared(value="cache") @Cached NameCache cache, @CachedLibrary(value="this.adapter") InteropLibrary interop) {
        String superMethodName = cache.getSuperMethodName(name);
        return interop.isMemberReadable(this.getAdapter(), superMethodName);
    }

    @ExportMessage
    boolean isMemberInvocable(String name, @Cached.Shared(value="cache") @Cached NameCache cache, @CachedLibrary(value="this.adapter") InteropLibrary interop) {
        String superMethodName = cache.getSuperMethodName(name);
        return interop.isMemberInvocable(this.getAdapter(), superMethodName);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    static final class NameCache {
        @CompilerDirectives.CompilationFinal
        private Pair<String, String> cachedNameToSuper;
        private static final NameCache UNCACHED = new NameCache(true);

        NameCache() {
        }

        NameCache(boolean uncached) {
            if (uncached) {
                this.cachedNameToSuper = Pair.empty();
            }
        }

        String getSuperMethodName(String name) {
            String cachedName;
            if (this.cachedNameToSuper == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedNameToSuper = Pair.create(name, JavaAdapterFactory.getSuperMethodName(name));
            }
            if ((cachedName = this.cachedNameToSuper.getLeft()) != null) {
                if (cachedName.equals(name)) {
                    return this.cachedNameToSuper.getRight();
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedNameToSuper = Pair.empty();
                return JavaAdapterFactory.getSuperMethodName(name);
            }
            return JavaAdapterFactory.getSuperMethodName(name);
        }

        static NameCache create() {
            return new NameCache();
        }

        static NameCache getUncached() {
            return UNCACHED;
        }
    }
}

