/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java.adapter;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.java.adapter.JavaAdapterBytecodeGenerator;
import com.oracle.truffle.js.runtime.java.adapter.JavaAdapterClassLoader;
import com.oracle.truffle.js.runtime.java.adapter.JavaSuperAdapter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public final class JavaAdapterFactory {
    @CompilerDirectives.TruffleBoundary
    public static Class<?> getAdapterClassFor(Class<?>[] types, DynamicObject classOverrides) {
        return JavaAdapterFactory.getAdapterClassFor(types, classOverrides, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static Class<?> getAdapterClassFor(Class<?>[] types, DynamicObject classOverrides, ClassLoader classLoader) {
        assert (types.length > 0);
        assert (classOverrides == null || JSRuntime.isObject(classOverrides));
        if (types.length == 1) {
            return JavaAdapterFactory.getAdapterClassFor(types[0], classOverrides, classLoader);
        }
        Class superClass = null;
        ArrayList interfaces = new ArrayList();
        for (Class<?> t : types) {
            int mod = t.getModifiers();
            if (!t.isInterface()) {
                if (superClass != null) {
                    JavaAdapterFactory.throwCannotExtendMultipleClassesError(superClass, t);
                } else {
                    if (Modifier.isFinal(mod)) {
                        throw Errors.createTypeErrorFormat("Can not extend final class %s.", t.getCanonicalName());
                    }
                    superClass = t;
                }
            } else {
                if (interfaces.size() >= 65535) {
                    throw new IllegalArgumentException("interface limit exceeded");
                }
                interfaces.add(t);
            }
            if (Modifier.isPublic(mod)) continue;
            throw Errors.createTypeErrorFormat("Class not public: %s.", t.getCanonicalName());
        }
        superClass = superClass != null ? superClass : Object.class;
        ClassLoader commonLoader = classLoader != null ? classLoader : JavaAdapterFactory.getCommonClassLoader(types);
        return JavaAdapterFactory.getAdapterClassForCommon(superClass, interfaces, classOverrides, commonLoader);
    }

    @CompilerDirectives.TruffleBoundary
    public static Class<?> getAdapterClassFor(Class<?> type) {
        return JavaAdapterFactory.getAdapterClassFor(type, null, null);
    }

    public static Class<?> getAdapterClassFor(Class<?> type, DynamicObject classOverrides, ClassLoader classLoader) {
        boolean isInterface = Modifier.isInterface(type.getModifiers());
        Class<Object> superClass = !isInterface ? type : Object.class;
        List<Class<?>> interfaces = !isInterface ? Collections.emptyList() : Collections.singletonList(type);
        ClassLoader commonLoader = classLoader != null ? classLoader : type.getClassLoader();
        return JavaAdapterFactory.getAdapterClassForCommon(superClass, interfaces, classOverrides, commonLoader);
    }

    private static Class<?> getAdapterClassForCommon(Class<?> superClass, List<Class<?>> interfaces, DynamicObject classOverrides, ClassLoader commonLoader) {
        boolean classOverride = classOverrides != null && JSRuntime.isObject(classOverrides);
        JavaAdapterBytecodeGenerator bytecodeGenerator = new JavaAdapterBytecodeGenerator(superClass, interfaces, commonLoader, classOverride);
        JavaAdapterClassLoader generatedClassLoader = bytecodeGenerator.createAdapterClassLoader();
        Value classOverridesValue = classOverride ? Context.getCurrent().asValue(classOverrides) : null;
        return generatedClassLoader.generateClass(commonLoader, classOverridesValue);
    }

    @CompilerDirectives.TruffleBoundary
    private static void throwCannotExtendMultipleClassesError(Class<?> superClass, Class<?> t) {
        throw Errors.createTypeErrorFormat("Can not extend multiple classes %s and %s. At most one of the specified types can be a class, the rest must all be interfaces.", t.getCanonicalName(), superClass.getCanonicalName());
    }

    public static Object getSuperAdapter(Object adapter) {
        if (adapter instanceof JavaSuperAdapter) {
            throw new IllegalArgumentException();
        }
        return new JavaSuperAdapter(adapter);
    }

    @CompilerDirectives.TruffleBoundary
    public static String getSuperMethodName(String methodName) {
        assert (!methodName.startsWith("super$"));
        return "super$" + methodName;
    }

    private static boolean classLoaderCanSee(ClassLoader loader, Class<?> clazz) {
        if (clazz.getClassLoader() == loader) {
            return true;
        }
        try {
            return Class.forName(clazz.getName(), false, loader) == clazz;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean classLoaderCanSee(ClassLoader loader, Class<?>[] classes) {
        for (Class<?> c : classes) {
            if (JavaAdapterFactory.classLoaderCanSee(loader, c)) continue;
            return false;
        }
        return true;
    }

    private static ClassLoader getCommonClassLoader(Class<?>[] types) {
        HashMap<ClassLoader, Boolean> distinctLoaders = new HashMap<ClassLoader, Boolean>();
        for (Class<?> type : types) {
            ClassLoader loader = type.getClassLoader();
            if (!distinctLoaders.computeIfAbsent(loader, cl -> JavaAdapterFactory.classLoaderCanSee(cl, types)).booleanValue()) continue;
            return loader;
        }
        throw Errors.createTypeErrorFormat("Could not determine a class loader that can see all types: %s", Arrays.toString(types));
    }
}

