/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.SymbolFunctionBuiltins;
import com.oracle.truffle.js.builtins.SymbolPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.EnumSet;

public final class JSSymbol
extends JSBuiltinObject
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final JSSymbol INSTANCE = new JSSymbol();
    public static final String TYPE_NAME = "symbol";
    public static final String CLASS_NAME = "Symbol";
    public static final String PROTOTYPE_NAME = "Symbol.prototype";
    public static final String DESCRIPTION = "description";
    private static final HiddenKey SYMBOL_DATA_ID = new HiddenKey("Symbol");
    private static final Property SYMBOL_DATA_PROPERTY;

    private JSSymbol() {
    }

    public static DynamicObject create(JSContext context, Symbol symbol) {
        DynamicObject mapObj = JSObject.create(context, context.getSymbolFactory(), symbol);
        assert (JSSymbol.isJSSymbol(mapObj));
        return mapObj;
    }

    public static Symbol getSymbolData(DynamicObject symbolWrapper) {
        assert (JSSymbol.isJSSymbol(symbolWrapper));
        return (Symbol)SYMBOL_DATA_PROPERTY.get(symbolWrapper, JSSymbol.isJSSymbol(symbolWrapper));
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, SymbolPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        if (ctx.getContextOptions().getEcmaScriptVersion() >= 10) {
            JSObjectUtil.putConstantAccessorProperty(ctx, prototype, DESCRIPTION, JSSymbol.createDescriptionGetterFunction(realm), Undefined.instance);
        }
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.addProperty(SYMBOL_DATA_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, SymbolFunctionBuiltins.BUILTINS);
    }

    private static DynamicObject createDescriptionGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.SymbolGetDescription, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){
                private final ConditionProfile isSymbolProfile = ConditionProfile.createBinaryProfile();
                private final ConditionProfile isJSSymbolProfile = ConditionProfile.createBinaryProfile();

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (this.isSymbolProfile.profile(obj instanceof Symbol)) {
                        return ((Symbol)obj).getDescription();
                    }
                    if (this.isJSSymbolProfile.profile(JSSymbol.isJSSymbol(obj))) {
                        return JSSymbol.getSymbolData((DynamicObject)obj).getDescription();
                    }
                    throw Errors.createTypeErrorSymbolExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get description");
        });
        return JSFunction.create(realm, getterData);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        return "[Symbol]";
    }

    public static boolean isJSSymbol(Object obj) {
        return JSObject.isDynamicObject(obj) && JSSymbol.isJSSymbol((DynamicObject)obj);
    }

    public static boolean isJSSymbol(DynamicObject obj) {
        return JSSymbol.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getSymbolPrototype();
    }

    static {
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        SYMBOL_DATA_PROPERTY = JSObjectUtil.makeHiddenProperty(SYMBOL_DATA_ID, allocator.locationForType(Symbol.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
    }
}

