/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.StringFunctionBuiltins;
import com.oracle.truffle.js.builtins.StringPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSPrimitiveObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.util.IteratorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public final class JSString
extends JSPrimitiveObject
implements JSConstructorFactory.WithFunctions {
    public static final JSString INSTANCE = new JSString();
    public static final String TYPE_NAME = "string";
    public static final String CLASS_NAME = "String";
    public static final String PROTOTYPE_NAME = "String.prototype";
    public static final String CLASS_NAME_EXTENSIONS = "StringExtensions";
    public static final String LENGTH = "length";
    private static final HiddenKey STRING_ID = new HiddenKey("string");
    private static final Property STRING_PROPERTY;
    private static final Property LENGTH_PROPERTY;
    public static final String ITERATOR_CLASS_NAME = "String Iterator";
    public static final String ITERATOR_PROTOTYPE_NAME = "String Iterator.prototype";
    public static final HiddenKey ITERATED_STRING_ID;
    public static final HiddenKey STRING_ITERATOR_NEXT_INDEX_ID;
    public static final String REGEXP_ITERATOR_CLASS_NAME = "RegExp String Iterator";
    public static final String REGEXP_ITERATOR_PROTOTYPE_NAME = "RegExp String Iterator.prototype";
    public static final HiddenKey REGEXP_ITERATOR_ITERATING_REGEXP_ID;
    public static final HiddenKey REGEXP_ITERATOR_ITERATED_STRING_ID;
    public static final HiddenKey REGEXP_ITERATOR_GLOBAL_ID;
    public static final HiddenKey REGEXP_ITERATOR_UNICODE_ID;
    public static final HiddenKey REGEXP_ITERATOR_DONE_ID;

    private JSString() {
    }

    public static DynamicObject create(JSContext context, CharSequence value) {
        DynamicObject stringObj = JSObject.create(context, context.getStringFactory(), value);
        assert (JSString.isJSString(stringObj));
        return stringObj;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        if (super.hasOwnProperty(thisObj, key)) {
            return true;
        }
        long index = JSRuntime.propertyKeyToArrayIndex(key);
        return index >= 0L && index < (long)JSString.getStringLength(thisObj);
    }

    public static CharSequence getCharSequence(DynamicObject obj) {
        assert (JSString.isJSString(obj));
        return (CharSequence)STRING_PROPERTY.get(obj, JSString.isJSString(obj));
    }

    public static String getString(DynamicObject obj) {
        assert (JSString.isJSString(obj));
        return Boundaries.stringValueOf(STRING_PROPERTY.get(obj, JSString.isJSString(obj)));
    }

    @CompilerDirectives.TruffleBoundary
    public static int getStringLength(DynamicObject obj) {
        assert (JSString.isJSString(obj));
        return JSString.getCharSequence(obj).length();
    }

    @Override
    public boolean hasOwnProperty(DynamicObject thisObj, long index) {
        if (index >= 0L && index < (long)JSString.getStringLength(thisObj)) {
            return true;
        }
        return super.hasOwnProperty(thisObj, Boundaries.stringValueOf(index));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object key) {
        long value = JSRuntime.propertyKeyToArrayIndex(key);
        if (0L <= value && value < (long)JSString.getStringLength(store)) {
            return String.valueOf(JSString.getCharSequence(store).charAt((int)value));
        }
        return super.getOwnHelper(store, thisObj, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, long index) {
        if (0L <= index && index < (long)JSString.getStringLength(store)) {
            return String.valueOf(JSString.getCharSequence(store).charAt((int)index));
        }
        return super.getOwnHelper(store, thisObj, Boundaries.stringValueOf(index));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        if (receiver != thisObj) {
            return JSString.ordinarySetWithReceiver(thisObj, key, value, receiver, isStrict);
        }
        long index = JSRuntime.propertyKeyToArrayIndex(key);
        if (index >= 0L && index < (long)JSString.getStringLength(thisObj)) {
            if (isStrict) {
                throw Errors.createTypeErrorNotWritableProperty(Boundaries.stringValueOf(index), thisObj);
            }
            return true;
        }
        return super.set(thisObj, key, value, receiver, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        if (receiver != thisObj) {
            return JSString.ordinarySetWithReceiver(thisObj, Boundaries.stringValueOf(index), value, receiver, isStrict);
        }
        if (index < (long)JSString.getStringLength(thisObj)) {
            if (isStrict) {
                throw Errors.createTypeErrorNotWritableProperty(Boundaries.stringValueOf(index), thisObj);
            }
            return true;
        }
        return super.set(thisObj, index, value, receiver, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        int len = JSString.getStringLength(thisObj);
        List<Object> indices = strings ? ScriptArray.makeRangeList(0L, len) : Collections.emptyList();
        List<Object> keyList = thisObj.getShape().getKeyList();
        if (keyList.isEmpty()) {
            return indices;
        }
        ArrayList list = new ArrayList(keyList.size());
        if (strings) {
            keyList.forEach(k -> {
                if (k instanceof String && JSRuntime.isArrayIndex((String)k)) {
                    assert (JSRuntime.propertyKeyToArrayIndex(k) >= (long)len);
                    list.add(k);
                }
            });
            Collections.sort(list, JSRuntime::comparePropertyKeys);
            keyList.forEach(k -> {
                if (k instanceof String && !JSRuntime.isArrayIndex((String)k)) {
                    list.add(k);
                }
            });
        }
        if (symbols) {
            keyList.forEach(k -> {
                if (k instanceof Symbol) {
                    list.add(k);
                }
            });
        }
        return IteratorUtil.concatLists(indices, list);
    }

    @Override
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        long idx = JSRuntime.propertyKeyToArrayIndex(key);
        if (JSRuntime.isArrayIndex(idx) && 0L <= idx && idx < (long)JSString.getStringLength(thisObj)) {
            if (isStrict) {
                throw Errors.createTypeError("cannot delete index");
            }
            return false;
        }
        return JSString.deletePropertyDefault(thisObj, key, isStrict);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)INSTANCE);
        JSObjectUtil.putHiddenProperty(prototype, STRING_PROPERTY, "");
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putDataProperty(ctx, prototype, LENGTH, 0, JSAttributes.notConfigurableNotEnumerableNotWritable());
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, StringPrototypeBuiltins.BUILTINS);
        if (ctx.isOptionNashornCompatibilityMode() || ctx.getParserOptions().getEcmaScriptVersion() >= 10) {
            JSObjectUtil.putFunctionsFromContainer(realm, prototype, StringPrototypeBuiltins.EXTENSION_BUILTINS);
        }
        if (ctx.isOptionAnnexB()) {
            Object trimStart = JSObject.get(prototype, (Object)"trimStart");
            Object trimEnd = JSObject.get(prototype, (Object)"trimEnd");
            JSObjectUtil.putDataProperty(ctx, prototype, "trimLeft", trimStart, JSAttributes.configurableNotEnumerableWritable());
            JSObjectUtil.putDataProperty(ctx, prototype, "trimRight", trimEnd, JSAttributes.configurableNotEnumerableWritable());
        }
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.addProperty(STRING_PROPERTY);
        initialShape = initialShape.addProperty(LENGTH_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, StringFunctionBuiltins.BUILTINS);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        if (context.isOptionNashornCompatibilityMode()) {
            return "[String " + JSString.getCharSequence(obj) + "]";
        }
        String primitiveValue = JSString.getString(obj);
        return JSRuntime.objectToConsoleString(obj, this.getBuiltinToStringTag(obj), depth, new String[]{"PrimitiveValue"}, new Object[]{primitiveValue});
    }

    public static boolean isJSString(Object obj) {
        return JSObject.isDynamicObject(obj) && JSString.isJSString((DynamicObject)obj);
    }

    public static boolean isJSString(DynamicObject obj) {
        return JSString.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        PropertyDescriptor desc = JSString.ordinaryGetOwnProperty(thisObj, key);
        if (desc == null) {
            return JSString.stringGetIndexProperty(thisObj, key);
        }
        return desc;
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }

    @Override
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        assert (JSRuntime.isPropertyKey(key)) : key.getClass().getName();
        long idx = JSRuntime.propertyKeyToArrayIndex(key);
        if (idx >= 0L && idx < (long)JSString.getStringLength(thisObj)) {
            if (doThrow) {
                throw JSString.createTypeErrorCannotRedefineStringIndex(key);
            }
            return false;
        }
        return super.defineOwnProperty(thisObj, key, desc, doThrow);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException createTypeErrorCannotRedefineStringIndex(Object key) {
        return Errors.createTypeError("Cannot redefine property: " + key);
    }

    @CompilerDirectives.TruffleBoundary
    public static PropertyDescriptor stringGetIndexProperty(DynamicObject thisObj, Object key) {
        assert (JSString.isJSString(thisObj));
        long index = JSRuntime.propertyKeyToArrayIndex(key);
        if (index < 0L) {
            return null;
        }
        String s = JSString.getString(thisObj);
        int len = s.length();
        if ((long)len <= index) {
            return null;
        }
        String resultStr = s.substring((int)index, (int)index + 1);
        return PropertyDescriptor.createData(resultStr, true, false, false);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getStringPrototype();
    }

    static {
        ITERATED_STRING_ID = new HiddenKey("IteratedString");
        STRING_ITERATOR_NEXT_INDEX_ID = new HiddenKey("StringIteratorNextIndex");
        REGEXP_ITERATOR_ITERATING_REGEXP_ID = new HiddenKey("IteratingRegExp");
        REGEXP_ITERATOR_ITERATED_STRING_ID = new HiddenKey("IteratedString");
        REGEXP_ITERATOR_GLOBAL_ID = new HiddenKey("Global");
        REGEXP_ITERATOR_UNICODE_ID = new HiddenKey("Unicode");
        REGEXP_ITERATOR_DONE_ID = new HiddenKey("Done");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        STRING_PROPERTY = JSObjectUtil.makeHiddenProperty(STRING_ID, allocator.locationForType(CharSequence.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        LENGTH_PROPERTY = JSObjectUtil.makeProxyProperty(LENGTH, new StringLengthProxyProperty(), JSAttributes.notConfigurableNotEnumerableNotWritable());
    }

    public static final class StringLengthProxyProperty
    implements PropertyProxy {
        @Override
        public Object get(DynamicObject store) {
            return JSString.getStringLength(store);
        }
    }
}

