/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.SharedArrayBufferFunctionBuiltins;
import com.oracle.truffle.js.builtins.SharedArrayBufferPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSAbstractBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DirectByteBufferHelper;
import java.nio.ByteBuffer;

public final class JSSharedArrayBuffer
extends JSAbstractBuffer
implements JSConstructorFactory.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final String CLASS_NAME = "SharedArrayBuffer";
    public static final String PROTOTYPE_NAME = "SharedArrayBuffer.prototype";
    public static final JSSharedArrayBuffer INSTANCE = new JSSharedArrayBuffer();
    protected static final Property BUFFER_WAIT_LIST;
    protected static final HiddenKey BUFFER_WAIT_LIST_ID;

    private JSSharedArrayBuffer() {
    }

    public static DynamicObject createSharedArrayBuffer(JSContext context, int length) {
        return JSSharedArrayBuffer.createSharedArrayBuffer(context, DirectByteBufferHelper.allocateDirect(length));
    }

    public static DynamicObject createSharedArrayBuffer(JSContext context, ByteBuffer buffer) {
        assert (buffer != null);
        DynamicObject obj = JSObject.create(context, context.getSharedArrayBufferFactory(), buffer, new JSAgentWaiterList());
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer(obj));
        return obj;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext context = realm.getContext();
        DynamicObject arrayBufferPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(context, arrayBufferPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, arrayBufferPrototype, SharedArrayBufferPrototypeBuiltins.BUILTINS);
        JSFunctionData fd = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.SharedArrayBufferGetByteLength, c -> JSFunctionData.createCallOnly(context, JSSharedArrayBuffer.createByteLengthGetterCallTarget(context), 0, "get byteLength"));
        DynamicObject byteLengthGetter = JSFunction.create(realm, fd);
        JSObjectUtil.putDataProperty(context, arrayBufferPrototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putConstantAccessorProperty(context, arrayBufferPrototype, "byteLength", byteLengthGetter, Undefined.instance);
        return arrayBufferPrototype;
    }

    private static CallTarget createByteLengthGetterCallTarget(JSContext context) {
        return Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(context.getLanguage(), null, null){

            @Override
            public Object execute(VirtualFrame frame) {
                Object obj = JSArguments.getThisObject(frame.getArguments());
                if (JSSharedArrayBuffer.isJSSharedArrayBuffer(obj)) {
                    return JSArrayBuffer.getDirectByteLength((DynamicObject)obj);
                }
                throw Errors.createTypeErrorIncompatibleReceiver(obj);
            }
        });
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.addProperty(BYTE_BUFFER_PROPERTY);
        initialShape = initialShape.addProperty(BUFFER_WAIT_LIST);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, SharedArrayBufferFunctionBuiltins.BUILTINS);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    public static boolean isJSSharedArrayBuffer(Object obj) {
        return JSObject.isDynamicObject(obj) && JSSharedArrayBuffer.isJSSharedArrayBuffer((DynamicObject)obj);
    }

    public static boolean isJSSharedArrayBuffer(DynamicObject obj) {
        return JSSharedArrayBuffer.isInstance(obj, (JSClass)INSTANCE);
    }

    public static ByteBuffer getDirectByteBuffer(DynamicObject thisObj) {
        return JSSharedArrayBuffer.getDirectByteBuffer(thisObj, JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
    }

    public static ByteBuffer getDirectByteBuffer(DynamicObject thisObj, boolean condition) {
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
        return DirectByteBufferHelper.cast((ByteBuffer)BYTE_BUFFER_PROPERTY.get(thisObj, condition));
    }

    public static JSAgentWaiterList getWaiterList(DynamicObject thisObj) {
        return (JSAgentWaiterList)BUFFER_WAIT_LIST.get(thisObj, JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
    }

    public static JSAgentWaiterList getWaiterList(DynamicObject thisObj, boolean condition) {
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
        return (JSAgentWaiterList)BUFFER_WAIT_LIST.get(thisObj, condition);
    }

    public static void setWaiterList(DynamicObject thisObj, JSAgentWaiterList wl) {
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
        BUFFER_WAIT_LIST.setSafe(thisObj, wl, null);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getSharedArrayBufferPrototype();
    }

    static {
        BUFFER_WAIT_LIST_ID = new HiddenKey("waitList");
        BUFFER_WAIT_LIST = JSObjectUtil.makeHiddenProperty(BUFFER_WAIT_LIST_ID, allocator.locationForType(JSAgentWaiterList.class));
    }
}

