/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.PromiseFunctionBuiltins;
import com.oracle.truffle.js.builtins.PromisePrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSPromise
extends JSBuiltinObject
implements JSConstructorFactory.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final String CLASS_NAME = "Promise";
    public static final String PROTOTYPE_NAME = "Promise.prototype";
    public static final JSPromise INSTANCE = new JSPromise();
    public static final String RESOLVE = "resolve";
    public static final String THEN = "then";
    public static final HiddenKey PROMISE_STATE = new HiddenKey("PromiseState");
    public static final HiddenKey PROMISE_RESULT = new HiddenKey("PromiseResult");
    public static final HiddenKey PROMISE_IS_HANDLED = new HiddenKey("PromiseIsHandled");
    public static final HiddenKey PROMISE_FULFILL_REACTIONS = new HiddenKey("PromiseFulfillReactions");
    public static final HiddenKey PROMISE_REJECT_REACTIONS = new HiddenKey("PromiseRejectReactions");
    public static final HiddenKey PROMISE_ON_FINALLY = new HiddenKey("OnFinally");
    public static final HiddenKey PROMISE_FINALLY_CONSTRUCTOR = new HiddenKey("Constructor");
    public static final int PENDING = 0;
    public static final int FULFILLED = 1;
    public static final int REJECTED = 2;
    public static final int REJECTION_TRACKER_OPERATION_REJECT = 0;
    public static final int REJECTION_TRACKER_OPERATION_HANDLE = 1;
    public static final int REJECTION_TRACKER_OPERATION_REJECT_AFTER_RESOLVED = 2;
    public static final int REJECTION_TRACKER_OPERATION_RESOLVE_AFTER_RESOLVED = 3;

    private JSPromise() {
    }

    public static DynamicObject create(JSContext context) {
        return JSObject.create(context, context.getPromiseFactory(), new Object[0]);
    }

    public static DynamicObject createWithPrototypeInObject(DynamicObject prototype, JSContext context) {
        assert (prototype == Null.instance || JSRuntime.isObject(prototype));
        Shape shape = context.getPromiseShapePrototypeInObject();
        DynamicObject obj = JSObject.create(context, shape);
        JSObject.PROTO_PROPERTY.setSafe(obj, prototype, shape);
        return obj;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    public static boolean isJSPromise(Object obj) {
        return JSObject.isDynamicObject(obj) && JSPromise.isJSPromise((DynamicObject)obj);
    }

    public static boolean isJSPromise(DynamicObject obj) {
        return JSPromise.isInstance(obj, (JSClass)INSTANCE);
    }

    public static boolean isRejected(DynamicObject promise) {
        assert (JSPromise.isJSPromise(promise));
        return 2 == (Integer)promise.get(PROMISE_STATE, 0);
    }

    public static boolean isPending(DynamicObject promise) {
        assert (JSPromise.isJSPromise(promise));
        return 0 == (Integer)promise.get(PROMISE_STATE, 0);
    }

    public static boolean isFulfilled(DynamicObject promise) {
        assert (JSPromise.isJSPromise(promise));
        return 1 == (Integer)promise.get(PROMISE_STATE, 0);
    }

    @Override
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        return JSRuntime.objectToConsoleString(obj, CLASS_NAME, depth, new String[]{"PromiseStatus", "PromiseValue"}, new Object[]{JSPromise.getStatus(obj), JSPromise.getValue(obj)});
    }

    private static String getStatus(DynamicObject obj) {
        if (JSPromise.isFulfilled(obj)) {
            return "resolved";
        }
        if (JSPromise.isRejected(obj)) {
            return "rejected";
        }
        assert (JSPromise.isPending(obj) || !obj.containsKey(PROMISE_STATE));
        return "pending";
    }

    private static Object getValue(DynamicObject obj) {
        Object result = obj.get(PROMISE_RESULT);
        return result == null ? Undefined.instance : result;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext context = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(context, prototype, constructor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, PromisePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(context, prototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, PromiseFunctionBuiltins.BUILTINS);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getPromisePrototype();
    }
}

