/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.ibm.icu.text.DisplayContext;
import com.ibm.icu.text.LocaleDisplayNames;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.intl.DisplayNamesFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.DisplayNamesPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.EnumSet;
import java.util.Locale;

public final class JSDisplayNames
extends JSBuiltinObject
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "DisplayNames";
    public static final String PROTOTYPE_NAME = "DisplayNames.prototype";
    private static final HiddenKey INTERNAL_STATE_ID = new HiddenKey("_internalState");
    private static final Property INTERNAL_STATE_PROPERTY;
    public static final JSDisplayNames INSTANCE;

    private JSDisplayNames() {
    }

    public static boolean isJSDisplayNames(Object obj) {
        return JSObject.isDynamicObject(obj) && JSDisplayNames.isJSDisplayNames((DynamicObject)obj);
    }

    public static boolean isJSDisplayNames(DynamicObject obj) {
        return JSDisplayNames.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject displayNamesPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, displayNamesPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, displayNamesPrototype, DisplayNamesPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(ctx, displayNamesPrototype, Symbol.SYMBOL_TO_STRING_TAG, "Intl.DisplayNames", JSAttributes.configurableNotEnumerableNotWritable());
        return displayNamesPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        initialShape = initialShape.addProperty(INTERNAL_STATE_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, DisplayNamesFunctionBuiltins.BUILTINS);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        DynamicObject result = JSObject.create(context, context.getDisplayNamesFactory(), state);
        assert (JSDisplayNames.isJSDisplayNames(result));
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalState(JSContext ctx, InternalState state, String[] locales, String optStyle, String optType, String optFallback) {
        Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
        Locale strippedLocale = selectedLocale.stripExtensions();
        if (strippedLocale.toLanguageTag().equals("und")) {
            selectedLocale = ctx.getLocale();
            strippedLocale = selectedLocale.stripExtensions();
        }
        state.locale = strippedLocale.toLanguageTag();
        state.style = optStyle;
        state.type = optType;
        state.fallback = optFallback;
        DisplayContext fallbackCtx = JSDisplayNames.fallbackDisplayContext(optFallback);
        DisplayContext styleCtx = JSDisplayNames.styleDisplayContext(optStyle);
        state.displayNames = LocaleDisplayNames.getInstance(strippedLocale, styleCtx, fallbackCtx);
    }

    private static DisplayContext fallbackDisplayContext(String optFallback) {
        return "none".equals(optFallback) ? DisplayContext.NO_SUBSTITUTE : DisplayContext.SUBSTITUTE;
    }

    private static DisplayContext styleDisplayContext(String optStyle) {
        return "long".equals(optStyle) ? DisplayContext.LENGTH_FULL : DisplayContext.LENGTH_SHORT;
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, DynamicObject displayNamesObject) {
        InternalState state = JSDisplayNames.getInternalState(displayNamesObject);
        return state.toResolvedOptionsObject(context);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object of(DynamicObject displayNamesObject, String code) {
        String result;
        InternalState state = JSDisplayNames.getInternalState(displayNamesObject);
        String type = state.type;
        LocaleDisplayNames displayNames = state.displayNames;
        switch (type) {
            case "language": {
                IntlUtil.ensureIsStructurallyValidLanguageTag(code);
                result = displayNames.localeDisplayName(code);
                break;
            }
            case "region": {
                IntlUtil.ensureIsStructurallyValidRegionSubtag(code);
                result = displayNames.regionDisplayName(code);
                break;
            }
            case "script": {
                IntlUtil.ensureIsStructurallyValidScriptSubtag(code);
                result = displayNames.scriptDisplayName(code);
                break;
            }
            case "currency": {
                IntlUtil.ensureIsWellFormedCurrencyCode(code);
                result = displayNames.keyValueDisplayName("currency", code);
                break;
            }
            default: {
                throw Errors.shouldNotReachHere(type);
            }
        }
        return result == null ? Undefined.instance : result;
    }

    public static InternalState getInternalState(DynamicObject displayNamesObject) {
        return (InternalState)INTERNAL_STATE_PROPERTY.get(displayNamesObject, JSDisplayNames.isJSDisplayNames(displayNamesObject));
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getDisplayNamesPrototype();
    }

    static {
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        INTERNAL_STATE_PROPERTY = JSObjectUtil.makeHiddenProperty(INTERNAL_STATE_ID, allocator.locationForType(InternalState.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)));
        INSTANCE = new JSDisplayNames();
    }

    public static class InternalState {
        String locale;
        String style;
        String type;
        String fallback;
        LocaleDisplayNames displayNames;

        DynamicObject toResolvedOptionsObject(JSContext context) {
            DynamicObject result = JSUserObject.create(context);
            JSObjectUtil.defineDataProperty(result, "locale", this.locale, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "style", this.style, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "type", this.type, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "fallback", this.fallback, JSAttributes.getDefault());
            return result;
        }
    }
}

