/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNodeGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.nodes.interop.KeyInfoNodeGen;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNodeGen;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSClass.class)
final class JSClassGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private JSClassGen() {
    }

    static {
        LibraryExport.register(JSClass.class, new InteropLibraryExports());
    }

    @GeneratedBy(value=JSClass.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, DynamicObject.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof DynamicObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof DynamicObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSClass.class)
        private static final class Uncached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);
            private final TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_ = this.lookupContextReference(JavaScriptLanguage.class);

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == JSClass.class;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                if (JSGuards.isJSFastArray(arg0Value)) {
                    return JSClass.GetMembers.fastArray(arg0Value, arg1Value);
                }
                if (JSGuards.isJSArray(arg0Value) && !JSGuards.isJSFastArray(arg0Value)) {
                    return JSClass.GetMembers.slowArray(arg0Value, arg1Value);
                }
                if (JSGuards.isJSArrayBufferView(arg0Value)) {
                    return JSClass.GetMembers.typedArray(arg0Value, arg1Value);
                }
                if (JSGuards.isJSArgumentsObject(arg0Value)) {
                    return JSClass.GetMembers.argumentsObject(arg0Value, arg1Value);
                }
                if (!(JSGuards.isJSArray(arg0Value) || JSGuards.isJSArrayBufferView(arg0Value) || JSGuards.isJSArgumentsObject(arg0Value))) {
                    return JSClass.GetMembers.nonArray(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                if (JSGuards.isJSArray(arg0Value)) {
                    return JSClass.GetArraySize.array(arg0Value);
                }
                if (JSGuards.isJSArrayBufferView(arg0Value)) {
                    return JSClass.GetArraySize.typedArray(arg0Value);
                }
                if (JSGuards.isJSArgumentsObject(arg0Value)) {
                    return JSClass.GetArraySize.argumentsObject(arg0Value);
                }
                return JSClass.GetArraySize.unsupported(arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                if (arg1Value instanceof DynamicObject) {
                    DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                    return JSClass.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return JSClass.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isNull((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasMembers((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.readMember(arg0Value, arg1Value, this.javaScriptLanguageReference_, JSClass.getUncachedRead(), this.javaScriptLanguageReference_.get().bindMemberFunctions(), ExportValueNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isMemberReadable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                JSClass.writeMember(arg0Value, arg1Value, arg2Value, KeyInfoNodeGen.getUncached(), ImportValueNodeGen.getUncached(), this.javaScriptLanguageReference_, JSClass.getUncachedWrite());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isMemberModifiable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isMemberInsertable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                JSClass.removeMember((DynamicObject)receiver, member);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isMemberRemovable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasArrayElements((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.readArrayElement(arg0Value, arg1Value, this.javaScriptLanguageReference_, JSClass.getUncachedRead(), ExportValueNodeGen.getUncached(), this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isArrayElementReadable(arg0Value, arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                JSClass.writeArrayElement(arg0Value, arg1Value, arg2Value, KeyInfoNodeGen.getUncached(), ImportValueNodeGen.getUncached(), this.javaScriptLanguageReference_, JSClass.getUncachedWrite());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isArrayElementModifiable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isArrayElementInsertable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementRemovable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isArrayElementRemovable((DynamicObject)receiver, index);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                JSClass.removeArrayElement((DynamicObject)receiver, index);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.execute(arg0Value, arg1Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), JSInteropExecuteNodeGen.getUncached(), ExportValueNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isExecutable(arg0Value, IsCallableNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.instantiate(arg0Value, arg1Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), JSInteropInstantiateNodeGen.getUncached(), ExportValueNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isInstantiable((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.invokeMember(arg0Value, arg1Value, arg2Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), JSInteropInvokeNodeGen.getUncached(), ExportValueNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.isMemberInvocable(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.hasMemberReadSideEffects(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.hasMemberWriteSideEffects(arg0Value, arg1Value, KeyInfoNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isString((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asString((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isBoolean(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isBoolean((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asBoolean((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isNumber(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isNumber((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInByte(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInByte(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInShort(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInShort(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInInt(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInInt(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInLong(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInLong(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInFloat(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInFloat(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInDouble(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.fitsInDouble(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asByte(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asShort(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asInt(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asLong(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asFloat(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asDouble(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asInstant((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asDate(arg0Value, this.javaScriptLanguageContextReference_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asTime(arg0Value, this.javaScriptLanguageContextReference_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject)arg0Value_;
                return JSClass.asTimeZone(arg0Value, this.javaScriptLanguageContextReference_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasLanguage((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.getLanguage((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.toDisplayString((DynamicObject)receiver, allowSideEffects);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasSourceLocation((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.getSourceLocation((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasMetaObject((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.getMetaObject((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isMetaObject((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.getMetaObjectName((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.getMetaObjectName((DynamicObject)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isMetaInstance((DynamicObject)receiver, instance);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.identityHashCode((DynamicObject)receiver);
            }
        }

        @GeneratedBy(value=JSClass.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private volatile long state_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @Node.Child
            private KeyInfoNode keyInfo;
            @Node.Child
            private ImportValueNode importValue;
            @Node.Child
            private ExportValueNode exportValue;
            @Node.Child
            private InteropLibrary numberLib;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;
            @CompilerDirectives.CompilationFinal
            private GetMembersNonArrayCachedData getMembers_nonArrayCached_cache;
            @Node.Child
            private ReadElementNode readMemberNode__readNode_;
            @CompilerDirectives.CompilationFinal
            private boolean readMemberNode__bindMemberFunctions_;
            @Node.Child
            private ExportValueNode readMemberNode__exportNode_;
            @Node.Child
            private WriteElementNode writeMemberNode__writeNode_;
            @Node.Child
            private ReadElementNode readArrayElementNode__readNode_;
            @Node.Child
            private WriteElementNode writeArrayElementNode__writeNode_;
            @Node.Child
            private JSInteropExecuteNode executeNode__callNode_;
            @Node.Child
            private IsCallableNode isExecutableNode__isCallable_;
            @Node.Child
            private JSInteropInstantiateNode instantiateNode__callNode_;
            @Node.Child
            private JSInteropInvokeNode invokeMemberNode__callNode_;

            Cached(Object originalReceiver) {
                DynamicObject receiver = (DynamicObject)originalReceiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
            }

            @Override
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == JSClass.class;
            }

            @Override
            @ExplodeLoop
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x3FL) != 0L) {
                    if ((state & 1L) != 0L && JSGuards.isJSFastArray(arg0Value)) {
                        return JSClass.GetMembers.fastArray(arg0Value, arg1Value);
                    }
                    if ((state & 2L) != 0L && JSGuards.isJSArray(arg0Value) && !JSGuards.isJSFastArray(arg0Value)) {
                        return JSClass.GetMembers.slowArray(arg0Value, arg1Value);
                    }
                    if ((state & 4L) != 0L && JSGuards.isJSArrayBufferView(arg0Value)) {
                        return JSClass.GetMembers.typedArray(arg0Value, arg1Value);
                    }
                    if ((state & 8L) != 0L && JSGuards.isJSArgumentsObject(arg0Value)) {
                        return JSClass.GetMembers.argumentsObject(arg0Value, arg1Value);
                    }
                    if ((state & 0x10L) != 0L) {
                        GetMembersNonArrayCachedData s5_ = this.getMembers_nonArrayCached_cache;
                        while (s5_ != null) {
                            assert (s5_.cachedJSClass_ != null);
                            if (JSObject.getJSClass(arg0Value) == s5_.cachedJSClass_) {
                                return JSClass.GetMembers.nonArrayCached(arg0Value, arg1Value, s5_.cachedJSClass_);
                            }
                            s5_ = s5_.next_;
                        }
                    }
                    if (!((state & 0x20L) == 0L || JSGuards.isJSArray(arg0Value) || JSGuards.isJSArrayBufferView(arg0Value) || JSGuards.isJSArgumentsObject(arg0Value))) {
                        return JSClass.GetMembers.nonArray(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersAndSpecialize(arg0Value, arg1Value);
            }

            private Object getMembersAndSpecialize(DynamicObject arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                int exclude = this.exclude_;
                try {
                    if (JSGuards.isJSFastArray(arg0Value)) {
                        this.state_ = state |= 1L;
                        lock.unlock();
                        hasLock = false;
                        Object object = JSClass.GetMembers.fastArray(arg0Value, arg1Value);
                        return object;
                    }
                    if (JSGuards.isJSArray(arg0Value) && !JSGuards.isJSFastArray(arg0Value)) {
                        this.state_ = state |= 2L;
                        lock.unlock();
                        hasLock = false;
                        Object object = JSClass.GetMembers.slowArray(arg0Value, arg1Value);
                        return object;
                    }
                    if (JSGuards.isJSArrayBufferView(arg0Value)) {
                        this.state_ = state |= 4L;
                        lock.unlock();
                        hasLock = false;
                        Object object = JSClass.GetMembers.typedArray(arg0Value, arg1Value);
                        return object;
                    }
                    if (JSGuards.isJSArgumentsObject(arg0Value)) {
                        this.state_ = state |= 8L;
                        lock.unlock();
                        hasLock = false;
                        Object object = JSClass.GetMembers.argumentsObject(arg0Value, arg1Value);
                        return object;
                    }
                    if (exclude == 0) {
                        JSClass cachedJSClass__;
                        int count5_ = 0;
                        GetMembersNonArrayCachedData s5_ = this.getMembers_nonArrayCached_cache;
                        if ((state & 0x10L) != 0L) {
                            while (s5_ != null) {
                                assert (s5_.cachedJSClass_ != null);
                                if (JSObject.getJSClass(arg0Value) == s5_.cachedJSClass_) break;
                                s5_ = s5_.next_;
                                ++count5_;
                            }
                        }
                        if (s5_ == null && (cachedJSClass__ = JSClass.GetMembers.getNonArrayJSClass(arg0Value)) != null && JSObject.getJSClass(arg0Value) == cachedJSClass__ && count5_ < 3) {
                            s5_ = new GetMembersNonArrayCachedData(this.getMembers_nonArrayCached_cache);
                            s5_.cachedJSClass_ = cachedJSClass__;
                            this.getMembers_nonArrayCached_cache = s5_;
                            this.state_ = state |= 0x10L;
                        }
                        if (s5_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = JSClass.GetMembers.nonArrayCached(arg0Value, arg1Value, s5_.cachedJSClass_);
                            return object;
                        }
                    }
                    if (!(JSGuards.isJSArray(arg0Value) || JSGuards.isJSArrayBufferView(arg0Value) || JSGuards.isJSArgumentsObject(arg0Value))) {
                        this.exclude_ = exclude |= 1;
                        this.getMembers_nonArrayCached_cache = null;
                        state &= 0xFFFFFFFFFFFFFFEFL;
                        this.state_ = state |= 0x20L;
                        lock.unlock();
                        hasLock = false;
                        Object object = JSClass.GetMembers.nonArray(arg0Value, arg1Value);
                        return object;
                    }
                    throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                GetMembersNonArrayCachedData s5_;
                long state = this.state_;
                if ((state & 0x3FL) == 0L) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 0x3FL & (state & 0x3FL) - 1L) == 0L && ((s5_ = this.getMembers_nonArrayCached_cache) == null || s5_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x3C0L) != 0L) {
                    if ((state & 0x40L) != 0L && JSGuards.isJSArray(arg0Value)) {
                        return JSClass.GetArraySize.array(arg0Value);
                    }
                    if ((state & 0x80L) != 0L && JSGuards.isJSArrayBufferView(arg0Value)) {
                        return JSClass.GetArraySize.typedArray(arg0Value);
                    }
                    if ((state & 0x100L) != 0L && JSGuards.isJSArgumentsObject(arg0Value)) {
                        return JSClass.GetArraySize.argumentsObject(arg0Value);
                    }
                    if ((state & 0x200L) != 0L && Cached.getArraySizeFallbackGuard_(state, arg0Value)) {
                        return JSClass.GetArraySize.unsupported(arg0Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getArraySizeAndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (JSGuards.isJSArray(arg0Value)) {
                        this.state_ = state |= 0x40L;
                        lock.unlock();
                        hasLock = false;
                        long l = JSClass.GetArraySize.array(arg0Value);
                        return l;
                    }
                    if (JSGuards.isJSArrayBufferView(arg0Value)) {
                        this.state_ = state |= 0x80L;
                        lock.unlock();
                        hasLock = false;
                        long l = JSClass.GetArraySize.typedArray(arg0Value);
                        return l;
                    }
                    if (JSGuards.isJSArgumentsObject(arg0Value)) {
                        this.state_ = state |= 0x100L;
                        lock.unlock();
                        hasLock = false;
                        long l = JSClass.GetArraySize.argumentsObject(arg0Value);
                        return l;
                    }
                    this.state_ = state |= 0x200L;
                    lock.unlock();
                    hasLock = false;
                    long l = JSClass.GetArraySize.unsupported(arg0Value);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0xC00L) != 0L) {
                    if ((state & 0x400L) != 0L && arg1Value instanceof DynamicObject) {
                        DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                        return JSClass.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state & 0x800L) != 0L && Cached.isIdenticalOrUndefinedFallbackGuard_(state, arg0Value, arg1Value)) {
                        return JSClass.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private TriState isIdenticalOrUndefinedAndSpecialize(DynamicObject arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (arg1Value instanceof DynamicObject) {
                        DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                        this.state_ = state |= 0x400L;
                        lock.unlock();
                        hasLock = false;
                        TriState triState = JSClass.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                        return triState;
                    }
                    this.state_ = state |= 0x800L;
                    lock.unlock();
                    hasLock = false;
                    TriState triState = JSClass.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    return triState;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isNull((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.hasMembers((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x1000L) != 0L) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> readMemberNode__languageRef__ = javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    return JSClass.readMember(arg0Value, arg1Value, readMemberNode__languageRef__, this.readMemberNode__readNode_, this.readMemberNode__bindMemberFunctions_, this.readMemberNode__exportNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) throws UnknownIdentifierException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> readMemberNode__languageRef__ = null;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    readMemberNode__languageRef__ = javaScriptLanguageReference__1;
                    this.readMemberNode__readNode_ = super.insert(ReadElementNode.create(readMemberNode__languageRef__.get().getJSContext()));
                    this.readMemberNode__bindMemberFunctions_ = readMemberNode__languageRef__.get().bindMemberFunctions();
                    this.readMemberNode__exportNode_ = super.insert(ExportValueNode.create());
                    this.state_ = state |= 0x1000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = JSClass.readMember(arg0Value, arg1Value, readMemberNode__languageRef__, this.readMemberNode__readNode_, this.readMemberNode__bindMemberFunctions_, this.readMemberNode__exportNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x2000L) != 0L) {
                    return JSClass.isMemberReadable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x2000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isMemberReadable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x4000L) != 0L) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> writeMemberNode__languageRef__ = javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JSClass.writeMember(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, writeMemberNode__languageRef__, this.writeMemberNode__writeNode_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberNode_AndSpecialize(DynamicObject arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__1;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> writeMemberNode__languageRef__ = null;
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    if (this.importValue == null) {
                        this.importValue = super.insert(ImportValueNode.create());
                    }
                    if ((javaScriptLanguageReference__1 = this.javaScriptLanguageReference_) == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    writeMemberNode__languageRef__ = javaScriptLanguageReference__1;
                    this.writeMemberNode__writeNode_ = super.insert(WriteElementNode.createCachedInterop(writeMemberNode__languageRef__));
                    this.state_ = state |= 0x4000L;
                    lock.unlock();
                    hasLock = false;
                    JSClass.writeMember(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, writeMemberNode__languageRef__, this.writeMemberNode__writeNode_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x8000L) != 0L) {
                    return JSClass.isMemberModifiable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberModifiableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x8000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isMemberModifiable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x10000L) != 0L) {
                    return JSClass.isMemberInsertable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInsertableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x10000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isMemberInsertable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSClass.removeMember((DynamicObject)this.dynamicDispatch_.cast(receiver), member);
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x20000L) != 0L) {
                    return JSClass.isMemberRemovable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberRemovableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x20000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isMemberRemovable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.hasArrayElements((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x40000L) != 0L) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> readArrayElementNode__languageRef__ = javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    Cached readArrayElementNode__thisLibrary__ = this;
                    return JSClass.readArrayElement(arg0Value, arg1Value, readArrayElementNode__languageRef__, this.readArrayElementNode__readNode_, this.exportValue, readArrayElementNode__thisLibrary__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readArrayElementNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    Cached readArrayElementNode__thisLibrary__ = null;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> readArrayElementNode__languageRef__ = null;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    readArrayElementNode__languageRef__ = javaScriptLanguageReference__1;
                    this.readArrayElementNode__readNode_ = super.insert(ReadElementNode.create(readArrayElementNode__languageRef__.get().getJSContext()));
                    if (this.exportValue == null) {
                        this.exportValue = super.insert(ExportValueNode.create());
                    }
                    readArrayElementNode__thisLibrary__ = this;
                    this.state_ = state |= 0x40000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = JSClass.readArrayElement(arg0Value, arg1Value, readArrayElementNode__languageRef__, this.readArrayElementNode__readNode_, this.exportValue, readArrayElementNode__thisLibrary__);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                Cached isArrayElementReadableNode__thisLibrary__ = this;
                return JSClass.isArrayElementReadable(arg0Value, arg1Value, isArrayElementReadableNode__thisLibrary__);
            }

            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x80000L) != 0L) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> writeArrayElementNode__languageRef__ = javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JSClass.writeArrayElement(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, writeArrayElementNode__languageRef__, this.writeArrayElementNode__writeNode_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeArrayElementNode_AndSpecialize(DynamicObject arg0Value, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__1;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> writeArrayElementNode__languageRef__ = null;
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    if (this.importValue == null) {
                        this.importValue = super.insert(ImportValueNode.create());
                    }
                    if ((javaScriptLanguageReference__1 = this.javaScriptLanguageReference_) == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    writeArrayElementNode__languageRef__ = javaScriptLanguageReference__1;
                    this.writeArrayElementNode__writeNode_ = super.insert(WriteElementNode.createCachedInterop(writeArrayElementNode__languageRef__));
                    this.state_ = state |= 0x80000L;
                    lock.unlock();
                    hasLock = false;
                    JSClass.writeArrayElement(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, writeArrayElementNode__languageRef__, this.writeArrayElementNode__writeNode_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x100000L) != 0L) {
                    return JSClass.isArrayElementModifiable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementModifiableNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x100000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isArrayElementModifiable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x200000L) != 0L) {
                    return JSClass.isArrayElementInsertable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementInsertableNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x200000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isArrayElementInsertable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementRemovable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isArrayElementRemovable((DynamicObject)this.dynamicDispatch_.cast(receiver), index);
            }

            @Override
            public void removeArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSClass.removeArrayElement((DynamicObject)this.dynamicDispatch_.cast(receiver), index);
            }

            @Override
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x400000L) != 0L) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage executeNode__language__ = javaScriptLanguageReference__.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    JSRealm executeNode__realm__ = javaScriptLanguageContextReference__.get();
                    return JSClass.execute(arg0Value, arg1Value, executeNode__language__, executeNode__realm__, this.executeNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeNode_AndSpecialize(DynamicObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    JSRealm executeNode__realm__ = null;
                    JavaScriptLanguage executeNode__language__ = null;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    executeNode__language__ = javaScriptLanguageReference__1.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    executeNode__realm__ = javaScriptLanguageContextReference__1.get();
                    this.executeNode__callNode_ = super.insert(JSInteropExecuteNodeGen.create());
                    if (this.exportValue == null) {
                        this.exportValue = super.insert(ExportValueNode.create());
                    }
                    this.state_ = state |= 0x400000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = JSClass.execute(arg0Value, arg1Value, executeNode__language__, executeNode__realm__, this.executeNode__callNode_, this.exportValue);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x800000L) != 0L) {
                    return JSClass.isExecutable(arg0Value, this.isExecutableNode__isCallable_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isExecutableNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isExecutableNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.isExecutableNode__isCallable_ = super.insert(IsCallableNode.create());
                    this.state_ = state |= 0x800000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isExecutable(arg0Value, this.isExecutableNode__isCallable_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x1000000L) != 0L) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage instantiateNode__language__ = javaScriptLanguageReference__.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    JSRealm instantiateNode__realm__ = javaScriptLanguageContextReference__.get();
                    return JSClass.instantiate(arg0Value, arg1Value, instantiateNode__language__, instantiateNode__realm__, this.instantiateNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object instantiateNode_AndSpecialize(DynamicObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    JSRealm instantiateNode__realm__ = null;
                    JavaScriptLanguage instantiateNode__language__ = null;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    instantiateNode__language__ = javaScriptLanguageReference__1.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    instantiateNode__realm__ = javaScriptLanguageContextReference__1.get();
                    this.instantiateNode__callNode_ = super.insert(JSInteropInstantiateNodeGen.create());
                    if (this.exportValue == null) {
                        this.exportValue = super.insert(ExportValueNode.create());
                    }
                    this.state_ = state |= 0x1000000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = JSClass.instantiate(arg0Value, arg1Value, instantiateNode__language__, instantiateNode__realm__, this.instantiateNode__callNode_, this.exportValue);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isInstantiable((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x2000000L) != 0L) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage invokeMemberNode__language__ = javaScriptLanguageReference__.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    JSRealm invokeMemberNode__realm__ = javaScriptLanguageContextReference__.get();
                    return JSClass.invokeMember(arg0Value, arg1Value, arg2Value, invokeMemberNode__language__, invokeMemberNode__realm__, this.invokeMemberNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberNode_AndSpecialize(DynamicObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    JSRealm invokeMemberNode__realm__ = null;
                    JavaScriptLanguage invokeMemberNode__language__ = null;
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    invokeMemberNode__language__ = javaScriptLanguageReference__1.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    invokeMemberNode__realm__ = javaScriptLanguageContextReference__1.get();
                    this.invokeMemberNode__callNode_ = super.insert(JSInteropInvokeNode.create());
                    if (this.exportValue == null) {
                        this.exportValue = super.insert(ExportValueNode.create());
                    }
                    this.state_ = state |= 0x2000000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = JSClass.invokeMember(arg0Value, arg1Value, arg2Value, invokeMemberNode__language__, invokeMemberNode__realm__, this.invokeMemberNode__callNode_, this.exportValue);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x4000000L) != 0L) {
                    return JSClass.isMemberInvocable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInvocableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x4000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.isMemberInvocable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x8000000L) != 0L) {
                    return JSClass.hasMemberReadSideEffects(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMemberReadSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasMemberReadSideEffectsNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x8000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.hasMemberReadSideEffects(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x10000000L) != 0L) {
                    return JSClass.hasMemberWriteSideEffects(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMemberWriteSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasMemberWriteSideEffectsNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(KeyInfoNodeGen.create());
                    }
                    this.state_ = state |= 0x10000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.hasMemberWriteSideEffects(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isString((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.asString((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isBoolean(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isBoolean((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.asBoolean((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isNumber(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isNumber((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x20000000L) != 0L) {
                    return JSClass.fitsInByte(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInByteNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInByteNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x20000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInByte(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x40000000L) != 0L) {
                    return JSClass.fitsInShort(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInShortNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInShortNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x40000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInShort(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x80000000L) != 0L) {
                    return JSClass.fitsInInt(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInIntNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInIntNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x80000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInInt(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x100000000L) != 0L) {
                    return JSClass.fitsInLong(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInLongNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInLongNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x100000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInLong(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x200000000L) != 0L) {
                    return JSClass.fitsInFloat(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInFloatNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInFloatNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x200000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInFloat(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x400000000L) != 0L) {
                    return JSClass.fitsInDouble(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInDoubleNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInDoubleNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x400000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSClass.fitsInDouble(arg0Value, this.numberLib);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x800000000L) != 0L) {
                    return JSClass.asByte(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asByteNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte asByteNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x800000000L;
                    lock.unlock();
                    hasLock = false;
                    byte by = JSClass.asByte(arg0Value, this.numberLib);
                    return by;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x1000000000L) != 0L) {
                    return JSClass.asShort(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asShortNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private short asShortNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x1000000000L;
                    lock.unlock();
                    hasLock = false;
                    short s = JSClass.asShort(arg0Value, this.numberLib);
                    return s;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x2000000000L) != 0L) {
                    return JSClass.asInt(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asIntNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int asIntNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x2000000000L;
                    lock.unlock();
                    hasLock = false;
                    int n = JSClass.asInt(arg0Value, this.numberLib);
                    return n;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x4000000000L) != 0L) {
                    return JSClass.asLong(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asLongNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long asLongNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x4000000000L;
                    lock.unlock();
                    hasLock = false;
                    long l = JSClass.asLong(arg0Value, this.numberLib);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x8000000000L) != 0L) {
                    return JSClass.asFloat(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asFloatNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private float asFloatNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x8000000000L;
                    lock.unlock();
                    hasLock = false;
                    float f = JSClass.asFloat(arg0Value, this.numberLib);
                    return f;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x10000000000L) != 0L) {
                    return JSClass.asDouble(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asDoubleNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private double asDoubleNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(1));
                    }
                    this.state_ = state |= 0x10000000000L;
                    lock.unlock();
                    hasLock = false;
                    double d = JSClass.asDouble(arg0Value, this.numberLib);
                    return d;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isDate((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isDate((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isDate((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.asInstant((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x20000000000L) != 0L) {
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__;
                    TruffleLanguage.ContextReference<JSRealm> asDateNode__contextRef__ = javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    return JSClass.asDate(arg0Value, asDateNode__contextRef__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asDateNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LocalDate asDateNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.ContextReference<JSRealm> asDateNode__contextRef__ = null;
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    asDateNode__contextRef__ = javaScriptLanguageContextReference__1;
                    this.state_ = state |= 0x20000000000L;
                    lock.unlock();
                    hasLock = false;
                    LocalDate localDate = JSClass.asDate(arg0Value, asDateNode__contextRef__);
                    return localDate;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x40000000000L) != 0L) {
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__;
                    TruffleLanguage.ContextReference<JSRealm> asTimeNode__contextRef__ = javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    return JSClass.asTime(arg0Value, asTimeNode__contextRef__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asTimeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LocalTime asTimeNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.ContextReference<JSRealm> asTimeNode__contextRef__ = null;
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    asTimeNode__contextRef__ = javaScriptLanguageContextReference__1;
                    this.state_ = state |= 0x40000000000L;
                    lock.unlock();
                    hasLock = false;
                    LocalTime localTime = JSClass.asTime(arg0Value, asTimeNode__contextRef__);
                    return localTime;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicObject arg0Value = (DynamicObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x80000000000L) != 0L) {
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__;
                    TruffleLanguage.ContextReference<JSRealm> asTimeZoneNode__contextRef__ = javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    return JSClass.asTimeZone(arg0Value, asTimeZoneNode__contextRef__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asTimeZoneNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ZoneId asTimeZoneNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    TruffleLanguage.ContextReference<JSRealm> asTimeZoneNode__contextRef__ = null;
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    asTimeZoneNode__contextRef__ = javaScriptLanguageContextReference__1;
                    this.state_ = state |= 0x80000000000L;
                    lock.unlock();
                    hasLock = false;
                    ZoneId zoneId = JSClass.asTimeZone(arg0Value, asTimeZoneNode__contextRef__);
                    return zoneId;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.hasLanguage((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.getLanguage((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.toDisplayString((DynamicObject)this.dynamicDispatch_.cast(receiver), allowSideEffects);
            }

            @Override
            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.hasSourceLocation((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.getSourceLocation((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.hasMetaObject((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.getMetaObject((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isMetaObject((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.getMetaObjectName((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.getMetaObjectName((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.isMetaInstance((DynamicObject)this.dynamicDispatch_.cast(receiver), instance);
            }

            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return JSClass.identityHashCode((DynamicObject)this.dynamicDispatch_.cast(receiver));
            }

            private static boolean getArraySizeFallbackGuard_(long state, DynamicObject arg0Value) {
                if ((state & 0x40L) == 0L && JSGuards.isJSArray(arg0Value)) {
                    return false;
                }
                if ((state & 0x80L) == 0L && JSGuards.isJSArrayBufferView(arg0Value)) {
                    return false;
                }
                return (state & 0x100L) != 0L || !JSGuards.isJSArgumentsObject(arg0Value);
            }

            private static boolean isIdenticalOrUndefinedFallbackGuard_(long state, DynamicObject arg0Value, Object arg1Value) {
                return (state & 0x400L) != 0L || !(arg1Value instanceof DynamicObject);
            }

            @GeneratedBy(value=JSClass.class)
            private static final class GetMembersNonArrayCachedData {
                @CompilerDirectives.CompilationFinal
                GetMembersNonArrayCachedData next_;
                @CompilerDirectives.CompilationFinal
                JSClass cachedJSClass_;

                GetMembersNonArrayCachedData(GetMembersNonArrayCachedData next_) {
                    this.next_ = next_;
                }
            }
        }
    }
}

