/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;

public final class ZeroBasedIntArray
extends AbstractIntArray {
    private static final ZeroBasedIntArray ZERO_BASED_INT_ARRAY = new ZeroBasedIntArray(0, ZeroBasedIntArray.createCache());

    public static ZeroBasedIntArray makeZeroBasedIntArray(DynamicObject object, int length, int usedLength, int[] array, int integrityLevel) {
        ZeroBasedIntArray arrayType = (ZeroBasedIntArray)ZeroBasedIntArray.createZeroBasedIntArray().setIntegrityLevel(integrityLevel);
        JSAbstractArray.arraySetLength(object, length);
        JSAbstractArray.arraySetUsedLength(object, usedLength);
        JSAbstractArray.arraySetArray(object, array);
        return arrayType;
    }

    public static ZeroBasedIntArray createZeroBasedIntArray() {
        return ZERO_BASED_INT_ARRAY;
    }

    private ZeroBasedIntArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    public boolean isSupported(DynamicObject object, long index, boolean condition) {
        return ZeroBasedIntArray.isSupportedZeroBased(object, (int)index, condition);
    }

    @Override
    public int getInBoundsFastInt(DynamicObject object, int index, boolean condition) {
        return ZeroBasedIntArray.getArray(object, condition)[index];
    }

    @Override
    public void setInBoundsFast(DynamicObject object, int index, int value, boolean condition) {
        ZeroBasedIntArray.getArray((DynamicObject)object, (boolean)condition)[index] = value;
    }

    @Override
    protected int prepareInBoundsFast(DynamicObject object, long index, boolean condition) {
        return (int)index;
    }

    @Override
    protected int prepareInBounds(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        ZeroBasedIntArray.prepareInBoundsZeroBased(object, index, condition, profile);
        return index;
    }

    @Override
    protected int prepareSupported(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        this.prepareSupportedZeroBased(object, index, condition, profile);
        return index;
    }

    @Override
    protected void setLengthLess(DynamicObject object, long length, boolean condition, ScriptArray.ProfileHolder profile) {
        this.setLengthLessZeroBased(object, length, condition, profile);
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        return this.toArrayZeroBased(object);
    }

    @Override
    public ZeroBasedDoubleArray toDouble(DynamicObject object, long index, double value, boolean condition) {
        int[] array = ZeroBasedIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedIntArray.getUsedLength(object, condition);
        double[] doubleCopy = ArrayCopy.intToDouble(array, 0, usedLength);
        ZeroBasedDoubleArray newArray = ZeroBasedDoubleArray.makeZeroBasedDoubleArray(object, length, usedLength, doubleCopy, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ZeroBasedObjectArray toObject(DynamicObject object, long index, Object value, boolean condition) {
        int[] array = ZeroBasedIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedIntArray.getUsedLength(object, condition);
        Object[] doubleCopy = ArrayCopy.intToObject(array, 0, usedLength);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, length, usedLength, doubleCopy, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ContiguousIntArray toContiguous(DynamicObject object, long index, Object value, boolean condition) {
        int[] array = ZeroBasedIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedIntArray.getUsedLength(object, condition);
        ContiguousIntArray newArray = ContiguousIntArray.makeContiguousIntArray(object, length, array, 0L, 0, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractWritableArray toHoles(DynamicObject object, long index, Object value, boolean condition) {
        int[] array = ZeroBasedIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedIntArray.getUsedLength(object, condition);
        AbstractWritableArray newArray = CompilerDirectives.injectBranchProbability(1.0E-4, ZeroBasedIntArray.containsHoleValue(object, condition)) ? this.toObjectHoles(object, condition) : HolesIntArray.makeHolesIntArray(object, length, array, 0L, 0, usedLength, 0, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    protected HolesObjectArray toObjectHoles(DynamicObject object, boolean condition) {
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedIntArray.getUsedLength(object, condition);
        return HolesObjectArray.makeHolesObjectArray(object, length, ZeroBasedIntArray.convertToObject(object, condition), 0L, 0, usedLength, 0, this.integrityLevel);
    }

    @Override
    public long firstElementIndex(DynamicObject object, boolean condition) {
        return 0L;
    }

    @Override
    public long lastElementIndex(DynamicObject object, boolean condition) {
        return ZeroBasedIntArray.getUsedLength(object, condition) - 1;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        int[] array = ZeroBasedIntArray.getArray(object);
        int usedLength = ZeroBasedIntArray.getUsedLength(object);
        System.arraycopy(array, (int)end, array, (int)start, Math.max(0, (int)((long)usedLength - end)));
        return this;
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        return this.addRangeImplZeroBased(object, offset, size);
    }

    @Override
    public boolean hasHoles(DynamicObject object, boolean condition) {
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedIntArray.getUsedLength(object, condition);
        return usedLength < length;
    }

    @Override
    protected ZeroBasedIntArray withIntegrityLevel(int newIntegrityLevel) {
        return new ZeroBasedIntArray(newIntegrityLevel, this.cache);
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index, boolean condition) {
        return this.nextElementIndexZeroBased(object, index, condition);
    }
}

