/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import java.util.List;

public class LazyArray
extends AbstractConstantArray {
    private static final LazyArray LAZY_ARRAY = new LazyArray(0, LazyArray.createCache());

    protected LazyArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    public static LazyArray createLazyArray() {
        return LAZY_ARRAY;
    }

    @Override
    protected DynamicArray withIntegrityLevel(int newIntegrityLevel) {
        return new LazyArray(newIntegrityLevel, this.cache);
    }

    static List<?> arrayGetLazyList(DynamicObject object, boolean condition) {
        return (List)JSAbstractArray.arrayGetArray(object, condition);
    }

    @Override
    public Object getElementInBounds(DynamicObject object, int index, boolean condition) {
        return Boundaries.listGet(LazyArray.arrayGetLazyList(object, condition), index);
    }

    @Override
    public boolean hasElement(DynamicObject object, long index, boolean condition) {
        return index >= 0L && index < (long)this.lengthInt(object, condition);
    }

    @Override
    public int lengthInt(DynamicObject object, boolean condition) {
        return (int)JSAbstractArray.arrayGetLength(object, condition);
    }

    @Override
    public AbstractWritableArray createWriteableObject(DynamicObject object, long index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        int len = this.lengthInt(object, condition);
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.getElementInBounds(object, i, condition);
        }
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, array.length, array.length, array, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            LazyArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractWritableArray createWriteableDouble(DynamicObject object, long index, double value, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, condition, profile);
    }

    @Override
    public AbstractWritableArray createWriteableInt(DynamicObject object, long index, int value, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, condition, profile);
    }

    @Override
    public AbstractWritableArray createWriteableJSObject(DynamicObject object, long index, DynamicObject value, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, condition, profile);
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this.createWriteableObject(object, index, null, condition, ScriptArray.ProfileHolder.empty()).deleteElementImpl(object, index, strict, condition);
    }

    @Override
    public ScriptArray setLengthImpl(DynamicObject object, long len, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, len - 1L, null, condition, ScriptArray.ProfileHolder.empty()).setLengthImpl(object, len, condition, profile);
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        return this.createWriteableObject(object, start, null, JSArray.isJSArray(object), ScriptArray.ProfileHolder.empty()).removeRangeImpl(object, start, end);
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        return this.createWriteableObject(object, offset, null, JSArray.isJSArray(object), ScriptArray.ProfileHolder.empty()).addRangeImpl(object, offset, size);
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        int len = this.lengthInt(object);
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.getElementInBounds(object, i, LazyArray.arrayCondition());
        }
        return array;
    }
}

