/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedIntArray;

public final class ContiguousIntArray
extends AbstractContiguousIntArray {
    private static final ContiguousIntArray CONTIGUOUS_INT_ARRAY = new ContiguousIntArray(0, ContiguousIntArray.createCache());

    public static ContiguousIntArray makeContiguousIntArray(DynamicObject object, long length, int[] array, long indexOffset, int arrayOffset, int usedLength, int integrityLevel) {
        ContiguousIntArray arrayType = (ContiguousIntArray)ContiguousIntArray.createContiguousIntArray().setIntegrityLevel(integrityLevel);
        ContiguousIntArray.setArrayProperties(object, array, length, usedLength, indexOffset, arrayOffset);
        return arrayType;
    }

    private static ContiguousIntArray createContiguousIntArray() {
        return CONTIGUOUS_INT_ARRAY;
    }

    private ContiguousIntArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    protected int prepareInBounds(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.prepareInBoundsContiguous(object, index, condition, profile);
    }

    @Override
    protected int prepareSupported(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.prepareSupportedContiguous(object, index, condition, profile);
    }

    @Override
    public boolean isSupported(DynamicObject object, long index, boolean condition) {
        return this.isSupportedContiguous(object, index, condition);
    }

    @Override
    public ContiguousDoubleArray toDouble(DynamicObject object, long index, double value, boolean condition) {
        int[] array = ContiguousIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ContiguousIntArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        double[] doubleCopy = ArrayCopy.intToDouble(array, arrayOffset, usedLength);
        ContiguousDoubleArray newArray = ContiguousDoubleArray.makeContiguousDoubleArray(object, length, doubleCopy, indexOffset, arrayOffset, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ContiguousIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ContiguousObjectArray toObject(DynamicObject object, long index, Object value, boolean condition) {
        int[] array = ContiguousIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ContiguousIntArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        Object[] doubleCopy = ArrayCopy.intToObject(array, arrayOffset, usedLength);
        ContiguousObjectArray newArray = ContiguousObjectArray.makeContiguousObjectArray(object, length, doubleCopy, indexOffset, arrayOffset, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ContiguousIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractWritableArray toHoles(DynamicObject object, long index, Object value, boolean condition) {
        int[] array = ContiguousIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ContiguousIntArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        AbstractWritableArray newArray = CompilerDirectives.injectBranchProbability(1.0E-4, ContiguousIntArray.containsHoleValue(object, condition)) ? this.toObjectHoles(object, condition) : HolesIntArray.makeHolesIntArray(object, length, array, indexOffset, arrayOffset, usedLength, 0, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ContiguousIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    protected HolesObjectArray toObjectHoles(DynamicObject object, boolean condition) {
        int length = this.lengthInt(object, condition);
        int usedLength = ContiguousIntArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        return HolesObjectArray.makeHolesObjectArray(object, length, ContiguousIntArray.convertToObject(object, condition), indexOffset, arrayOffset, usedLength, 0, this.integrityLevel);
    }

    @Override
    public ZeroBasedIntArray toNonContiguous(DynamicObject object, int index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        this.setSupported(object, index, (Integer)value, condition, profile);
        int[] array = ContiguousIntArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ContiguousIntArray.getUsedLength(object, condition);
        ZeroBasedIntArray newArray = ZeroBasedIntArray.makeZeroBasedIntArray(object, length, usedLength, array, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ContiguousIntArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        return this.removeRangeContiguous(object, start, end);
    }

    @Override
    protected ContiguousIntArray withIntegrityLevel(int newIntegrityLevel) {
        return new ContiguousIntArray(newIntegrityLevel, this.cache);
    }
}

