/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;

public abstract class AbstractDoubleArray
extends AbstractWritableArray {
    protected AbstractDoubleArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    AbstractWritableArray sameTypeHolesArray(DynamicObject object, int length, Object array, long indexOffset, int arrayOffset, int usedLength, int holeCount) {
        return HolesDoubleArray.makeHolesDoubleArray(object, length, (double[])array, indexOffset, arrayOffset, usedLength, holeCount, this.integrityLevel);
    }

    public abstract void setInBoundsFast(DynamicObject var1, int var2, double var3, boolean var5);

    @Override
    public final ScriptArray setElementImpl(DynamicObject object, long index, Object value, boolean strict, boolean condition) {
        assert (index >= 0L);
        if (CompilerDirectives.injectBranchProbability(0.9999, (value instanceof Integer || value instanceof Double) && this.isSupported(object, (int)index, condition))) {
            double doubleValue = JSRuntime.doubleValue((Number)value);
            assert (!HolesDoubleArray.isHoleValue(doubleValue));
            this.setSupported(object, (int)index, doubleValue, condition, ScriptArray.ProfileHolder.empty());
            return this;
        }
        return this.rewrite(object, index, value, condition).setElementImpl(object, index, value, strict, condition);
    }

    private ScriptArray rewrite(DynamicObject object, long index, Object value, boolean condition) {
        if (value instanceof Integer || value instanceof Double) {
            if (this.isSupportedContiguous(object, index, condition)) {
                return this.toContiguous(object, index, value, condition);
            }
            if (this.isSupportedHoles(object, index, condition)) {
                return this.toHoles(object, index, value, condition);
            }
            return this.toSparse(object, index, value);
        }
        return this.toObject(object, index, value, condition);
    }

    @Override
    public Object getInBoundsFast(DynamicObject object, int index, boolean condition) {
        return this.getInBoundsFastDouble(object, index, condition);
    }

    @Override
    public abstract double getInBoundsFastDouble(DynamicObject var1, int var2, boolean var3);

    @Override
    int getArrayLength(Object array) {
        return ((double[])array).length;
    }

    protected static double[] getArray(DynamicObject object) {
        return AbstractDoubleArray.getArray(object, AbstractDoubleArray.arrayCondition());
    }

    protected static double[] getArray(DynamicObject object, boolean condition) {
        return AbstractDoubleArray.arrayCast(JSAbstractArray.arrayGetArray(object, condition), double[].class, condition);
    }

    public final void setInBounds(DynamicObject object, int index, double value, boolean condition, ScriptArray.ProfileHolder profile) {
        AbstractDoubleArray.getArray((DynamicObject)object, (boolean)condition)[this.prepareInBounds((DynamicObject)object, (int)index, (boolean)condition, (ScriptArray.ProfileHolder)profile)] = value;
    }

    public final void setSupported(DynamicObject object, int index, double value, boolean condition, ScriptArray.ProfileHolder profile) {
        int preparedIndex = this.prepareSupported(object, index, condition, profile);
        AbstractDoubleArray.getArray((DynamicObject)object, (boolean)condition)[preparedIndex] = value;
    }

    @Override
    void fillWithHoles(Object array, int fromIndex, int toIndex) {
        double[] doubleArray = (double[])array;
        for (int i = fromIndex; i < toIndex; ++i) {
            doubleArray[i] = HolesDoubleArray.HOLE_VALUE_DOUBLE;
        }
    }

    @Override
    protected final void setHoleValue(DynamicObject object, int preparedIndex) {
        AbstractDoubleArray.getArray((DynamicObject)object)[preparedIndex] = HolesDoubleArray.HOLE_VALUE_DOUBLE;
    }

    @Override
    protected final boolean isHolePrepared(DynamicObject object, int preparedIndex, boolean condition) {
        return HolesDoubleArray.isHoleValue(AbstractDoubleArray.getArray(object, condition)[preparedIndex]);
    }

    @Override
    protected final int getArrayCapacity(DynamicObject object, boolean condition) {
        return AbstractDoubleArray.getArray(object, condition).length;
    }

    @Override
    protected final void resizeArray(DynamicObject object, int newCapacity, int oldCapacity, int offset, boolean condition) {
        double[] newArray = new double[newCapacity];
        System.arraycopy(AbstractDoubleArray.getArray(object, condition), 0, newArray, offset, oldCapacity);
        JSAbstractArray.arraySetArray(object, newArray);
    }

    @Override
    public abstract AbstractDoubleArray toHoles(DynamicObject var1, long var2, Object var4, boolean var5);

    @Override
    public final AbstractWritableArray toDouble(DynamicObject object, long index, double value, boolean condition) {
        return this;
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this.toHoles(object, index, 9221120237041090561L, condition).deleteElementImpl(object, index, strict, condition);
    }

    @Override
    protected final void moveRangePrepared(DynamicObject object, int src, int dst, int len) {
        double[] array = AbstractDoubleArray.getArray(object);
        System.arraycopy(array, src, array, dst, len);
    }

    @Override
    public final Object allocateArray(int length) {
        return new double[length];
    }

    @Override
    protected abstract AbstractDoubleArray withIntegrityLevel(int var1);
}

