/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.TypeOfNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=TypeOfNode.class)
public final class TypeOfNodeGen
extends TypeOfNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private TypeOfNode jSProxy_typeofNode_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile jSProxy_revokedProxyBranch_;
    @Node.Child
    private TruffleObject0Data truffleObject0_cache;

    private TypeOfNodeGen(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        TruffleObject operandNodeValue_;
        int state = this.state_;
        if ((state & 1) != 0 && JSTypesGen.isImplicitCharSequence((state & 0x3C000) >>> 14, operandNodeValue)) {
            CharSequence operandNodeValue_2 = JSTypesGen.asImplicitCharSequence((state & 0x3C000) >>> 14, operandNodeValue);
            return this.doString(operandNodeValue_2);
        }
        if ((state & 2) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_3 = (Integer)operandNodeValue;
            return this.doInt(operandNodeValue_3);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0000) >>> 18, operandNodeValue)) {
            double operandNodeValue_4 = JSTypesGen.asImplicitDouble((state & 0x3C0000) >>> 18, operandNodeValue);
            return this.doDouble(operandNodeValue_4);
        }
        if ((state & 8) != 0 && operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_5 = (Boolean)operandNodeValue;
            return this.doBoolean(operandNodeValue_5);
        }
        if ((state & 0x10) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_6 = (BigInt)operandNodeValue;
            return this.doBigInt(operandNodeValue_6);
        }
        if ((state & 0x60) != 0) {
            if ((state & 0x20) != 0 && JSGuards.isJSNull(operandNodeValue)) {
                return this.doNull(operandNodeValue);
            }
            if ((state & 0x40) != 0 && JSGuards.isUndefined(operandNodeValue)) {
                return this.doUndefined(operandNodeValue);
            }
        }
        if ((state & 0x380) != 0 && JSTypes.isDynamicObject(operandNodeValue)) {
            operandNodeValue_ = (DynamicObject)operandNodeValue;
            if ((state & 0x80) != 0 && JSGuards.isJSFunction(operandNodeValue_)) {
                return this.doJSFunction((DynamicObject)operandNodeValue_);
            }
            if ((state & 0x100) != 0 && JSGuards.isJSType(operandNodeValue_) && !JSGuards.isJSFunction(operandNodeValue_) && !JSGuards.isUndefined(operandNodeValue_) && !JSGuards.isJSProxy(operandNodeValue_)) {
                return this.doJSObjectOnly((DynamicObject)operandNodeValue_);
            }
            if ((state & 0x200) != 0 && JSGuards.isJSProxy(operandNodeValue_)) {
                return this.doJSProxy((DynamicObject)operandNodeValue_, this.jSProxy_typeofNode_, this.jSProxy_revokedProxyBranch_);
            }
        }
        if ((state & 0x400) != 0 && operandNodeValue instanceof Symbol) {
            operandNodeValue_ = (Symbol)operandNodeValue;
            return this.doSymbol((Symbol)operandNodeValue_);
        }
        if ((state & 0x3800) != 0) {
            if ((state & 0x800) != 0) {
                TruffleObject0Data s12_ = this.truffleObject0_cache;
                while (s12_ != null) {
                    if (s12_.interop_.accepts(operandNodeValue) && JSRuntime.isForeignObject(operandNodeValue)) {
                        return this.doTruffleObject(operandNodeValue, s12_.interop_);
                    }
                    s12_ = s12_.next_;
                }
            }
            if ((state & 0x1000) != 0 && JSRuntime.isForeignObject(operandNodeValue)) {
                return this.truffleObject1Boundary(state, operandNodeValue);
            }
            if ((state & 0x2000) != 0 && TypeOfNodeGen.fallbackGuard_(state, operandNodeValue)) {
                return this.doJavaObject(operandNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object truffleObject1Boundary(int state, Object operandNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary truffleObject1_interop__ = INTEROP_LIBRARY_.getUncached(operandNodeValue);
            String string = this.doTruffleObject(operandNodeValue, truffleObject1_interop__);
            return string;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    @ExplodeLoop
    public String executeString(Object operandNodeValue) {
        TruffleObject operandNodeValue_;
        int state = this.state_;
        if ((state & 1) != 0 && JSTypesGen.isImplicitCharSequence((state & 0x3C000) >>> 14, operandNodeValue)) {
            CharSequence operandNodeValue_2 = JSTypesGen.asImplicitCharSequence((state & 0x3C000) >>> 14, operandNodeValue);
            return this.doString(operandNodeValue_2);
        }
        if ((state & 2) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_3 = (Integer)operandNodeValue;
            return this.doInt(operandNodeValue_3);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0000) >>> 18, operandNodeValue)) {
            double operandNodeValue_4 = JSTypesGen.asImplicitDouble((state & 0x3C0000) >>> 18, operandNodeValue);
            return this.doDouble(operandNodeValue_4);
        }
        if ((state & 8) != 0 && operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_5 = (Boolean)operandNodeValue;
            return this.doBoolean(operandNodeValue_5);
        }
        if ((state & 0x10) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_6 = (BigInt)operandNodeValue;
            return this.doBigInt(operandNodeValue_6);
        }
        if ((state & 0x60) != 0) {
            if ((state & 0x20) != 0 && JSGuards.isJSNull(operandNodeValue)) {
                return this.doNull(operandNodeValue);
            }
            if ((state & 0x40) != 0 && JSGuards.isUndefined(operandNodeValue)) {
                return this.doUndefined(operandNodeValue);
            }
        }
        if ((state & 0x380) != 0 && JSTypes.isDynamicObject(operandNodeValue)) {
            operandNodeValue_ = (DynamicObject)operandNodeValue;
            if ((state & 0x80) != 0 && JSGuards.isJSFunction(operandNodeValue_)) {
                return this.doJSFunction((DynamicObject)operandNodeValue_);
            }
            if ((state & 0x100) != 0 && JSGuards.isJSType(operandNodeValue_) && !JSGuards.isJSFunction(operandNodeValue_) && !JSGuards.isUndefined(operandNodeValue_) && !JSGuards.isJSProxy(operandNodeValue_)) {
                return this.doJSObjectOnly((DynamicObject)operandNodeValue_);
            }
            if ((state & 0x200) != 0 && JSGuards.isJSProxy(operandNodeValue_)) {
                return this.doJSProxy((DynamicObject)operandNodeValue_, this.jSProxy_typeofNode_, this.jSProxy_revokedProxyBranch_);
            }
        }
        if ((state & 0x400) != 0 && operandNodeValue instanceof Symbol) {
            operandNodeValue_ = (Symbol)operandNodeValue;
            return this.doSymbol((Symbol)operandNodeValue_);
        }
        if ((state & 0x3800) != 0) {
            if ((state & 0x800) != 0) {
                TruffleObject0Data s12_ = this.truffleObject0_cache;
                while (s12_ != null) {
                    if (s12_.interop_.accepts(operandNodeValue) && JSRuntime.isForeignObject(operandNodeValue)) {
                        return this.doTruffleObject(operandNodeValue, s12_.interop_);
                    }
                    s12_ = s12_.next_;
                }
            }
            if ((state & 0x1000) != 0 && JSRuntime.isForeignObject(operandNodeValue)) {
                return this.truffleObject1Boundary0(state, operandNodeValue);
            }
            if ((state & 0x2000) != 0 && TypeOfNodeGen.fallbackGuard_(state, operandNodeValue)) {
                return this.doJavaObject(operandNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private String truffleObject1Boundary0(int state, Object operandNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary truffleObject1_interop__ = INTEROP_LIBRARY_.getUncached(operandNodeValue);
            String string = this.doTruffleObject(operandNodeValue, truffleObject1_interop__);
            return string;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x3FFD) == 0 && (state & 0x3FFF) != 0) {
            return this.execute_int0(frameValue, state);
        }
        if ((state & 0x3FFB) == 0 && (state & 0x3FFF) != 0) {
            return this.execute_double1(frameValue, state);
        }
        if ((state & 0x3FF7) == 0 && (state & 0x3FFF) != 0) {
            return this.execute_boolean2(frameValue, state);
        }
        return this.execute_generic3(frameValue, state);
    }

    private Object execute_int0(VirtualFrame frameValue, int state) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 2) != 0);
        return this.doInt(operandNodeValue_);
    }

    private Object execute_double1(VirtualFrame frameValue, int state) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0x380000) == 0 && (state & 0x3FFF) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0x340000) == 0 && (state & 0x3FFF) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0x2C0000) == 0 && (state & 0x3FFF) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x3C0000) >>> 18, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 4) != 0);
        return this.doDouble(operandNodeValue_);
    }

    private Object execute_boolean2(VirtualFrame frameValue, int state) {
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 8) != 0);
        return this.doBoolean(operandNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object truffleObject1Boundary1(int state, Object operandNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary truffleObject1_interop__ = INTEROP_LIBRARY_.getUncached(operandNodeValue_);
            String string = this.doTruffleObject(operandNodeValue_, truffleObject1_interop__);
            return string;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private Object execute_generic3(VirtualFrame frameValue, int state) {
        TruffleObject operandNodeValue__;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && JSTypesGen.isImplicitCharSequence((state & 0x3C000) >>> 14, operandNodeValue_)) {
            CharSequence operandNodeValue__2 = JSTypesGen.asImplicitCharSequence((state & 0x3C000) >>> 14, operandNodeValue_);
            return this.doString(operandNodeValue__2);
        }
        if ((state & 2) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__3 = (Integer)operandNodeValue_;
            return this.doInt(operandNodeValue__3);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0000) >>> 18, operandNodeValue_)) {
            double operandNodeValue__4 = JSTypesGen.asImplicitDouble((state & 0x3C0000) >>> 18, operandNodeValue_);
            return this.doDouble(operandNodeValue__4);
        }
        if ((state & 8) != 0 && operandNodeValue_ instanceof Boolean) {
            boolean operandNodeValue__5 = (Boolean)operandNodeValue_;
            return this.doBoolean(operandNodeValue__5);
        }
        if ((state & 0x10) != 0 && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__6 = (BigInt)operandNodeValue_;
            return this.doBigInt(operandNodeValue__6);
        }
        if ((state & 0x60) != 0) {
            if ((state & 0x20) != 0 && JSGuards.isJSNull(operandNodeValue_)) {
                return this.doNull(operandNodeValue_);
            }
            if ((state & 0x40) != 0 && JSGuards.isUndefined(operandNodeValue_)) {
                return this.doUndefined(operandNodeValue_);
            }
        }
        if ((state & 0x380) != 0 && JSTypes.isDynamicObject(operandNodeValue_)) {
            operandNodeValue__ = (DynamicObject)operandNodeValue_;
            if ((state & 0x80) != 0 && JSGuards.isJSFunction(operandNodeValue__)) {
                return this.doJSFunction((DynamicObject)operandNodeValue__);
            }
            if ((state & 0x100) != 0 && JSGuards.isJSType(operandNodeValue__) && !JSGuards.isJSFunction(operandNodeValue__) && !JSGuards.isUndefined(operandNodeValue__) && !JSGuards.isJSProxy(operandNodeValue__)) {
                return this.doJSObjectOnly((DynamicObject)operandNodeValue__);
            }
            if ((state & 0x200) != 0 && JSGuards.isJSProxy(operandNodeValue__)) {
                return this.doJSProxy((DynamicObject)operandNodeValue__, this.jSProxy_typeofNode_, this.jSProxy_revokedProxyBranch_);
            }
        }
        if ((state & 0x400) != 0 && operandNodeValue_ instanceof Symbol) {
            operandNodeValue__ = (Symbol)operandNodeValue_;
            return this.doSymbol((Symbol)operandNodeValue__);
        }
        if ((state & 0x3800) != 0) {
            if ((state & 0x800) != 0) {
                TruffleObject0Data s12_ = this.truffleObject0_cache;
                while (s12_ != null) {
                    if (s12_.interop_.accepts(operandNodeValue_) && JSRuntime.isForeignObject(operandNodeValue_)) {
                        return this.doTruffleObject(operandNodeValue_, s12_.interop_);
                    }
                    s12_ = s12_.next_;
                }
            }
            if ((state & 0x1000) != 0 && JSRuntime.isForeignObject(operandNodeValue_)) {
                return this.truffleObject1Boundary1(state, operandNodeValue_);
            }
            if ((state & 0x2000) != 0 && TypeOfNodeGen.fallbackGuard_(state, operandNodeValue_)) {
                return this.doJavaObject(operandNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            int n = JSTypesGen.specializeImplicitCharSequence(operandNodeValue);
            if (n != 0) {
                CharSequence operandNodeValue_2 = JSTypesGen.asImplicitCharSequence(n, operandNodeValue);
                state |= n << 14;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.doString(operandNodeValue_2);
                return string;
            }
            if (operandNodeValue instanceof Integer) {
                int n2 = (Integer)operandNodeValue;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                String operandNodeValue_2 = this.doInt(n2);
                return operandNodeValue_2;
            }
            int n3 = JSTypesGen.specializeImplicitDouble(operandNodeValue);
            if (n3 != 0) {
                double operandNodeValue_3 = JSTypesGen.asImplicitDouble(n3, operandNodeValue);
                state |= n3 << 18;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.doDouble(operandNodeValue_3);
                return string;
            }
            if (operandNodeValue instanceof Boolean) {
                boolean bl = (Boolean)operandNodeValue;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                String operandNodeValue_3 = this.doBoolean(bl);
                return operandNodeValue_3;
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt bigInt = (BigInt)operandNodeValue;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                String operandNodeValue_3 = this.doBigInt(bigInt);
                return operandNodeValue_3;
            }
            if (JSGuards.isJSNull(operandNodeValue)) {
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                String string = this.doNull(operandNodeValue);
                return string;
            }
            if (JSGuards.isUndefined(operandNodeValue)) {
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                String string = this.doUndefined(operandNodeValue);
                return string;
            }
            if (JSTypes.isDynamicObject(operandNodeValue)) {
                DynamicObject string = (DynamicObject)operandNodeValue;
                if (JSGuards.isJSFunction(string)) {
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    String operandNodeValue_3 = this.doJSFunction(string);
                    return operandNodeValue_3;
                }
                if (JSGuards.isJSType(string) && !JSGuards.isJSFunction(string) && !JSGuards.isUndefined(string) && !JSGuards.isJSProxy(string)) {
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    String operandNodeValue_3 = this.doJSObjectOnly(string);
                    return operandNodeValue_3;
                }
                if (JSGuards.isJSProxy(string)) {
                    this.jSProxy_typeofNode_ = super.insert(TypeOfNode.create());
                    this.jSProxy_revokedProxyBranch_ = BranchProfile.create();
                    this.state_ = state |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    String operandNodeValue_3 = this.doJSProxy(string, this.jSProxy_typeofNode_, this.jSProxy_revokedProxyBranch_);
                    return operandNodeValue_3;
                }
            }
            if (operandNodeValue instanceof Symbol) {
                Symbol symbol = (Symbol)operandNodeValue;
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                String operandNodeValue_3 = this.doSymbol(symbol);
                return operandNodeValue_3;
            }
            if (exclude == 0) {
                void var6_16;
                boolean bl = false;
                TruffleObject0Data s12_ = this.truffleObject0_cache;
                if ((state & 0x800) != 0) {
                    while (!(s12_ == null || s12_.interop_.accepts(operandNodeValue) && JSRuntime.isForeignObject(operandNodeValue))) {
                        s12_ = s12_.next_;
                        ++var6_16;
                    }
                }
                if (s12_ == null && JSRuntime.isForeignObject(operandNodeValue) && var6_16 < 5) {
                    s12_ = super.insert(new TruffleObject0Data(this.truffleObject0_cache));
                    s12_.interop_ = s12_.insertAccessor(INTEROP_LIBRARY_.create(operandNodeValue));
                    this.truffleObject0_cache = s12_;
                    this.state_ = state |= 0x800;
                }
                if (s12_ != null) {
                    lock.unlock();
                    hasLock = false;
                    String string = this.doTruffleObject(operandNodeValue, s12_.interop_);
                    return string;
                }
            }
            Object var6_17 = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                if (JSRuntime.isForeignObject(operandNodeValue)) {
                    InteropLibrary interopLibrary = INTEROP_LIBRARY_.getUncached(operandNodeValue);
                    this.exclude_ = exclude |= 1;
                    this.truffleObject0_cache = null;
                    state &= 0xFFFFF7FF;
                    this.state_ = state |= 0x1000;
                    lock.unlock();
                    hasLock = false;
                    String string = this.doTruffleObject(operandNodeValue, interopLibrary);
                    return string;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            this.state_ = state |= 0x2000;
            lock.unlock();
            hasLock = false;
            String string = this.doJavaObject(operandNodeValue);
            return string;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        TruffleObject0Data s12_;
        int state = this.state_;
        if ((state & 0x3FFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3FFF & (state & 0x3FFF) - 1) == 0 && ((s12_ = this.truffleObject0_cache) == null || s12_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Cloneable>> cached;
        Object[] data = new Object[15];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doJSFunction";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doJSObjectOnly";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doJSProxy";
        if ((state & 0x200) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Cloneable>>();
            cached.add(Arrays.asList(this.jSProxy_typeofNode_, this.jSProxy_revokedProxyBranch_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "doTruffleObject";
        if ((state & 0x800) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            TruffleObject0Data s12_ = this.truffleObject0_cache;
            while (s12_ != null) {
                cached.add(Arrays.asList(s12_.interop_));
                s12_ = s12_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doTruffleObject";
        if ((state & 0x1000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached()));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "doJavaObject";
        s[1] = (state & 0x2000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[14] = s;
        return Introspection.Provider.create(data);
    }

    private static boolean fallbackGuard_(int state, Object operandNodeValue) {
        if (JSTypesGen.isImplicitCharSequence(operandNodeValue)) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(operandNodeValue)) {
            return false;
        }
        if ((state & 8) == 0 && operandNodeValue instanceof Boolean) {
            return false;
        }
        if ((state & 0x10) == 0 && operandNodeValue instanceof BigInt) {
            return false;
        }
        if ((state & 0x20) == 0 && JSGuards.isJSNull(operandNodeValue)) {
            return false;
        }
        if ((state & 0x40) == 0 && JSGuards.isUndefined(operandNodeValue)) {
            return false;
        }
        if (JSTypes.isDynamicObject(operandNodeValue)) {
            DynamicObject operandNodeValue_ = (DynamicObject)operandNodeValue;
            if (JSGuards.isJSFunction(operandNodeValue_)) {
                return false;
            }
            operandNodeValue_ = (DynamicObject)operandNodeValue;
            if (JSGuards.isJSType(operandNodeValue_) && !JSGuards.isJSFunction(operandNodeValue_) && !JSGuards.isUndefined(operandNodeValue_) && !JSGuards.isJSProxy(operandNodeValue_)) {
                return false;
            }
            operandNodeValue_ = (DynamicObject)operandNodeValue;
            if (JSGuards.isJSProxy(operandNodeValue_)) {
                return false;
            }
        }
        if ((state & 0x400) == 0 && operandNodeValue instanceof Symbol) {
            return false;
        }
        return (state & 0x1000) != 0 || !JSRuntime.isForeignObject(operandNodeValue);
    }

    public static TypeOfNode create(JavaScriptNode operand) {
        return new TypeOfNodeGen(operand);
    }

    @GeneratedBy(value=TypeOfNode.class)
    private static final class TruffleObject0Data
    extends Node {
        @Node.Child
        TruffleObject0Data next_;
        @Node.Child
        InteropLibrary interop_;

        TruffleObject0Data(TruffleObject0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

