/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.unary.JSUnaryMinusNode;
import com.oracle.truffle.js.runtime.BigInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSUnaryMinusNode.class)
public final class JSUnaryMinusNodeGen
extends JSUnaryMinusNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private JSToNumericNode generic_toNumericNode_;
    @Node.Child
    private JSUnaryMinusNode generic_recursiveUnaryMinus_;

    private JSUnaryMinusNodeGen(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    public Object execute(Object operandNodeValue) {
        int operandNodeValue_;
        int state = this.state_;
        if ((state & 1) != 0 && operandNodeValue instanceof Integer && JSUnaryMinusNode.isInt(operandNodeValue_ = ((Integer)operandNodeValue).intValue())) {
            return JSUnaryMinusNode.doInt(operandNodeValue_);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0) >>> 4, operandNodeValue)) {
            double operandNodeValue_2 = JSTypesGen.asImplicitDouble((state & 0xF0) >>> 4, operandNodeValue);
            return JSUnaryMinusNode.doDouble(operandNodeValue_2);
        }
        if ((state & 4) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_3 = (BigInt)operandNodeValue;
            return JSUnaryMinusNode.doBigInt(operandNodeValue_3);
        }
        if ((state & 8) != 0) {
            return JSUnaryMinusNode.doGeneric(operandNodeValue, this.generic_toNumericNode_, this.generic_recursiveUnaryMinus_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int operandNodeValue_;
        int state = this.state_;
        if ((state & 1) != 0 && operandNodeValue instanceof Integer && JSUnaryMinusNode.isInt(operandNodeValue_ = ((Integer)operandNodeValue).intValue())) {
            return JSUnaryMinusNode.doInt(operandNodeValue_);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0) >>> 4, operandNodeValue)) {
            double operandNodeValue_2 = JSTypesGen.asImplicitDouble((state & 0xF0) >>> 4, operandNodeValue);
            return JSUnaryMinusNode.doDouble(operandNodeValue_2);
        }
        if ((state & 4) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_3 = (BigInt)operandNodeValue;
            return JSUnaryMinusNode.doBigInt(operandNodeValue_3);
        }
        if ((state & 8) != 0) {
            return JSUnaryMinusNode.doGeneric(operandNodeValue, this.generic_toNumericNode_, this.generic_recursiveUnaryMinus_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0xE) == 0 && (state & 0xF) != 0) {
            return this.execute_int0(frameValue, state);
        }
        if ((state & 0xD) == 0 && (state & 0xF) != 0) {
            return this.execute_double1(frameValue, state);
        }
        return this.execute_generic2(frameValue, state);
    }

    private Object execute_int0(VirtualFrame frameValue, int state) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        if (JSUnaryMinusNode.isInt(operandNodeValue_)) {
            return JSUnaryMinusNode.doInt(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    private Object execute_double1(VirtualFrame frameValue, int state) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0xE0) == 0 && (state & 0xF) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0xD0) == 0 && (state & 0xF) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0xB0) == 0 && (state & 0xF) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0xF0) >>> 4, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 2) != 0);
        return JSUnaryMinusNode.doDouble(operandNodeValue_);
    }

    private Object execute_generic2(VirtualFrame frameValue, int state) {
        int operandNodeValue__;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof Integer && JSUnaryMinusNode.isInt(operandNodeValue__ = ((Integer)operandNodeValue_).intValue())) {
            return JSUnaryMinusNode.doInt(operandNodeValue__);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0) >>> 4, operandNodeValue_)) {
            double operandNodeValue__2 = JSTypesGen.asImplicitDouble((state & 0xF0) >>> 4, operandNodeValue_);
            return JSUnaryMinusNode.doDouble(operandNodeValue__2);
        }
        if ((state & 4) != 0 && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__3 = (BigInt)operandNodeValue_;
            return JSUnaryMinusNode.doBigInt(operandNodeValue__3);
        }
        if ((state & 8) != 0) {
            return JSUnaryMinusNode.doGeneric(operandNodeValue_, this.generic_toNumericNode_, this.generic_recursiveUnaryMinus_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        double operandNodeValue_;
        int state = this.state_;
        if ((state & 8) != 0) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0xE0) == 0 && (state & 0xF) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0xD0) == 0 && (state & 0xF) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0xB0) == 0 && (state & 0xF) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0xF0) >>> 4, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state & 2) != 0) {
            return JSUnaryMinusNode.doDouble(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize((state & 0xE0) == 0 && (state & 0xF) != 0 ? (Number)operandNodeValue_long : (Number)((state & 0xD0) == 0 && (state & 0xF) != 0 ? (Number)operandNodeValue_int : (Number)operandNodeValue_)));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int operandNodeValue_;
        int state = this.state_;
        if ((state & 8) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state & 1) != 0 && JSUnaryMinusNode.isInt(operandNodeValue_)) {
            return JSUnaryMinusNode.doInt(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(operandNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0xE) == 0 && (state & 0xF) != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 0xD) == 0 && (state & 0xF) != 0) {
                this.executeDouble(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            int operandNodeValue_;
            if (operandNodeValue instanceof Integer && JSUnaryMinusNode.isInt(operandNodeValue_ = ((Integer)operandNodeValue).intValue())) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Integer n = JSUnaryMinusNode.doInt(operandNodeValue_);
                return n;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue);
            if (doubleCast0 != 0) {
                double operandNodeValue_2 = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                state |= doubleCast0 << 4;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Double d = JSUnaryMinusNode.doDouble(operandNodeValue_2);
                return d;
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_3 = (BigInt)operandNodeValue;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                BigInt bigInt = JSUnaryMinusNode.doBigInt(operandNodeValue_3);
                return bigInt;
            }
            this.generic_toNumericNode_ = super.insert(JSToNumericNode.create());
            this.generic_recursiveUnaryMinus_ = super.insert(JSUnaryMinusNode.create());
            this.state_ = state |= 8;
            lock.unlock();
            hasLock = false;
            Object object = JSUnaryMinusNode.doGeneric(operandNodeValue, this.generic_toNumericNode_, this.generic_recursiveUnaryMinus_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0xF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0xF & (state & 0xF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
            cached.add(Arrays.asList(this.generic_toNumericNode_, this.generic_recursiveUnaryMinus_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[4] = s;
        return Introspection.Provider.create(data);
    }

    public static JSUnaryMinusNode create(JavaScriptNode operand) {
        return new JSUnaryMinusNodeGen(operand);
    }
}

