/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSEqualNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.unary.JSIsNullOrUndefinedNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.Set;

public abstract class JSIsNullOrUndefinedNode
extends JSUnaryNode {
    protected static final int MAX_SHAPE_COUNT = 1;
    protected static final int MAX_TYPE_COUNT = 1;
    protected static final int MAX_CLASSES = 3;
    private final boolean isLeft;
    private final boolean isUndefined;

    protected JSIsNullOrUndefinedNode(JavaScriptNode operand, boolean isUndefined, boolean isLeft) {
        super(operand);
        this.isUndefined = isUndefined;
        this.isLeft = isLeft;
    }

    public abstract boolean executeBoolean(Object var1);

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class)) {
            JSConstantNode constantNode = this.isUndefined ? JSConstantNode.createUndefined() : JSConstantNode.createNull();
            JavaScriptNode newOperand = JSIsNullOrUndefinedNode.cloneUninitialized(this.getOperand(), materializedTags);
            JavaScriptNode left = this.isLeft ? constantNode : newOperand;
            JavaScriptNode right = this.isLeft ? newOperand : constantNode;
            JavaScriptNode materialized = JSEqualNode.createUnoptimized(left, right);
            JSIsNullOrUndefinedNode.transferSourceSectionAddExpressionTag(this, constantNode);
            JSIsNullOrUndefinedNode.transferSourceSectionAndTags(this, materialized);
            return materialized;
        }
        return this;
    }

    @Specialization(guards={"isJSNull(operand)"})
    protected static boolean doNull(Object operand) {
        return true;
    }

    @Specialization(guards={"isUndefined(operand)"})
    protected static boolean doUndefined(Object operand) {
        return true;
    }

    @Specialization
    protected static boolean doSymbol(Symbol operand) {
        return false;
    }

    @Specialization
    protected static boolean doLazyString(JSLazyString operand) {
        return false;
    }

    @Specialization
    protected static boolean doSafeInteger(SafeInteger operand) {
        return false;
    }

    @Specialization
    protected static boolean doBigInt(BigInt operand) {
        return false;
    }

    @Specialization(guards={"isJSObject", "object.getShape() == cachedShape"}, limit="MAX_SHAPE_COUNT")
    protected static boolean doJSObjectCachedShape(DynamicObject object, @Cached(value="isJSType(object)") boolean isJSObject, @Cached(value="object.getShape()") Shape cachedShape) {
        assert (!JSGuards.isNullOrUndefined(object));
        return false;
    }

    @Specialization(guards={"isJSObject", "object.getShape().getObjectType() == cachedType"}, replaces={"doJSObjectCachedShape"}, limit="MAX_TYPE_COUNT")
    protected static boolean doJSObjectCachedType(DynamicObject object, @Cached(value="isJSType(object)") boolean isJSObject, @Cached(value="object.getShape().getObjectType()") ObjectType cachedType) {
        assert (!JSGuards.isNullOrUndefined(object));
        return false;
    }

    @Specialization(guards={"isJSType(object)"}, replaces={"doJSObjectCachedType"})
    protected static boolean doJSObject(DynamicObject object, @Cached(value="createBinaryProfile()") ConditionProfile resultProfile) {
        return resultProfile.profile(!JSRuntime.isObject(object));
    }

    @Specialization(guards={"operand != null", "cachedClass != null", "cachedClass == operand.getClass()"}, limit="MAX_CLASSES")
    protected static boolean doJSValueCached(Object operand, @Cached(value="getNonTruffleObjectClass(operand)") Class<?> cachedClass) {
        return false;
    }

    @Specialization(guards={"isJSType(operand)"}, replaces={"doJSValueCached"})
    protected static boolean doJSValueJSObject(DynamicObject operand) {
        return JSGuards.isNullOrUndefined(operand);
    }

    @Specialization(guards={"!isTruffleObject(operand)"}, replaces={"doJSValueCached"})
    protected static boolean doJSValue(Object operand) {
        return false;
    }

    @Specialization(guards={"isForeignObject(operand)"}, limit="1")
    protected boolean doForeign(Object operand, @CachedLibrary(value="operand") InteropLibrary interop) {
        return interop.isNull(operand);
    }

    public static JSIsNullOrUndefinedNode createFromEquals(JavaScriptNode left, JavaScriptNode right) {
        assert (JSIsNullOrUndefinedNode.isNullOrUndefined(left) || JSIsNullOrUndefinedNode.isNullOrUndefined(right));
        boolean isLeft = JSIsNullOrUndefinedNode.isNullOrUndefined(left);
        JavaScriptNode operand = isLeft ? right : left;
        JavaScriptNode constant = isLeft ? left : right;
        boolean isUndefined = constant instanceof JSConstantNode.JSConstantUndefinedNode;
        return JSIsNullOrUndefinedNodeGen.create(operand, isUndefined, isLeft);
    }

    public static JSIsNullOrUndefinedNode create(JavaScriptNode value) {
        return JSIsNullOrUndefinedNodeGen.create(value, false, false);
    }

    public static JSIsNullOrUndefinedNode create() {
        return JSIsNullOrUndefinedNodeGen.create(null, true, true);
    }

    private static boolean isNullOrUndefined(JavaScriptNode node) {
        return node instanceof JSConstantNode.JSConstantUndefinedNode || node instanceof JSConstantNode.JSConstantNullNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSIsNullOrUndefinedNodeGen.create(JSIsNullOrUndefinedNode.cloneUninitialized(this.getOperand(), materializedTags), this.isUndefined, this.isLeft);
    }
}

