/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsCallableNode.class)
public final class IsCallableNodeGen
extends IsCallableNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private Shape jSFunctionShape_shape_;
    @Node.Child
    private TruffleObject0Data truffleObject0_cache;

    private IsCallableNodeGen() {
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object arg0Value) {
        Object arg0Value_;
        int state = this.state_;
        if ((state & 0xF) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 1) != 0 && this.jSFunctionShape_shape_.check((DynamicObject)arg0Value_)) {
                assert (JSGuards.isJSFunctionShape(this.jSFunctionShape_shape_));
                return IsCallableNode.doJSFunctionShape((DynamicObject)arg0Value_, this.jSFunctionShape_shape_);
            }
            if ((state & 2) != 0 && JSGuards.isJSFunction((DynamicObject)arg0Value_)) {
                return IsCallableNode.doJSFunction((DynamicObject)arg0Value_);
            }
            if ((state & 4) != 0 && JSGuards.isJSProxy((DynamicObject)arg0Value_)) {
                return IsCallableNode.doJSProxy((DynamicObject)arg0Value_);
            }
            if ((state & 8) != 0 && JSGuards.isJSType((DynamicObject)arg0Value_) && !JSGuards.isJSFunction((DynamicObject)arg0Value_) && !JSGuards.isJSProxy((DynamicObject)arg0Value_)) {
                return IsCallableNode.doJSTypeOther((DynamicObject)arg0Value_);
            }
        }
        if ((state & 0x30) != 0) {
            if ((state & 0x10) != 0) {
                TruffleObject0Data s5_ = this.truffleObject0_cache;
                while (s5_ != null) {
                    if (s5_.interop_.accepts(arg0Value) && JSGuards.isForeignObject(arg0Value)) {
                        return IsCallableNode.doTruffleObject(arg0Value, s5_.interop_);
                    }
                    s5_ = s5_.next_;
                }
            }
            if ((state & 0x20) != 0 && JSGuards.isForeignObject(arg0Value)) {
                return this.truffleObject1Boundary(state, arg0Value);
            }
        }
        if ((state & 0x40) != 0 && JSTypesGen.isImplicitCharSequence((state & 0x7800) >>> 11, arg0Value)) {
            arg0Value_ = JSTypesGen.asImplicitCharSequence((state & 0x7800) >>> 11, arg0Value);
            return IsCallableNode.doCharSequence((CharSequence)arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Number) {
            arg0Value_ = (Number)arg0Value;
            return IsCallableNode.doNumber((Number)arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_2 = (Boolean)arg0Value;
            return IsCallableNode.doBoolean(arg0Value_2);
        }
        if ((state & 0x200) != 0 && arg0Value instanceof Symbol) {
            arg0Value_ = (Symbol)arg0Value;
            return IsCallableNode.doSymbol((Symbol)arg0Value_);
        }
        if ((state & 0x400) != 0 && arg0Value instanceof BigInt) {
            arg0Value_ = (BigInt)arg0Value;
            return IsCallableNode.doBigInt((BigInt)arg0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean truffleObject1Boundary(int state, Object arg0Value) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary truffleObject1_interop__ = INTEROP_LIBRARY_.getUncached(arg0Value);
            boolean bl = IsCallableNode.doTruffleObject(arg0Value, truffleObject1_interop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                boolean JSFunctionShape_duplicateFound_;
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((exclude & 1) == 0) {
                    Shape jSFunctionShape_shape__2;
                    JSFunctionShape_duplicateFound_ = false;
                    if ((state & 1) != 0 && this.jSFunctionShape_shape_.check(arg0Value_)) {
                        assert (JSGuards.isJSFunctionShape(this.jSFunctionShape_shape_));
                        JSFunctionShape_duplicateFound_ = true;
                    }
                    if (!JSFunctionShape_duplicateFound_ && (jSFunctionShape_shape__2 = arg0Value_.getShape()).check(arg0Value_) && JSGuards.isJSFunctionShape(jSFunctionShape_shape__2) && (state & 1) == 0) {
                        this.jSFunctionShape_shape_ = jSFunctionShape_shape__2;
                        this.state_ = state |= 1;
                        JSFunctionShape_duplicateFound_ = true;
                    }
                    if (JSFunctionShape_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        boolean jSFunctionShape_shape__2 = IsCallableNode.doJSFunctionShape(arg0Value_, this.jSFunctionShape_shape_);
                        return jSFunctionShape_shape__2;
                    }
                }
                if (JSGuards.isJSFunction(arg0Value_)) {
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    JSFunctionShape_duplicateFound_ = IsCallableNode.doJSFunction(arg0Value_);
                    return JSFunctionShape_duplicateFound_;
                }
                if (JSGuards.isJSProxy(arg0Value_)) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    JSFunctionShape_duplicateFound_ = IsCallableNode.doJSProxy(arg0Value_);
                    return JSFunctionShape_duplicateFound_;
                }
                if (JSGuards.isJSType(arg0Value_) && !JSGuards.isJSFunction(arg0Value_) && !JSGuards.isJSProxy(arg0Value_)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    JSFunctionShape_duplicateFound_ = IsCallableNode.doJSTypeOther(arg0Value_);
                    return JSFunctionShape_duplicateFound_;
                }
            }
            if ((exclude & 2) == 0) {
                int count5_ = 0;
                TruffleObject0Data s5_ = this.truffleObject0_cache;
                if ((state & 0x10) != 0) {
                    while (!(s5_ == null || s5_.interop_.accepts(arg0Value) && JSGuards.isForeignObject(arg0Value))) {
                        s5_ = s5_.next_;
                        ++count5_;
                    }
                }
                if (s5_ == null && JSGuards.isForeignObject(arg0Value) && count5_ < 3) {
                    s5_ = super.insert(new TruffleObject0Data(this.truffleObject0_cache));
                    s5_.interop_ = s5_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                    this.truffleObject0_cache = s5_;
                    this.state_ = state |= 0x10;
                }
                if (s5_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean jSFunctionShape_shape__2 = IsCallableNode.doTruffleObject(arg0Value, s5_.interop_);
                    return jSFunctionShape_shape__2;
                }
            }
            InteropLibrary truffleObject1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                if (JSGuards.isForeignObject(arg0Value)) {
                    truffleObject1_interop__ = INTEROP_LIBRARY_.getUncached(arg0Value);
                    this.exclude_ = exclude |= 2;
                    this.truffleObject0_cache = null;
                    state &= 0xFFFFFFEF;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = IsCallableNode.doTruffleObject(arg0Value, truffleObject1_interop__);
                    return bl;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            int charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(arg0Value);
            if (charSequenceCast0 != 0) {
                CharSequence arg0Value_ = JSTypesGen.asImplicitCharSequence(charSequenceCast0, arg0Value);
                state |= charSequenceCast0 << 11;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                boolean bl = IsCallableNode.doCharSequence(arg0Value_);
                return bl;
            }
            if (arg0Value instanceof Number) {
                Number arg0Value_ = (Number)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                boolean bl = IsCallableNode.doNumber(arg0Value_);
                return bl;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                boolean bl = IsCallableNode.doBoolean(arg0Value_);
                return bl;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol)arg0Value;
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                boolean bl = IsCallableNode.doSymbol(arg0Value_);
                return bl;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt)arg0Value;
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                boolean bl = IsCallableNode.doBigInt(arg0Value_);
                return bl;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        TruffleObject0Data s5_;
        int state = this.state_;
        if ((state & 0x7FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x7FF & (state & 0x7FF) - 1) == 0 && ((s5_ = this.truffleObject0_cache) == null || s5_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[12];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doJSFunctionShape";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.jSFunctionShape_shape_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doJSFunction";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doJSProxy";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doJSTypeOther";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doTruffleObject";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            TruffleObject0Data s5_ = this.truffleObject0_cache;
            while (s5_ != null) {
                cached.add(Arrays.asList(s5_.interop_));
                s5_ = s5_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doTruffleObject";
        if ((state & 0x20) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached()));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doCharSequence";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        return Introspection.Provider.create(data);
    }

    public static IsCallableNode create() {
        return new IsCallableNodeGen();
    }

    public static IsCallableNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=IsCallableNode.class)
    private static final class Uncached
    extends IsCallableNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean executeBoolean(Object arg0Value) {
            Object arg0Value_;
            if (JSTypes.isDynamicObject(arg0Value)) {
                arg0Value_ = (DynamicObject)arg0Value;
                if (JSGuards.isJSFunction((DynamicObject)arg0Value_)) {
                    return IsCallableNode.doJSFunction((DynamicObject)arg0Value_);
                }
                if (JSGuards.isJSProxy((DynamicObject)arg0Value_)) {
                    return IsCallableNode.doJSProxy((DynamicObject)arg0Value_);
                }
                if (JSGuards.isJSType((DynamicObject)arg0Value_) && !JSGuards.isJSFunction((DynamicObject)arg0Value_) && !JSGuards.isJSProxy((DynamicObject)arg0Value_)) {
                    return IsCallableNode.doJSTypeOther((DynamicObject)arg0Value_);
                }
            }
            if (JSGuards.isForeignObject(arg0Value)) {
                return IsCallableNode.doTruffleObject(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
            }
            if (JSTypesGen.isImplicitCharSequence(arg0Value)) {
                arg0Value_ = JSTypesGen.asImplicitCharSequence(arg0Value);
                return IsCallableNode.doCharSequence((CharSequence)arg0Value_);
            }
            if (arg0Value instanceof Number) {
                arg0Value_ = (Number)arg0Value;
                return IsCallableNode.doNumber((Number)arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_2 = (Boolean)arg0Value;
                return IsCallableNode.doBoolean(arg0Value_2);
            }
            if (arg0Value instanceof Symbol) {
                arg0Value_ = (Symbol)arg0Value;
                return IsCallableNode.doSymbol((Symbol)arg0Value_);
            }
            if (arg0Value instanceof BigInt) {
                arg0Value_ = (BigInt)arg0Value;
                return IsCallableNode.doBigInt((BigInt)arg0Value_);
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=IsCallableNode.class)
    private static final class TruffleObject0Data
    extends Node {
        @Node.Child
        TruffleObject0Data next_;
        @Node.Child
        InteropLibrary interop_;

        TruffleObject0Data(TruffleObject0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

