/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.promise.UnwrapPromiseNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.builtins.JSPromise;

@ImportStatic(value={JSPromise.class})
public abstract class UnwrapPromiseNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getPromiseState;
    @Node.Child
    private PropertyGetNode getPromiseResult;
    private static final UnwrapPromiseNode UNCACHED = UnwrapPromiseNode.create(null);

    protected UnwrapPromiseNode(JSContext context) {
        if (context != null) {
            this.getPromiseState = PropertyGetNode.createGetHidden(JSPromise.PROMISE_STATE, context);
            this.getPromiseResult = PropertyGetNode.createGetHidden(JSPromise.PROMISE_RESULT, context);
        }
    }

    public static UnwrapPromiseNode create(JSContext context) {
        return UnwrapPromiseNodeGen.create(context);
    }

    public final Object execute(DynamicObject promise) {
        int promiseState;
        if (this.getPromiseState == null) {
            return this.doUncached(promise);
        }
        try {
            promiseState = this.getPromiseState.getValueInt(promise);
        }
        catch (UnexpectedResultException e) {
            throw Errors.shouldNotReachHere();
        }
        Object promiseResult = this.getPromiseResult.getValue(promise);
        return this.execute(promise, promiseState, promiseResult);
    }

    @CompilerDirectives.TruffleBoundary
    private Object doUncached(DynamicObject promise) {
        return this.execute(promise, (Integer)promise.get(JSPromise.PROMISE_STATE), promise.get(JSPromise.PROMISE_RESULT));
    }

    protected abstract Object execute(DynamicObject var1, int var2, Object var3);

    @Specialization(guards={"promiseState == FULFILLED"})
    protected static Object fulfilled(DynamicObject promise, int promiseState, Object promiseResult) {
        return promiseResult;
    }

    @Specialization(guards={"promiseState == REJECTED"})
    protected static Object rejected(DynamicObject promise, int promiseState, Object promiseResult) {
        throw UserScriptException.create(promiseResult);
    }

    @Specialization(guards={"promiseState == PENDING"})
    protected static Object pending(DynamicObject promise, int promiseState, Object promiseResult) {
        throw Errors.createTypeError("Attempt to unwrap pending promise");
    }

    public static UnwrapPromiseNode getUncached() {
        return UNCACHED;
    }
}

