/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class ToDateTimeOptionsNode
extends JavaScriptBaseNode {
    @Node.Child
    JSToObjectNode toObjectNode;
    private final JSContext context;

    public JSContext getContext() {
        return this.context;
    }

    public ToDateTimeOptionsNode(JSContext context) {
        this.context = context;
    }

    public abstract DynamicObject execute(Object var1, String var2, String var3);

    @Specialization(guards={"isUndefined(opts)"})
    public DynamicObject fromUndefined(Object opts, String required, String defaults) {
        return ToDateTimeOptionsNode.setDefaultsIfNeeded(JSUserObject.createWithNullPrototype(this.getContext()), required, defaults);
    }

    @Specialization(guards={"!isUndefined(opts)"})
    public DynamicObject fromOtherThenUndefined(Object opts, String required, String defaults) {
        return ToDateTimeOptionsNode.setDefaultsIfNeeded(JSUserObject.createWithPrototype(this.toDynamicObject(opts), this.getContext()), required, defaults);
    }

    private static DynamicObject setDefaultsIfNeeded(DynamicObject options, String required, String defaults) {
        boolean needDefaults = true;
        if (required != null) {
            if (required.equals("date") || required.equals("any")) {
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, (Object)"weekday"));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, (Object)"year"));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, (Object)"month"));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, (Object)"day"));
            }
            if (required.equals("time") || required.equals("any")) {
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, (Object)"hour"));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, (Object)"minute"));
                needDefaults &= JSGuards.isUndefined(JSObject.get(options, (Object)"second"));
            }
        }
        if (defaults != null) {
            if (needDefaults && (defaults.equals("date") || defaults.equals("all"))) {
                JSRuntime.createDataPropertyOrThrow(options, "year", "numeric");
                JSRuntime.createDataPropertyOrThrow(options, "month", "numeric");
                JSRuntime.createDataPropertyOrThrow(options, "day", "numeric");
            }
            if (needDefaults && (defaults.equals("time") || defaults.equals("all"))) {
                JSRuntime.createDataPropertyOrThrow(options, "hour", "numeric");
                JSRuntime.createDataPropertyOrThrow(options, "minute", "numeric");
                JSRuntime.createDataPropertyOrThrow(options, "second", "numeric");
            }
        }
        return options;
    }

    private DynamicObject toDynamicObject(Object o) {
        if (this.toObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toObjectNode = this.insert(JSToObjectNode.createToObject(this.getContext()));
        }
        return (DynamicObject)this.toObjectNode.execute(o);
    }
}

