/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;

@GeneratedBy(value=KeyInfoNode.class)
public final class KeyInfoNodeGen
extends KeyInfoNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_;

    private KeyInfoNodeGen() {
    }

    @Override
    public boolean execute(DynamicObject arg0Value, String arg1Value, int arg2Value) {
        int state = this.state_;
        if ((state & 1) != 0) {
            return KeyInfoNode.member(arg0Value, arg1Value, arg2Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    @Override
    public boolean execute(DynamicObject arg0Value, long arg1Value, int arg2Value) {
        int state = this.state_;
        if ((state & 2) != 0) {
            return KeyInfoNode.element(arg0Value, arg1Value, arg2Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private boolean executeAndSpecialize(DynamicObject arg0Value, Object arg1Value, int arg2Value) {
        int state = this.state_;
        int stringCast1 = JSTypesGen.specializeImplicitString(arg1Value);
        if (stringCast1 != 0) {
            String arg1Value_ = JSTypesGen.asImplicitString(stringCast1, arg1Value);
            state |= stringCast1 << 2;
            this.state_ = state |= 1;
            return KeyInfoNode.member(arg0Value, arg1Value_, arg2Value);
        }
        if (arg1Value instanceof Long) {
            long arg1Value_ = (Long)arg1Value;
            this.state_ = state |= 2;
            return KeyInfoNode.element(arg0Value, arg1Value_, arg2Value);
        }
        throw new UnsupportedSpecializationException(this, new Node[]{null, null, null}, arg0Value, arg1Value, arg2Value);
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 3) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 3 & (state & 3) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "member";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "element";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        return Introspection.Provider.create(data);
    }

    public static KeyInfoNode create() {
        return new KeyInfoNodeGen();
    }

    public static KeyInfoNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=KeyInfoNode.class)
    private static final class Uncached
    extends KeyInfoNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean execute(DynamicObject arg0Value, String arg1Value, int arg2Value) {
            return KeyInfoNode.member(arg0Value, arg1Value, arg2Value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean execute(DynamicObject arg0Value, long arg1Value, int arg2Value) {
            return KeyInfoNode.element(arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }
    }
}

