/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.function.DefineMethodNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=DefineMethodNode.class)
public final class DefineMethodNodeFactory {

    @GeneratedBy(value=DefineMethodNode.FunctionCreateNode.class)
    protected static final class FunctionCreateNodeGen
    extends DefineMethodNode.FunctionCreateNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;
        @CompilerDirectives.CompilationFinal
        private JSFunctionFactory multiContext_factory_;

        private FunctionCreateNodeGen(JSContext context, JSFunctionData functionData) {
            super(context, functionData);
        }

        @Override
        @ExplodeLoop
        public DynamicObject executeWithPrototype(VirtualFrame frameValue, Object arg0Value) {
            int state = this.state_;
            if ((state & 7) != 0 && JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((state & 1) != 0) {
                    assert (!this.getContext().isMultiContext());
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg0Value_ == s1_.cachedPrototype_) {
                            assert (JSGuards.isJSObject(s1_.cachedPrototype_));
                            return this.doCached(frameValue, arg0Value_, s1_.cachedPrototype_, s1_.factory_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    assert (!this.getContext().isMultiContext());
                    if (JSGuards.isJSObject(arg0Value_)) {
                        return this.doUncached(frameValue, arg0Value_);
                    }
                }
                if ((state & 4) != 0) {
                    assert (this.getContext().isMultiContext());
                    if (JSGuards.isJSObject(arg0Value_)) {
                        return this.doMultiContext(frameValue, arg0Value_, this.multiContext_factory_);
                    }
                }
            }
            if ((state & 8) != 0 && !JSGuards.isJSObject(arg0Value)) {
                return this.doNonObject(arg0Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value);
        }

        private DynamicObject executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (JSTypes.isDynamicObject(arg0Value)) {
                    DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                    if (exclude == 0 && !this.getContext().isMultiContext()) {
                        DynamicObject cachedPrototype__;
                        int count1_ = 0;
                        CachedData s1_ = this.cached_cache;
                        if ((state & 1) != 0) {
                            while (s1_ != null) {
                                if (arg0Value_ == s1_.cachedPrototype_) {
                                    assert (JSGuards.isJSObject(s1_.cachedPrototype_));
                                    break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && JSGuards.isJSObject(cachedPrototype__ = arg0Value_) && count1_ < this.getContext().getPropertyCacheLimit()) {
                            s1_ = new CachedData(this.cached_cache);
                            s1_.cachedPrototype_ = cachedPrototype__;
                            s1_.factory_ = this.makeFactory(arg0Value_);
                            this.cached_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.doCached(frameValue, arg0Value_, s1_.cachedPrototype_, s1_.factory_);
                            return dynamicObject;
                        }
                    }
                    if (!this.getContext().isMultiContext() && JSGuards.isJSObject(arg0Value_)) {
                        this.exclude_ = exclude |= 1;
                        this.cached_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.doUncached(frameValue, arg0Value_);
                        return dynamicObject;
                    }
                    if (this.getContext().isMultiContext() && JSGuards.isJSObject(arg0Value_)) {
                        this.multiContext_factory_ = this.makeFactoryMultiContext();
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.doMultiContext(frameValue, arg0Value_, this.multiContext_factory_);
                        return dynamicObject;
                    }
                }
                if (!JSGuards.isJSObject(arg0Value)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doNonObject(arg0Value);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedPrototype_, s1_.factory_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doUncached";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "doMultiContext";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.multiContext_factory_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "doNonObject";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create(data);
        }

        public static DefineMethodNode.FunctionCreateNode create(JSContext context, JSFunctionData functionData) {
            return new FunctionCreateNodeGen(context, functionData);
        }

        @GeneratedBy(value=DefineMethodNode.FunctionCreateNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            DynamicObject cachedPrototype_;
            @CompilerDirectives.CompilationFinal
            JSFunctionFactory factory_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }
}

