/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.control.AbstractRepeatingNode;
import com.oracle.truffle.js.nodes.control.DiscardResultNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.IterationScopeNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTaggedExecutionNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import java.util.Set;

@NodeInfo(shortName="for")
public final class ForNode
extends StatementNode
implements ResumableNode {
    @Node.Child
    private LoopNode loop;
    @Node.Child
    private IterationScopeNode copy;

    private ForNode(RepeatingNode repeatingNode, IterationScopeNode copy) {
        this.copy = copy;
        this.loop = Truffle.getRuntime().createLoopNode(repeatingNode);
    }

    public static ForNode createFor(JavaScriptNode condition, JavaScriptNode body, JavaScriptNode modify, IterationScopeNode copy, JavaScriptNode isFirstNode, JavaScriptNode setNotFirstNode) {
        JavaScriptNode nonVoidBody = body instanceof DiscardResultNode ? ((DiscardResultNode)body).getOperand() : body;
        return new ForNode(new ForRepeatingNode(condition, nonVoidBody, modify, copy, isFirstNode, setNotFirstNode), NodeUtil.cloneNode(copy));
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ControlFlowRootTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowRootTag.Type.ForIteration.name());
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (ForNode.hasMaterializationTag(materializedTags) && AbstractRepeatingNode.materializationNeeded(this.loop.getRepeatingNode())) {
            IterationScopeNode newCopy = ForNode.cloneUninitialized(this.copy, materializedTags);
            AbstractRepeatingNode materializedLoop = (AbstractRepeatingNode)((AbstractRepeatingNode)this.loop.getRepeatingNode()).materializeInstrumentableNodes(materializedTags);
            if (materializedLoop == this.loop.getRepeatingNode()) {
                materializedLoop = ForNode.cloneUninitialized((AbstractRepeatingNode)this.loop.getRepeatingNode(), materializedTags);
            }
            ForNode.transferSourceSection(this, materializedLoop.bodyNode);
            ForNode materializedNode = new ForNode(materializedLoop, newCopy);
            ForNode.transferSourceSectionAndTags(this, materializedNode);
            return materializedNode;
        }
        return this;
    }

    private static boolean hasMaterializationTag(Set<Class<? extends Tag>> materializedTags) {
        return materializedTags.contains(JSTags.ControlFlowRootTag.class) || materializedTags.contains(JSTags.ControlFlowBlockTag.class) || materializedTags.contains(JSTags.ControlFlowBranchTag.class);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.executeVoid(frame);
        return EMPTY;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.loop.execute(this.copy.execute(frame));
    }

    @Override
    public Object resume(VirtualFrame frame) {
        Object state = this.getStateAndReset(frame);
        MaterializedFrame loopFrame = state == Undefined.instance ? this.copy.execute(frame).materialize() : JSFrameUtil.castMaterializedFrame(state);
        try {
            this.loop.execute(loopFrame);
        }
        catch (YieldException e) {
            this.setState(frame, loopFrame);
            throw e;
        }
        return EMPTY;
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        assert (EMPTY == Undefined.instance);
        return clazz == Undefined.class;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new ForNode((RepeatingNode)((Object)ForNode.cloneUninitialized((JavaScriptNode)((Object)this.loop.getRepeatingNode()), materializedTags)), ForNode.cloneUninitialized(this.copy, materializedTags));
    }

    public LoopNode getLoopNode() {
        return this.loop;
    }

    private static final class ForRepeatingNode
    extends AbstractRepeatingNode {
        @Node.Child
        private JavaScriptNode modify;
        @Node.Child
        private IterationScopeNode copy;
        @Node.Child
        private JavaScriptNode isFirstNode;
        @Node.Child
        private JavaScriptNode setNotFirstNode;

        ForRepeatingNode(JavaScriptNode condition, JavaScriptNode body, JavaScriptNode modify, IterationScopeNode copy, JavaScriptNode isFirstNode, JavaScriptNode setNotFirstNode) {
            super(condition, body);
            this.modify = modify;
            this.copy = copy;
            this.isFirstNode = isFirstNode;
            this.setNotFirstNode = setNotFirstNode;
        }

        @Override
        public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
            if (ForNode.hasMaterializationTag(materializedTags) && this.materializationNeeded()) {
                JavaScriptNode newBody = JSTaggedExecutionNode.createFor(this.bodyNode, JSTags.ControlFlowBlockTag.class, materializedTags);
                JavaScriptNode newCondition = JSTaggedExecutionNode.createForInput(this.conditionNode, JSTags.ControlFlowBranchTag.class, JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowBranchTag.Type.Condition.name()), materializedTags);
                if (newBody == this.bodyNode && newCondition == this.conditionNode) {
                    return this;
                }
                if (newBody == this.bodyNode) {
                    newBody = ForRepeatingNode.cloneUninitialized(this.bodyNode, materializedTags);
                }
                if (newCondition == this.conditionNode) {
                    newCondition = ForRepeatingNode.cloneUninitialized(this.conditionNode, materializedTags);
                }
                ForRepeatingNode newLoop = new ForRepeatingNode(newCondition, newBody, ForRepeatingNode.cloneUninitialized(this.modify, materializedTags), ForRepeatingNode.cloneUninitialized(this.copy, materializedTags), this.isFirstNode, ForRepeatingNode.cloneUninitialized(this.setNotFirstNode, materializedTags));
                ForRepeatingNode.transferSourceSectionAndTags(this, newLoop);
                return newLoop;
            }
            return this;
        }

        private boolean materializationNeeded() {
            return !JSNodeUtil.isTaggedNode(this.bodyNode);
        }

        @Override
        public boolean executeRepeating(VirtualFrame frame) {
            VirtualFrame iterationFrame = this.copy.execute(frame);
            if (this.notFirstIteration(frame)) {
                this.modify.executeVoid(iterationFrame);
            }
            if (this.executeCondition(iterationFrame)) {
                this.executeBody(iterationFrame);
                this.copy.executeCopy(frame, iterationFrame);
                return true;
            }
            return false;
        }

        private boolean notFirstIteration(VirtualFrame frame) {
            if (StatementNode.executeConditionAsBoolean(frame, this.isFirstNode)) {
                this.setNotFirstNode.executeVoid(frame);
                return false;
            }
            return true;
        }

        @Override
        public Object resume(VirtualFrame frame) {
            int index;
            MaterializedFrame iterationFrame;
            Object state = this.getStateAndReset(frame);
            if (state == Undefined.instance) {
                iterationFrame = this.copy.execute(frame).materialize();
                index = 0;
            } else {
                Pair statePair = (Pair)state;
                iterationFrame = JSFrameUtil.castMaterializedFrame(statePair.getFirst());
                index = (Integer)statePair.getSecond();
            }
            if (index <= 0 && this.notFirstIteration(frame)) {
                try {
                    this.modify.executeVoid(iterationFrame);
                }
                catch (YieldException e) {
                    this.setState(frame, new Pair<MaterializedFrame, Integer>(iterationFrame, 0));
                    throw e;
                }
            }
            boolean condition = true;
            if (index <= 1) {
                try {
                    condition = this.executeConditionNoProfile(iterationFrame);
                }
                catch (YieldException e) {
                    this.setState(frame, new Pair<MaterializedFrame, Integer>(iterationFrame, 1));
                    throw e;
                }
            }
            if (condition) {
                try {
                    this.executeBody(iterationFrame);
                }
                catch (YieldException e) {
                    this.setState(frame, new Pair<MaterializedFrame, Integer>(iterationFrame, 2));
                    throw e;
                }
                this.copy.executeCopy(frame, iterationFrame);
                return true;
            }
            return false;
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ForRepeatingNode(ForRepeatingNode.cloneUninitialized(this.conditionNode, materializedTags), ForRepeatingNode.cloneUninitialized(this.bodyNode, materializedTags), ForRepeatingNode.cloneUninitialized(this.modify, materializedTags), ForRepeatingNode.cloneUninitialized(this.copy, materializedTags), ForRepeatingNode.cloneUninitialized(this.isFirstNode, materializedTags), ForRepeatingNode.cloneUninitialized(this.setNotFirstNode, materializedTags));
        }
    }
}

