/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.DualNode;
import com.oracle.truffle.js.nodes.control.DiscardResultNode;
import com.oracle.truffle.js.nodes.control.EmptyNode;
import com.oracle.truffle.js.nodes.control.ExprBlockNode;
import com.oracle.truffle.js.nodes.control.SequenceNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.control.VoidBlockNode;
import java.util.ArrayList;
import java.util.Arrays;

@NodeInfo(cost=NodeCost.NONE)
public abstract class AbstractBlockNode
extends StatementNode
implements SequenceNode,
BlockNode.ElementExecutor<JavaScriptNode> {
    @Node.Children
    protected final JavaScriptNode[] statements;

    protected AbstractBlockNode(JavaScriptNode[] statements) {
        this.statements = statements;
    }

    @Override
    public final JavaScriptNode[] getStatements() {
        return this.statements;
    }

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame) {
        JavaScriptNode[] stmts = this.statements;
        for (int i = 0; i < stmts.length; ++i) {
            this.executeVoid(frame, stmts[i], i, 0);
        }
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        JavaScriptNode[] stmts = this.statements;
        int last = stmts.length - 1;
        for (int i = 0; i < last; ++i) {
            this.executeVoid(frame, stmts[i], i, 0);
        }
        return this.executeGeneric(frame, stmts[last], last, 0);
    }

    @Override
    public void executeVoid(VirtualFrame frame, JavaScriptNode node, int index, int argument) {
        node.executeVoid(frame);
    }

    @Override
    public Object executeGeneric(VirtualFrame frame, JavaScriptNode node, int index, int argument) {
        return node.execute(frame);
    }

    protected static JavaScriptNode filterStatements(JavaScriptNode[] originalStatements, boolean exprBlock) {
        JavaScriptNode[] finalStatements;
        ArrayList<JavaScriptNode> filteredStatements = null;
        boolean returnExprBlock = exprBlock;
        for (int i = 0; i < originalStatements.length; ++i) {
            JavaScriptNode statement = originalStatements[i];
            if ((statement instanceof EmptyNode || statement instanceof AbstractBlockNode || statement instanceof DiscardResultNode || statement instanceof JSConstantNode.JSConstantUndefinedNode) && !statement.hasTag(StandardTags.RootBodyTag.class)) {
                if (filteredStatements == null) {
                    filteredStatements = AbstractBlockNode.newListFromRange(originalStatements, 0, i);
                }
                if (statement instanceof AbstractBlockNode) {
                    filteredStatements.addAll(Arrays.asList(((AbstractBlockNode)statement).getStatements()));
                } else if (statement instanceof DiscardResultNode) {
                    DiscardResultNode voidNode = (DiscardResultNode)statement;
                    filteredStatements.add(voidNode.getOperand());
                    AbstractBlockNode.transferSourceSectionAndTags(statement, voidNode.getOperand());
                } else assert (statement instanceof EmptyNode || statement instanceof JSConstantNode.JSConstantUndefinedNode);
                if (!exprBlock || i != originalStatements.length - 1 || statement instanceof ExprBlockNode || statement instanceof EmptyNode) continue;
                returnExprBlock = false;
                continue;
            }
            if (filteredStatements == null) continue;
            filteredStatements.add(statement);
        }
        JavaScriptNode[] javaScriptNodeArray = finalStatements = filteredStatements == null ? originalStatements : filteredStatements.toArray(new JavaScriptNode[filteredStatements.size()]);
        if (returnExprBlock) {
            if (finalStatements.length == 0) {
                return EmptyNode.create();
            }
            if (finalStatements.length == 1) {
                return finalStatements[0];
            }
            if (finalStatements.length == 2) {
                return DualNode.create(finalStatements[0], finalStatements[1]);
            }
            return new ExprBlockNode(finalStatements);
        }
        if (finalStatements.length == 0) {
            return EmptyNode.create();
        }
        if (finalStatements.length == 1) {
            return DiscardResultNode.create(finalStatements[0]);
        }
        return new VoidBlockNode(finalStatements);
    }

    protected static ArrayList<JavaScriptNode> newListFromRange(JavaScriptNode[] statements, int from, int to) {
        return new ArrayList<JavaScriptNode>(Arrays.asList(statements).subList(from, to));
    }
}

