/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;

public class OrdinaryToPrimitiveNode
extends JavaScriptBaseNode {
    private final JSToPrimitiveNode.Hint hint;
    private final JSContext context;
    private final ConditionProfile toStringFunctionProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile valueOfFunctionProfile = ConditionProfile.createBinaryProfile();
    @Node.Child
    private PropertyNode getToStringNode;
    @Node.Child
    private PropertyNode getValueOfNode;
    @Node.Child
    private IsCallableNode isCallableNode;
    @Node.Child
    private JSFunctionCallNode callToStringNode;
    @Node.Child
    private JSFunctionCallNode callValueOfNode;
    @Node.Child
    private IsPrimitiveNode isPrimitiveNode;

    protected OrdinaryToPrimitiveNode(JSContext context, JSToPrimitiveNode.Hint hint) {
        assert (hint == JSToPrimitiveNode.Hint.String || hint == JSToPrimitiveNode.Hint.Number);
        this.hint = hint;
        this.context = context;
        this.isCallableNode = IsCallableNode.create();
        this.isPrimitiveNode = IsPrimitiveNode.create();
    }

    public Object execute(DynamicObject object) {
        assert (JSGuards.isJSObject(object));
        if (this.hint == JSToPrimitiveNode.Hint.String) {
            return this.doHintString(object);
        }
        assert (this.hint == JSToPrimitiveNode.Hint.Number);
        return this.doHintNumber(object);
    }

    public static OrdinaryToPrimitiveNode createHintString(JSContext context) {
        return OrdinaryToPrimitiveNode.create(context, JSToPrimitiveNode.Hint.String);
    }

    public static OrdinaryToPrimitiveNode createHintNumber(JSContext context) {
        return OrdinaryToPrimitiveNode.create(context, JSToPrimitiveNode.Hint.Number);
    }

    public static OrdinaryToPrimitiveNode create(JSContext context, JSToPrimitiveNode.Hint hint) {
        return new OrdinaryToPrimitiveNode(context, hint);
    }

    protected Object doHintString(DynamicObject object) {
        Object result;
        Object result2;
        Object toString = this.getToString().executeWithTarget(object);
        if (this.toStringFunctionProfile.profile(this.isCallableNode.executeBoolean(toString)) && this.isPrimitiveNode.executeBoolean(result2 = this.callToStringNode.executeCall(JSArguments.createZeroArg(object, toString)))) {
            return result2;
        }
        Object valueOf = this.getValueOf().executeWithTarget(object);
        if (this.valueOfFunctionProfile.profile(this.isCallableNode.executeBoolean(valueOf)) && this.isPrimitiveNode.executeBoolean(result = this.callValueOfNode.executeCall(JSArguments.createZeroArg(object, valueOf)))) {
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    protected Object doHintNumber(DynamicObject object) {
        Object result;
        Object result2;
        assert (JSGuards.isJSObject(object));
        Object valueOf = this.getValueOf().executeWithTarget(object);
        if (this.valueOfFunctionProfile.profile(this.isCallableNode.executeBoolean(valueOf)) && this.isPrimitiveNode.executeBoolean(result2 = this.callValueOfNode.executeCall(JSArguments.createZeroArg(object, valueOf)))) {
            return result2;
        }
        Object toString = this.getToString().executeWithTarget(object);
        if (this.toStringFunctionProfile.profile(this.isCallableNode.executeBoolean(toString)) && this.isPrimitiveNode.executeBoolean(result = this.callToStringNode.executeCall(JSArguments.createZeroArg(object, toString)))) {
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    private PropertyNode getToString() {
        if (this.getToStringNode == null || this.callToStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getToStringNode = this.insert(PropertyNode.createMethod(this.context, null, "toString"));
            this.callToStringNode = this.insert(JSFunctionCallNode.createCall());
        }
        return this.getToStringNode;
    }

    private PropertyNode getValueOf() {
        if (this.getValueOfNode == null || this.callValueOfNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getValueOfNode = this.insert(PropertyNode.createMethod(this.context, null, "valueOf"));
            this.callValueOfNode = this.insert(JSFunctionCallNode.createCall());
        }
        return this.getValueOfNode;
    }
}

