/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSDoubleToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

@ImportStatic(value={JSObject.class})
public abstract class JSToStringNode
extends JavaScriptBaseNode {
    protected static final int MAX_CLASSES = 3;
    final boolean undefinedToEmpty;
    final boolean symbolToString;
    @Node.Child
    private JSToStringNode toStringNode;

    protected JSToStringNode(boolean undefinedToEmpty, boolean symbolToString) {
        this.undefinedToEmpty = undefinedToEmpty;
        this.symbolToString = symbolToString;
    }

    public static JSToStringNode create() {
        return JSToStringNodeGen.create(false, false);
    }

    public static JSToStringNode createUndefinedToEmpty() {
        return JSToStringNodeGen.create(true, false);
    }

    public static JSToStringNode createSymbolToString() {
        return JSToStringNodeGen.create(false, true);
    }

    public abstract String executeString(Object var1);

    @Specialization
    protected String doLazyString(JSLazyString value, @Cached(value="createBinaryProfile()") ConditionProfile flattenProfile) {
        return value.toString(flattenProfile);
    }

    @Specialization
    protected String doString(String value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected String doNull(Object value) {
        return "null";
    }

    @Specialization(guards={"isUndefined(value)"})
    protected String doUndefined(Object value) {
        return this.undefinedToEmpty ? "" : "undefined";
    }

    @Specialization
    protected String doBoolean(boolean value) {
        return JSRuntime.booleanToString(value);
    }

    @Specialization
    protected String doInteger(int value) {
        return Boundaries.stringValueOf(value);
    }

    @Specialization
    protected String doBigInt(BigInt value) {
        return Boundaries.stringValueOf(value);
    }

    @Specialization
    protected String doLong(long value) {
        return Boundaries.stringValueOf(value);
    }

    @Specialization
    protected String doDouble(double d, @Cached(value="create()") JSDoubleToStringNode doubleToStringNode) {
        return doubleToStringNode.executeString(d);
    }

    @Specialization(guards={"isJSObject(value)"}, replaces={"doUndefined"})
    protected String doJSObject(DynamicObject value, @Cached(value="createHintString()") JSToPrimitiveNode toPrimitiveHintStringNode) {
        return this.undefinedToEmpty && value == Undefined.instance ? "" : this.getToStringNode().executeString(toPrimitiveHintStringNode.execute(value));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected String doSymbol(Symbol value) {
        if (this.symbolToString) {
            return value.toString();
        }
        throw Errors.createTypeErrorCannotConvertToString("a Symbol value", this);
    }

    @Specialization(guards={"isForeignObject(object)"})
    protected String doTruffleObject(Object object, @Cached(value="createHintString()") JSToPrimitiveNode toPrimitiveNode) {
        return this.getToStringNode().executeString(toPrimitiveNode.execute(object));
    }

    protected JSToStringNode getToStringNode() {
        if (this.toStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toStringNode = this.insert(JSToStringNode.create());
        }
        return this.toStringNode;
    }

    public static abstract class JSToStringWrapperNode
    extends JSUnaryNode {
        @Node.Child
        private JSToStringNode toStringNode;

        protected JSToStringWrapperNode(JavaScriptNode operand) {
            super(operand);
        }

        public static JSToStringWrapperNode create(JavaScriptNode child) {
            return JSToStringNodeGen.JSToStringWrapperNodeGen.create(child);
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == String.class;
        }

        @Specialization
        protected String doDefault(Object value) {
            if (this.toStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStringNode = this.insert(JSToStringNode.create());
            }
            return this.toStringNode.executeString(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return JSToStringNodeGen.JSToStringWrapperNodeGen.create(JSToStringWrapperNode.cloneUninitialized(this.getOperand(), materializedTags));
        }
    }
}

