/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectArrayNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToObjectArrayNode.class)
public final class JSToObjectArrayNodeGen
extends JSToObjectArrayNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private JSGetLengthNode toArray_getLengthNode_;
    @Node.Child
    private ReadElementNode toArray_readNode_;
    @Node.Child
    private ForeignObject0Data foreignObject0_cache;
    @CompilerDirectives.CompilationFinal
    private BranchProfile foreignObject1_hasPropertiesBranch_;
    @Node.Child
    private ImportValueNode foreignObject1_foreignConvertNode_;

    private JSToObjectArrayNodeGen(JSContext context, boolean nullOrUndefinedAsEmptyArray) {
        super(context, nullOrUndefinedAsEmptyArray);
    }

    @Override
    @ExplodeLoop
    public Object[] executeObjectArray(Object arg0Value) {
        Object[] arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject((DynamicObject)(arg0Value_ = (DynamicObject)arg0Value))) {
            return this.toArray((DynamicObject)arg0Value_, this.toArray_getLengthNode_, this.toArray_readNode_);
        }
        if ((state & 6) != 0) {
            if ((state & 2) != 0 && JSGuards.isUndefined(arg0Value)) {
                return this.doUndefined(arg0Value);
            }
            if ((state & 4) != 0 && JSGuards.isJSNull(arg0Value)) {
                return this.doNull(arg0Value);
            }
        }
        if ((state & 8) != 0 && JSTypesGen.isImplicitCharSequence((state & 0xF000) >>> 12, arg0Value)) {
            arg0Value_ = JSTypesGen.asImplicitCharSequence((state & 0xF000) >>> 12, arg0Value);
            return this.toArrayString((CharSequence)arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            return this.toArrayInt(arg0Value_2);
        }
        if ((state & 0x20) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0000) >>> 16, arg0Value)) {
            double arg0Value_3 = JSTypesGen.asImplicitDouble((state & 0xF0000) >>> 16, arg0Value);
            return this.toArrayDouble(arg0Value_3);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_4 = (Boolean)arg0Value;
            return this.toArrayBoolean(arg0Value_4);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Object[]) {
            arg0Value_ = (Object[])arg0Value;
            return this.passArray(arg0Value_);
        }
        if ((state & 0xF00) != 0) {
            if ((state & 0x100) != 0 && JSGuards.isList(arg0Value)) {
                return this.doList(arg0Value);
            }
            if ((state & 0x200) != 0) {
                ForeignObject0Data s10_ = this.foreignObject0_cache;
                while (s10_ != null) {
                    if (s10_.interop_.accepts(arg0Value) && JSGuards.isForeignObject(arg0Value)) {
                        return this.doForeignObject(arg0Value, s10_.interop_, s10_.hasPropertiesBranch_, s10_.foreignConvertNode_);
                    }
                    s10_ = s10_.next_;
                }
            }
            if ((state & 0x400) != 0 && JSGuards.isForeignObject(arg0Value)) {
                return this.foreignObject1Boundary(state, arg0Value);
            }
            if ((state & 0x800) != 0 && JSToObjectArrayNodeGen.fallbackGuard_(state, arg0Value)) {
                return this.doFallback(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object[] foreignObject1Boundary(int state, Object arg0Value) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            InteropLibrary foreignObject1_interop__ = INTEROP_LIBRARY_.getUncached(arg0Value);
            Object[] objectArray = this.doForeignObject(arg0Value, foreignObject1_interop__, this.foreignObject1_hasPropertiesBranch_, this.foreignObject1_foreignConvertNode_);
            return objectArray;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Object[] executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            DynamicObject dynamicObject;
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(dynamicObject = (DynamicObject)arg0Value)) {
                this.toArray_getLengthNode_ = super.insert(JSGetLengthNode.create(this.context));
                this.toArray_readNode_ = super.insert(ReadElementNode.create(this.context));
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object[] objectArray = this.toArray(dynamicObject, this.toArray_getLengthNode_, this.toArray_readNode_);
                return objectArray;
            }
            if (JSGuards.isUndefined(arg0Value)) {
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Object[] objectArray = this.doUndefined(arg0Value);
                return objectArray;
            }
            if (JSGuards.isJSNull(arg0Value)) {
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object[] objectArray = this.doNull(arg0Value);
                return objectArray;
            }
            int n = JSTypesGen.specializeImplicitCharSequence(arg0Value);
            if (n != 0) {
                CharSequence arg0Value_3 = JSTypesGen.asImplicitCharSequence(n, arg0Value);
                state |= n << 12;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Object[] objectArray = this.toArrayString(arg0Value_3);
                return objectArray;
            }
            if (arg0Value instanceof Integer) {
                int objectArray = (Integer)arg0Value;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Object[] arg0Value_3 = this.toArrayInt(objectArray);
                return arg0Value_3;
            }
            int n2 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (n2 != 0) {
                double arg0Value_4 = JSTypesGen.asImplicitDouble(n2, arg0Value);
                state |= n2 << 16;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                Object[] objectArray = this.toArrayDouble(arg0Value_4);
                return objectArray;
            }
            if (arg0Value instanceof Boolean) {
                boolean bl = (Boolean)arg0Value;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Object[] arg0Value_4 = this.toArrayBoolean(bl);
                return arg0Value_4;
            }
            if (arg0Value instanceof Object[]) {
                Object[] objectArray = (Object[])arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                Object[] arg0Value_4 = this.passArray(objectArray);
                return arg0Value_4;
            }
            if (JSGuards.isList(arg0Value)) {
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Object[] objectArray = this.doList(arg0Value);
                return objectArray;
            }
            if (exclude == 0) {
                void var6_16;
                boolean bl = false;
                ForeignObject0Data s10_ = this.foreignObject0_cache;
                if ((state & 0x200) != 0) {
                    while (!(s10_ == null || s10_.interop_.accepts(arg0Value) && JSGuards.isForeignObject(arg0Value))) {
                        s10_ = s10_.next_;
                        ++var6_16;
                    }
                }
                if (s10_ == null && JSGuards.isForeignObject(arg0Value) && var6_16 < 5) {
                    s10_ = super.insert(new ForeignObject0Data(this.foreignObject0_cache));
                    s10_.interop_ = s10_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                    s10_.hasPropertiesBranch_ = BranchProfile.create();
                    s10_.foreignConvertNode_ = s10_.insertAccessor(ImportValueNode.create());
                    this.foreignObject0_cache = s10_;
                    this.state_ = state |= 0x200;
                }
                if (s10_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object[] objectArray = this.doForeignObject(arg0Value, s10_.interop_, s10_.hasPropertiesBranch_, s10_.foreignConvertNode_);
                    return objectArray;
                }
            }
            Object var6_17 = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                if (JSGuards.isForeignObject(arg0Value)) {
                    InteropLibrary interopLibrary = INTEROP_LIBRARY_.getUncached(arg0Value);
                    this.foreignObject1_hasPropertiesBranch_ = BranchProfile.create();
                    this.foreignObject1_foreignConvertNode_ = super.insert(ImportValueNode.create());
                    this.exclude_ = exclude |= 1;
                    this.foreignObject0_cache = null;
                    state &= 0xFFFFFDFF;
                    this.state_ = state |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    Object[] objectArray = this.doForeignObject(arg0Value, interopLibrary, this.foreignObject1_hasPropertiesBranch_, this.foreignObject1_foreignConvertNode_);
                    return objectArray;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            this.state_ = state |= 0x800;
            lock.unlock();
            hasLock = false;
            Object[] objectArray = this.doFallback(arg0Value);
            return objectArray;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        ForeignObject0Data s10_;
        int state = this.state_;
        if ((state & 0xFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0xFFF & (state & 0xFFF) - 1) == 0 && ((s10_ = this.foreignObject0_cache) == null || s10_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Cloneable>> cached;
        Object[] data = new Object[13];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "toArray";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Cloneable>>();
            cached.add(Arrays.asList(this.toArray_getLengthNode_, this.toArray_readNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "toArrayString";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "toArrayInt";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "toArrayDouble";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "toArrayBoolean";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "passArray";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doList";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x200) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            ForeignObject0Data s10_ = this.foreignObject0_cache;
            while (s10_ != null) {
                cached.add(Arrays.asList(s10_.interop_, s10_.hasPropertiesBranch_, s10_.foreignConvertNode_));
                s10_ = s10_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x400) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached(), this.foreignObject1_hasPropertiesBranch_, this.foreignObject1_foreignConvertNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doFallback";
        s[1] = (state & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        return Introspection.Provider.create(data);
    }

    private static boolean fallbackGuard_(int state, Object arg0Value) {
        DynamicObject arg0Value_;
        if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
            return false;
        }
        if ((state & 2) == 0 && JSGuards.isUndefined(arg0Value)) {
            return false;
        }
        if ((state & 4) == 0 && JSGuards.isJSNull(arg0Value)) {
            return false;
        }
        if (JSTypesGen.isImplicitCharSequence(arg0Value)) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        if ((state & 0x40) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if ((state & 0x80) == 0 && arg0Value instanceof Object[]) {
            return false;
        }
        if ((state & 0x100) == 0 && JSGuards.isList(arg0Value)) {
            return false;
        }
        return (state & 0x400) != 0 || !JSGuards.isForeignObject(arg0Value);
    }

    public static JSToObjectArrayNode create(JSContext context, boolean nullOrUndefinedAsEmptyArray) {
        return new JSToObjectArrayNodeGen(context, nullOrUndefinedAsEmptyArray);
    }

    @GeneratedBy(value=JSToObjectArrayNode.class)
    private static final class ForeignObject0Data
    extends Node {
        @Node.Child
        ForeignObject0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @CompilerDirectives.CompilationFinal
        BranchProfile hasPropertiesBranch_;
        @Node.Child
        ImportValueNode foreignConvertNode_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

